typedef struct {
   unsigned int num_iters;	/* number of wrapped function call iterations */
   unsigned int vectored;	/* was wrapper invoked with vectored args? */
   Slirp_Ref *master;		/* describes controlling array dimensionality */
} VecSpec;

#define push_one_element_0(func, item, type)  func(item)
#define push_one_element_1(func, item, type)  func(type, item, 0)

#define VEC_RETURN(v, rewind, sltype, pusher, typed, free_elements) \
   if (rewind && vs.vectored) v -= vs.master->array->num_elements; \
   if (vs.master) { vec_push((void*)v, &vs, sltype, free_elements); } \
   else { push_one_element_##typed(pusher, v[0], sltype); SLfree( (char*) v); }

#define VEC_ALLOC_RETVAL(type, args) \
   if ((retval = (type*)SLmalloc(vs.num_iters * sizeof(type))) == NULL) \
	{finalize_refs(args); SLang_verror(SLEI,(char*)"out of memory");return;}

#define VR(n) varg##n##_r
#define VI(n) varg##n += varg##n##_r->vstride
