/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file defines the main of an application.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skguniqueapplication.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include <kstandarddirs.h>
#include <KDE/KLocale>
#include <ksplashscreen.h>
#include <kconfiggroup.h>
#include <kcmdlineargs.h>

#include <QBitmap>

SKGUniqueApplication::SKGUniqueApplication(SKGDocument* iDoc) : KUniqueApplication(), splash(NULL), doc(iDoc), widget(NULL) {
    SKGTRACEIN(1, "SKGUniqueApplication::SKGUniqueApplication");
}

/**
 * Destructor
 */
SKGUniqueApplication::~SKGUniqueApplication() {
    SKGTRACEIN(1, "SKGUniqueApplication::~SKGUniqueApplication");
    splash=NULL;
    doc=NULL;
    widget=NULL;
}

/**
 * Create a new instance
 * @return error code
 */
int SKGUniqueApplication::newInstance() {
    SKGTRACEIN(1, "SKGUniqueApplication::newInstance");

    //Build list of arguments
    QStringList argument;
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    int nb=args->count();
    for (int i=0; i<nb ; ++i) {
        argument.push_back( args->arg(i));
    }
    args->clear(); // Free up some memory.

    //Build widget
    if (!widget) {
        //Creation splash screen
        KConfigGroup pref=SKGMainPanel::getMainConfigGroup();
        if (pref.readEntry ( "show_splash_screen",true )) {
            QString splashPathRelativePath=KCmdLineArgs::appName()+"/images/splash.png";
            QString splashPath=KStandardDirs::locate("data", splashPathRelativePath.toLatin1());
            if (!splashPath.isEmpty())
            {
                QPixmap pix(splashPath );

                splash=new KSplashScreen(pix);
                if (splash) {
                    splash->setMask(pix.createHeuristicMask());
                    splash->show();
                    splash->showMessage(i18nc("Splash screen message", "Loading ..."), Qt::AlignLeft, QColor(221, 130, 8)); // krazy:exclude=qmethods
                }
            }
            else
            {
                SKGTRACE << "WARNING: Splash screen (" << splashPathRelativePath << ") not found !" << endl;
            }
        }

        //First instance
        widget = new SKGMainPanel(splash, doc, argument);
        widget->show();
    } else {
        //Set new parameters
        widget->processArguments(argument);
    }

    if (splash) {
        splash->finish(widget);
        delete splash;
        splash=NULL;
    }

    return 0;
}
