/* Public domain. */

#ifndef CDB_MAKE_H
#define CDB_MAKE_H

#include "uint32.h"
#include "diuint32alloc.h"
#include "buffer.h"
#include "gen_alloc.h"

typedef struct cdb_make cdb_make, *cdb_make_ref ;
struct cdb_make
{
  char buf[BUFFER_OUTSIZE] ;
  diuint32alloc hplist ;
  buffer b ;
  uint32 pos ;
  int fd ;
} ;

#define CDB_MAKE_ZERO { "", GEN_ALLOC_ZERO, BUFFER_INIT(&buffer_unixwrite, -1, 0, 0), 2048, -1 }

extern int cdb_make_start (struct cdb_make *, int) ;
extern int cdb_make_add (struct cdb_make *, char const *, unsigned int, char const *, unsigned int) ;
extern int cdb_make_finish (struct cdb_make *) ;

#endif
