#ifndef _SJOG_H
#define _SJOG_H 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>


/* sony jog position */
#define JOG_BOTTOM 1
#define JOG_TOP 31
#define JOG_PUSHED 64
#define JOG_BACK 35

/* timeout for windows hide */
#define SJOG_TIMEOUT 3000

#include "sjog_debug.h"

/* options */
extern gboolean reverseBrightness;
extern gboolean useSpic;
extern gboolean mousewheelFakeKeys;
extern gboolean debug;
extern gboolean resetMenu;

typedef enum
{
   SJOG_GRAVITY_TOP_LEFT = 1,
   SJOG_GRAVITY_TOP,
   SJOG_GRAVITY_TOP_RIGHT,
   SJOG_GRAVITY_LEFT,
   SJOG_GRAVITY_CENTER,
   SJOG_GRAVITY_RIGHT,
   SJOG_GRAVITY_BOTTOM_LEFT,
   SJOG_GRAVITY_BOTTOM,
   SJOG_GRAVITY_BOTTOM_RIGHT,
   SJOG_GRAVITY_NONE
}
sjog_gravity;

extern gboolean reverseSpinDirection;
extern gboolean windowsAreTransient;
extern gchar *sonypiDevice;
extern gchar *mixerDevice;
extern sjog_gravity listWindowGravity;
extern gboolean eMenu;

/* globales */
extern GtkWidget *listWindow;
extern GtkWidget *cmdListUI;
extern guint listTimer;
extern guint selectedIndex;
extern GList *list;
extern GNode *currentTreeNode;

/* modes */
guint currentMode;

typedef enum
{
   SJOG_MODE_LIST,
   SJOG_MODE_BRIGHTNESS,
   SJOG_MODE_VOLUME,
   SJOG_MODE_SCROLL
}
sjog_mode;

void sjog_set_mode(guint mode);
guint sjog_get_mode();

typedef enum
{
	SJOG_CMD_TYPE_EXEC,
	SJOG_CMD_TYPE_MENU
}
sjog_cmd_type;

typedef struct sjog_cmd
{
   gchar *name;
   gchar *path;
   gchar *icon_path;
   sjog_cmd_type type;
}
sjog_cmd_t;


gboolean sjog_jog_posiiton_changed(gint jog);
void sjog_window_set_position(GtkWindow * window);

#endif
