/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Converter;
import com.google.doclava.ParsedTagInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.TypeInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThrowsTagInfo
extends ParsedTagInfo {
    static final Pattern PATTERN = Pattern.compile("(\\S+)\\s+(.*)", 32);
    private ClassInfo mException;

    public ThrowsTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        Matcher m = PATTERN.matcher(text);
        if (m.matches()) {
            this.setCommentText(m.group(2));
            String className = m.group(1);
            if (base instanceof ClassInfo) {
                this.mException = ((ClassInfo)base).findClass(className);
            }
            if (this.mException == null) {
                this.mException = Converter.obtainClass(className);
            }
        }
    }

    public ThrowsTagInfo(String name, String kind, String text, ClassInfo exception, String exceptionComment, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        this.mException = exception;
        this.setCommentText(exceptionComment);
    }

    public ClassInfo exception() {
        return this.mException;
    }

    public TypeInfo exceptionType() {
        if (this.mException != null) {
            return this.mException.asTypeInfo();
        }
        return null;
    }

    public static void makeHDF(Data data, String base, ThrowsTagInfo[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            TagInfo.makeHDF(data, base + '.' + i + ".comment", tags[i].commentTags());
            if (tags[i].exceptionType() == null) continue;
            tags[i].exceptionType().makeHDF(data, base + "." + i + ".type");
        }
    }
}

