/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.ObjectMarshaller;

public final class ObjectHeader {
    private final ClassMetadata _classMetadata;
    public final MarshallerFamily _marshallerFamily;
    public final ObjectHeaderAttributes _headerAttributes;
    private int _handlerVersion;

    public ObjectHeader(ObjectContainerBase objectContainerBase, Buffer buffer) {
        this(objectContainerBase, null, buffer);
    }

    public ObjectHeader(ClassMetadata classMetadata, Buffer buffer) {
        this(null, classMetadata, buffer);
    }

    public ObjectHeader(StatefulBuffer statefulBuffer) {
        this(statefulBuffer.getStream(), (Buffer)statefulBuffer);
    }

    public ObjectHeader(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, Buffer buffer) {
        int n = buffer.readInt();
        this._marshallerFamily = this.readMarshallerFamily(buffer, n);
        n = this.normalizeID(n);
        this._classMetadata = classMetadata != null ? classMetadata : objectContainerBase.classMetadataForId(n);
        this._headerAttributes = ObjectHeader.readAttributes(this._marshallerFamily, buffer);
    }

    public static ObjectHeader defrag(BufferPair bufferPair) {
        Buffer buffer = bufferPair.source();
        Buffer buffer2 = bufferPair.target();
        ObjectHeader objectHeader = new ObjectHeader(bufferPair.context().systemTrans().container(), null, buffer);
        int n = bufferPair.mapping().mappedID(objectHeader.classMetadata().getID());
        objectHeader._marshallerFamily._object.writeObjectClassID(buffer2, n);
        objectHeader._marshallerFamily._object.skipMarshallerInfo(buffer2);
        ObjectHeader.readAttributes(objectHeader._marshallerFamily, buffer2);
        return objectHeader;
    }

    public ObjectMarshaller objectMarshaller() {
        return this._marshallerFamily._object;
    }

    private MarshallerFamily readMarshallerFamily(Buffer buffer, int n) {
        boolean bl = this.marshallerAware(n);
        this._handlerVersion = 0;
        if (bl) {
            this._handlerVersion = buffer.readByte();
        }
        MarshallerFamily marshallerFamily = MarshallerFamily.version(this._handlerVersion);
        return marshallerFamily;
    }

    private static ObjectHeaderAttributes readAttributes(MarshallerFamily marshallerFamily, Buffer buffer) {
        return marshallerFamily._object.readHeaderAttributes(buffer);
    }

    private boolean marshallerAware(int n) {
        return n < 0;
    }

    private int normalizeID(int n) {
        return n < 0 ? -n : n;
    }

    public ClassMetadata classMetadata() {
        return this._classMetadata;
    }

    public int handlerVersion() {
        return this._handlerVersion;
    }
}

