/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  about
*/

#include "common.h"

static GtkWidget *about_win = NULL;


void about_show(void)
{
	char *tmp;
	GtkWidget *vb, *vb2, *lab, *hb, *b;

	if(about_win) goto out;

	about_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(about_win), _("About this fine product..."));
	gtk_window_set_position(GTK_WINDOW(about_win), GTK_WIN_POS_CENTER);
	gtk_window_set_wmclass(GTK_WINDOW(about_win), "Sinek About", "Sinek");

	vb = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vb);
	gtk_container_add(GTK_CONTAINER(about_win), vb);

	b = gtk_frame_new(NULL);
	gtk_widget_show(b);
	gtk_box_pack_start(GTK_BOX(vb), b, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(b), 5);

	vb2 = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vb2);
	gtk_container_add(GTK_CONTAINER(b), vb2);
	gtk_container_set_border_width(GTK_CONTAINER(vb2), 5);

	tmp = g_strdup_printf(_("Sinek V%s (Video Player)"), VERSION);
	lab = gtk_label_new(tmp);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	lab = gtk_label_new(_("Copyright (C) 2001 - 2002 Grer zen <madcat@users.sourceforge.net>"));
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	lab = create_url("http://sinek.sourceforge.net");
	gtk_box_pack_start(GTK_BOX(vb2), lab, TRUE, FALSE, 0);

	tmp = g_strdup_printf(_("X Vendor Release %d"), VendorRelease(sinek.display));
	lab = gtk_label_new(tmp);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	tmp = g_strdup_printf(_("Compiled with Xine library v%d.%d.%d, using v%d.%d.%d."), XINE_MAJOR_VERSION, XINE_MINOR_VERSION, XINE_SUB_VERSION, xine_get_major_version(), xine_get_minor_version(), xine_get_sub_version());
	lab = gtk_label_new(tmp);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	tmp = g_strdup_printf(_("Compiled with GTK+ library v%d.%d.%d, using v%d.%d.%d."), GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION, gtk_major_version, gtk_minor_version, gtk_micro_version);
	lab = gtk_label_new(tmp);
	gtk_widget_show(lab);
	gtk_box_pack_start(GTK_BOX(vb2), lab, FALSE, FALSE, 0);

	hb = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hb), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hb), 5);
	gtk_widget_show(hb);
	gtk_box_pack_start(GTK_BOX(vb), hb, FALSE, FALSE, 0);

	b = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(b);
	GTK_WIDGET_SET_FLAGS(b, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(hb), b, TRUE, TRUE, 0);
	gtk_widget_grab_default(b);
	gtk_signal_connect_object(GTK_OBJECT(b), "clicked", gtk_widget_hide, GTK_OBJECT(about_win));

	wm_manage(about_win, WM_MENU);
out:
	gtk_widget_show(about_win);
}
