#!/usr/bin/env python
"""Installs SimpleParse using distutils

Run:
	python setup.py install
to install the packages from the source archive.
"""

if __name__ == "__main__":
	import os
	import os, sys, string
	from distutils.command.install_data import install_data
	from distutils.sysconfig import *
	from distutils.core import setup

	def isPackage( filename ):
		return os.path.isdir(filename) and os.path.isfile( os.path.join(filename,'__init__.py'))
	def packagesFor( filename, basePackage="" ):
		"""Find all packages in filename"""
		set = {}
		for item in os.listdir(filename):
			dir = os.path.join(filename, item)
			if string.lower(item) != 'cvs' and isPackage( dir ):
				if basePackage:
					moduleName = basePackage+'.'+item
				else:
					moduleName = item
				set[ moduleName] = dir
				set.update( packagesFor( dir, moduleName))
		return set
	def npFilesFor( dirname ):
		"""Return all non-python-file filenames in dir"""
		result = []
		allResults = []
		badExtensions = ('.py','.pyc','.pyo', '.scc','.exe','.zip','.gz', '.def', '.xml')
		for name in os.listdir(dirname):
			path = os.path.join( dirname, name )
			if os.path.isfile( path) and string.lower(os.path.splitext( name )[1]) not in badExtensions:
				result.append( path )
			elif os.path.isdir( path ) and string.lower(name) !='cvs':
				allResults.extend( npFilesFor(path))
		if result:
			allResults.append( (dirname, result))
		return allResults

	##############
	## Following is from Pete Shinners,
	## apparently it will work around the reported bug on
	## some unix machines where the data files are copied
	## to weird locations if the user's configuration options
	## were entered during the wrong phase of the moon :) .
	from distutils.command.install_data import install_data
	class smart_install_data(install_data):
		def run(self):
			#need to change self.install_dir to the library dir
			install_cmd = self.get_finalized_command('install')
			self.install_dir = getattr(install_cmd, 'install_lib')
			return install_data.run(self)
	##############
	
	packages = packagesFor( "." )
##	print 'Packages:'
##	for package in packages.keys():
##		print '\t',package
	
	dataFiles = npFilesFor( './simpleparse')
##	print 'Data Files:'
##	for package in dataFiles:
##		print '\t',package
	

	setup (
		name = "SimpleParse",
		version = "2.0.0",
		description = "A Parser Generator environment w/mxTextTools back-end",
		author = "Mike C. Fletcher",
		author_email = "mcfletch@users.sourceforge.net",
		url = "http://simpleparse.sourceforge.net/",

		package_dir = packages,

		packages = packages.keys(),
		data_files = dataFiles,
		cmdclass = {'install_data':smart_install_data},
	)
