/**
 * Siege environment initialization.
 *
 * Copyright (C) 2001 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */  
#include <init.h>
#include <util.h>
char seti[128];

int
init_config( void )
{
  char filename[256];
  char buf[256];
  memset( &my, 0, sizeof( struct CONFIG )); 

  snprintf( 
    filename, sizeof( filename),
    "%s/.siegerc", getenv( "HOME" )
  );

  strcpy( my.file, SIEGE_HOME );
  strcat( my.file, "/etc/urls.txt" );
  my.debug     = FALSE;
  my.config    = FALSE;
  my.secs      = -1;
  my.reps      = -1;
  my.authorize = FALSE;
  if( load_conf( filename ) < 0 ){
    fprintf( stderr, "****************************************************\n" );
    fprintf( stderr, "siege: could not open %s\n", filename );
    fprintf( stderr, "run \'siege.config\' to generate a new .siegerc file\n" );
    fprintf( stderr, "****************************************************\n" );
    return -1;
  }

  if( strlen(my.uagent) < 1 ) 
    snprintf( 
      my.uagent, sizeof( my.uagent ),
      "JoeDog/1.00 [en] (X11; I; Siege %s)", version_string 
    );
  if(( my.username && strlen(my.username) > 0 ) &&
    (  my.password && strlen(my.password) > 0 )){
    snprintf( buf, sizeof( buf ), "%s:%s", my.username, my.password ); 
    if(( base64_encode( buf, strlen( buf ), &my.auth ) >= 0 )){
      my.authorize = TRUE;
    }
  }

  return 0;  
}

int
show_config( int EXIT )
{
  printf( "CURRENT  SIEGE  CONFIGURATION\n" );
  printf( "Edit the resource file to change the settings.\n" );
  printf( "----------------------------------------------\n" );
  printf( "user-agent:            %s\n", my.uagent );
  printf( "version:               %s\n", version_string );
  printf( "verbose:               %s\n", my.verbose?"true":"false" );
  printf( "debug:                 %s\n", my.debug?"true":"false" );
  printf( "protocol:              %s\n", my.protocol?"HTTP/1.1":"HTTP/1.0" );
  printf( "connection:            %s\n", my.keepalive?"keep-alive":"close" );
  printf( "concurrent users:      %d\n", my.cusers );
  if( my.secs > 0 )
    printf( "time to run:           %d seconds\n", my.secs );
  else
    printf( "time to run:           n/a\n" );
  if( my.reps > 0 )
    printf( "repetitions:           %d\n", my.reps );
  else
    printf( "repetitions:           n/a\n" );
  printf( "delay:                 %d sec%s\n", my.delay,my.delay>1?"s":"" );
  printf( "internet simulation:   %s\n", my.internet?"true":"false"  );
  printf( "benchmark mode:        %s\n", my.bench?"true":"false"  );
  printf( "named URL:             %s\n", my.url==NULL?"none":my.url );
  printf( "URLs file:             %s\n", 
    !strcasecmp(my.file, seti)?(strlen(seti)>0?seti:CNF_FILE):CNF_FILE );
  printf( "logging:               %s\n", my.logging?"true":"false" );
  printf( "log file:              %s\n", LOG_FILE );
  printf( "resource file:         %s/.siegerc\n", getenv( "HOME" ));
  printf( "\n" );

  if( EXIT ) exit( 0 );
  else return 0;
}

/**
 * chops the white space from
 * the beginning of a char *
 */
static char
*chomp( char *str )
{
  while( *str == ' ' || *str == '\t') {
    str++;
  }
  return str;
}   

static char
*get_line( FILE *fp )
{
  int  i = 0;
  char *ptr;
  char *new;
  char tmp[256];
 
  ptr = xmalloc( 1 );
 
  do{
    if(( fgets( tmp, sizeof( tmp ), fp )) == NULL ) return( NULL );
    if( ptr == NULL ) ptr = strdup( tmp );
    else{
      if(( ptr = xrealloc( ptr, strlen(ptr) + strlen(tmp) + 1 )) == NULL ) break;
      strcat( ptr, tmp );
    }
  } while(( new = strchr( ptr, '\n')) == NULL );
  if( new != NULL ) *new = '\0';
 
  return ptr;
} 

static char
*chomp_line( FILE *fp, char **mystr, int *line_num )
{
  char *ptr;
  while( TRUE ){
    if(( *mystr = get_line( fp )) == NULL) return( NULL );
    (*line_num)++;
    ptr = chomp( *mystr );
    /* exclude comments */
    if( *ptr != '#' && *ptr != '\0' ){
      return( ptr );
    }
  }
} 

int
load_conf( char *filename )
{
  FILE *fp;
  int  fd;
  char temp[32]; 
  int  line_num = 0;
  int  x=0;
  char *line;
  char *option;
  char *value;
 
  if (( fp = fopen(filename, "r")) == NULL ) {
    return -1;
  } 

  while(( line = chomp_line( fp, &line, &line_num )) != NULL ){
    option = line;
    while( *line && !ISSPACE( (int)*line ) && !ISSEPARATOR( *line ))
      line++;
    *line++=0;
    while( ISSPACE( (int)*line ) || ISSEPARATOR( *line ))
      line++;
    value  = line;
    while( *line )
      line++;  
    if( !strncasecmp( option, "verbose", 7   )){
      if( !strncasecmp( value, "true", 4 ))
        my.verbose = TRUE;
      else
        my.verbose = FALSE;
    } 
    if( !strncasecmp( option, "logging", 7 )){
      if( !strncasecmp( value, "true", 4 ))
        my.logging = TRUE;
      else
        my.logging = FALSE;
    }
    if( !strncasecmp( option, "show-logfile", 12 )){
      if( !strncasecmp( value, "true", 4 ))
        my.shlog = TRUE;
      else
        my.shlog = FALSE;
    }
    if( !strncasecmp( option, "concurrent", 10 )){
      my.cusers = atoi( value );
    } 
    if( !strncasecmp( option, "reps", 4 )){
      my.reps = atoi( value );
    }
    if( !strncasecmp( option, "time", 4 )){
      parse_time( value );
    }
    if( !strncasecmp( option, "delay", 5 )){
      my.delay = atoi( value );
    }
    if( !strncasecmp( option, "internet", 8 )){
      if( !strncasecmp( value, "true", 4 ))
        my.internet = TRUE;
      else
        my.internet = FALSE;
    }
    if( !strncasecmp( option, "benchmark", 9 )){
      if( !strncasecmp( value, "true", 4 )) 
        my.bench = TRUE;
      else
        my.bench = FALSE;
    }
    if( !strncasecmp( option, "debug", 5 )){
      if( !strncasecmp( value, "true", 4 ))
        my.debug = TRUE;
      else
        my.debug = FALSE;
    }
    if( !strncasecmp( option, "file", 5 )){
      strncpy( my.file, value, sizeof( my.file ));
      strncpy( seti, value, sizeof( seti ));
    }
    if( !strncasecmp( option, "url", 3 )){
      /**
       * I can't say this is a kludge, but it
       * doesn't feel right.  Basically, this 
       * function is called BEFORE the command
       * line parse, therefore if the user does
       * not offer a command line URL, then one
       * from the file is used instead.  If no
       * URLs are selected, main.length is 0 
       * and the usage is displayed.         
       */
      my.url = value;
      memset( my.file, '\0', sizeof( my.file ));
      strcpy( temp, "/tmp/siegeXXXXXX" );
      strcpy( my.file, mktemp(temp));
      if((fd = open( my.file, O_CREAT | O_WRONLY | O_EXCL, 0644 )) < 0 ) {
        joe_fatal( "Unable to write to /tmp" );
      }
      write( fd, my.url, strlen( my.url )); 
      close( fd );
    }
    if( !strncasecmp( option, "user-agent", 10 )){
      strncpy( my.uagent, value, sizeof( my.uagent ));
    }
    if( !strncasecmp( option, "username", 8 )){
      my.username = value;
    }
    if( !strncasecmp( option, "password", 8 )){
      my.password = value;
    }
    if( !strncasecmp( option, "connection", 10 )){
      if( !strncasecmp( value, "keep-alive", 10 ))
        my.keepalive = TRUE;
      else
        my.keepalive = FALSE; 
    }
    if( !strncasecmp( option, "protocol", 8 )){
      if( !strncasecmp( value, "HTTP/1.1", 8 ))
        my.protocol = TRUE;
      else
        my.protocol = FALSE; 
    }
  } /* end of while line=chomp_line */

  return 0;
}
