/* $Id: netinit.c,v 1.7 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "global.h"
#include "netinit.h"
#include "dhcp.h"
#include "libc.h"
#include "packet.h"
#include "arp.h"


net_cfg_t net_cfg;


int net_init(char *ip_devname,
	     uint32_t ip_addr,
	     uint32_t ip_net_mask,
	     uint32_t ip_gateway,
	     uint32_t ip_ns1,
	     uint32_t ip_ns2,
	     char *ip_domain)
{
    int retval = 0;
    uint64_t mac_addr = 0;
    uint8_t *hwaddr;

    if (packet_open(ip_devname)) {
	lib_printf("Open of ethernet interface '%s' failed\n",ip_devname);
	retval = -1;
	return retval;
	}

    hwaddr = packet_gethwaddr();

    for (retval = 0; retval < 6; retval++) {
	mac_addr <<= 8;
	mac_addr |= (uint64_t) hwaddr[retval];
	}

    net_cfg.mac_addr = mac_addr;
    retval = 0;
	
    if (ip_addr) {
	net_cfg.ip_addr = ip_addr;
	net_cfg.ip_net_mask = ip_net_mask;
	net_cfg.ip_gateway = ip_gateway;
	net_cfg.ip_ns1 = ip_ns1;
	net_cfg.ip_ns2 = ip_ns2;
	net_cfg.ip_domain = lib_strdup(ip_domain);
	} 
    else {
	dhcp_info_t info;
	if (!dhcp_get_boot_info(&info)) {
	    net_cfg.ip_addr = info.client_ip;
	    net_cfg.ip_net_mask = info.subnet_mask;
	    net_cfg.ip_gateway = info.gateway;
	    net_cfg.ip_ns1 = info.nameservers[0];
	    net_cfg.ip_ns2 = info.nameservers[1];
	    net_cfg.ip_domain = "";
	    } 
	else {
	    lib_printf("DHCP lookup failed\n");
	    retval = -1;
	    }
	}
    if (!retval) {
	arp_add_response(net_cfg.ip_addr, net_cfg.mac_addr);
	}

    return retval;
}

void net_uninit(void)
{
    packet_close();
}


