/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    tty.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handletty ()
//	determine the correct procedure to use
void handletty () {
	//  proc/tty in all kernels are compatible
	handlettyv22 ();
}

// handlettyv22() Function
void handlettyv22 () {
	char filename [INPUT_STRING];
	FILE *filep;
	char tmpstring [INPUT_STRING];
	int c=0;

	// Open and Process /proc/tty/drivers
	sprintf (filename, "%stty/drivers", PROCLOC);
	filep=fopen(filename, "r");
	if (filep!=NULL) {
		do {
			fgets (tmpstring, INPUT_STRING, filep);
			if (feof(filep)!=0) break;
			TTYDRIVERS[c]=malloc(TTYDRIVERS_STRUCT_SIZE);
			if (TTYDRIVERS[c]==NULL) error_handler(ERROR_MALLOC);
			TTYDRIVERS[c]->DRIVER[0]=0;
			TTYDRIVERS[c]->NAME[0]=0;
			TTYDRIVERS[c]->MAJOR[0]=0;
			TTYDRIVERS[c]->RANGE[0]=0;
			TTYDRIVERS[c]->TYPE[0]=0;
			sscanf (tmpstring, "%20s %13s %3s %7s %s", TTYDRIVERS[c]->DRIVER, TTYDRIVERS[c]->NAME, TTYDRIVERS[c]->MAJOR, TTYDRIVERS[c]->RANGE, TTYDRIVERS[c]->TYPE);
			c++;
			if (c==TTYDRIVERS_COUNT_MAX) break;
		} while (0==0);
		NUM_TTYDRIVERS=c-1;
		fclose (filep);
	}
	// Open and Process /proc/tty/ldiscs
	c=0;
	sprintf (filename, "%stty/ldiscs", PROCLOC);
	filep=fopen(filename, "r");
	if (filep==NULL) return;
	do {
		fgets (tmpstring, INPUT_STRING, filep);
		if (feof(filep)!=0) break;
		TTYLDISCS[c]=malloc(TTYLDISCS_STRUCT_SIZE);
		if (TTYLDISCS[c]==NULL) error_handler(ERROR_MALLOC);
		TTYLDISCS[c]->NAME[0]=0;
		TTYLDISCS[c]->COUNT=0;
		sscanf (tmpstring, "%10s %2d", TTYLDISCS[c]->NAME, &TTYLDISCS[c]->COUNT);
		c++;
		if (c==TTYLDISCS_COUNT_MAX) break;
	} while (0==0);
	NUM_TTYLDISCS=c-1;
	fclose (filep);
	// Return
	return;
}

