/*
    si - Version 1.0 - By Joe Turgeon (jturgeon@isd.net)
    time.c

    si - System Information Viewer
    Copyright (C) 1999  Joe Turgeon (jturgeon@isd.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"


// handletime ()
//	determine the correct procedure to use
void handletime () {
	//  proc/loadavg and uptime in all kernels are compatible
	handletimev20 ();
}

// handletimev20() Function
void handletimev20 () {
	FILE *filep;
	char filename [INPUT_STRING];
	char strsec [128];
	long int numsec;
	long int nummin;
	long int numhour;
	long int numday;

	// Open and Handle /proc/loadavg
	sprintf (filename, "%sloadavg", PROCLOC);
	filep=fopen(filename, "r");
	if (filep!=NULL) {
		fscanf (filep, "%s %s %s", PROCINFO[PROC_LOADAVG_1],
			PROCINFO[PROC_LOADAVG_5],
			PROCINFO[PROC_LOADAVG_15]);
		fclose (filep);
	}
	// Open and Handle /proc/uptime
	sprintf (filename, "%suptime", PROCLOC);
	filep=fopen(filename, "r");
	if (filep!=NULL) {
		fscanf (filep, "%s", strsec);
		UPTIME=atol(strsec);
		numsec=UPTIME;
		numday=numsec/86400;
		numhour=(numsec-(numday*86400))/3600;
		nummin=(numsec-(numday*86400)-(numhour*3600))/60;
		numsec=(numsec-(numday*86400)-(numhour*3600)-(nummin*60));
		sprintf (PROCINFO[PROC_UPTIME], "%ld Days  %ld Hours  %ld Minutes  %ld Seconds (%s Seconds)", numday, numhour, nummin, numsec, strsec);
		fclose (filep);
	}
	return;
}

