#ifndef _PACKET_HPP_
#define _PACKET_HPP_

extern "C" {
        #include <netinet/in.h>
        #include <arpa/inet.h>

	#ifdef WITH_IPQ
	#include <linux/netfilter.h>
	#include <libipq.h>
	#endif //WITH_IPQ
}

class generic_packet {
	public:
		char *inp_if;
		char *out_if;
		void *payload; 
		int payload_size;

		generic_packet() {}
		virtual ~generic_packet() {}
		virtual int send_back()=0;
		virtual void log_packet(char *buf, int n)=0;
};

#ifdef WITH_DIVERT
class divert_packet : public generic_packet {
	public:
		int sock;
		static const int buf_size = 10*1024; // gotta fix this shit
		unsigned char buf[buf_size];
		struct sockaddr_in from;

		divert_packet();
		~divert_packet();
		int send_back();
		void log_packet(char *buf, int n);
};

generic_packet *get_divert_packet(void *arg);
#endif //WITH_DIVERT

#ifdef WITH_IPQ
class ipq_packet : public generic_packet {
	public:
		static const int buf_size = NLMSG_LENGTH(0)          +
		                            sizeof(ipq_packet_msg_t) + 
		                            60 + 60;
		unsigned char buf[buf_size];
		struct ipq_handle *handle;
		ipq_packet_msg_t *meta;

	public:
		ipq_packet();
		~ipq_packet();
		int check_packet();
		int send_back();
		void log_packet(char *str, int n);
};

generic_packet *get_ipq_packet(void *arg);
#endif //WITH_IPQ
#endif //__PACKET_HPP__
