/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Sep 16 06:02:43 ART 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <iostream.h>
#include <stdlib.h>
#include "song.h"
#include "interface.h"
#include "tracker.h"
#include "player.h"
#include "mutex_lock_pthreads.h"
#include "mutex_lock_win32.h"

#include "midioutdevice.h" // null output

//unix specific
#include "gtk--/main.h"
#include "midioutdevice_oss.h" // OSS output
#include "midioutdevice_alsa.h" // OSS output
#include "midioutdevice_win32.h"

#include "timer_sigalarm.h"
#include "timer_winthreads.h"
#include "timer_rtc.h"
#include "gtk/gtk.h"
#include "glib--.h"

/******************
  COMPONENT CLASSES
*******************/

/* Interface */

Interface *gtk_interface;

/* Midi out devices */

MidiOutDevice *null_midi_device;
MidiOutDeviceManager midiout;



#ifdef OSS_ENABLED
MidiOutDevice_OSS *OSS_midi_device;
#endif
#ifdef ALSA_ENABLED
#include "alsa_client.h"
Alsa_Client alsa_client;
MidiOutDevice_ALSA *ALSA_midi_device;
#endif
#ifdef WIN32_ENABLED
MidiOut_Device_Win32 *win32_midi_device;
#endif

/* Song */

Song *song;

/* Timer */

#ifdef POSIX_ENABLED

Timer_SigAlarm timer_sigalarm;
Timer_RTC timer_rtc ;

#endif
#ifdef WIN32_ENABLED

Timer_WinThreads timer_win32;

#endif
/* Player */

Player *player;

/* Mutex */


#ifdef WIN32_ENABLED

Mutex_Lock_Win32 player_lock;

#endif
#ifdef POSIX_ENABLED

Mutex_Lock_Pthreads player_lock;
#endif
/******************
  INIT Functions
*******************/


void init_song() {

	song = new Song();
}

void init_midi_devices() {

	null_midi_device = new MidiOutDevice;
	midiout.AddDevice(null_midi_device);

#ifdef OSS_ENABLED
	OSS_midi_device = new MidiOutDevice_OSS;
	midiout.AddDevice(OSS_midi_device);
#endif
#ifdef ALSA_ENABLED

	ALSA_midi_device = new MidiOutDevice_ALSA;
	midiout.AddDevice(ALSA_midi_device);
	alsa_client.create_port();
#endif
#ifdef WIN32_ENABLED
	win32_midi_device = new MidiOut_Device_Win32;
	midiout.AddDevice(win32_midi_device);
#endif

	song->user_devices.add_device();
	song->user_devices.get_device(0)->name="Null Output";
	song->user_devices.get_device(0)->hardware_device_index=0;

}

void init_timer() {

}

void init_player() {

	player = new Player;

	player->set_song(song);
	player->set_lock(&player_lock);
	player->set_midiout(&midiout);
}

void init_interface() {

	gtk_interface = new Interface(song,player,&midiout);
#ifdef ALSA_ENABLED
	gtk_interface->set_midi_client(&alsa_client);
#endif
}


int main(int argc, char *argv[]) {

	Mutex_Lock::default_type=&player_lock; // just let this know what the default mutex type is.
	int counter=0;

	Gtk::Main kit(argc, argv);
	init_song();
	init_midi_devices();
	init_timer();
	init_player();
	init_interface();


#ifdef POSIX_ENABLED


	// Let's try with RTC!
	{
		struct sched_param schp;
		memset(&schp, 0, sizeof(schp));
		schp.sched_priority = sched_get_priority_max(SCHED_FIFO);
	
		if (sched_setscheduler(0, SCHED_FIFO, &schp) != 0) {
			
			ERROR("Cannot obtain realtime priority privileges, are you root?");
			
		}

		timer_rtc.set_player(player);
		timer_rtc.start();
	}

	if (!timer_rtc.is_active()) { // use common unix timer!

		ERROR("No RTC? Falling back to common unix timer..");
		//set 10 thread timers (sort of, increases accuracy)
	        timer_sigalarm.set_number_of_threads(10);
	        timer_sigalarm.set_player(player);
		timer_sigalarm.config(10);     
	        timer_sigalarm.start();
	}


#endif
#ifdef WIN32_ENABLED

	timer_win32.set_player(player);
	timer_win32.start();
#endif




//        timer_sigalarm->set_number_of_threads(10);
//        timer_sigalarm->set_player(player);
//	timer_sigalarm->config(10);	
//        timer_sigalarm->start();

    /*
     * set the process to real-time privs
     */



	do {

	              while (kit.events_pending()) kit.iteration();
	              if ((counter%3)==0) gtk_interface->update_info_widgets();
	              counter++;
	              gtk_interface->update_midi_input();

#ifdef POSIX_ENABLED

		usleep(10000);

#endif
#ifdef WIN32_ENABLED

		Sleep(10);

#endif

	} while (!gtk_interface->is_quit_requested());

	return EXIT_SUCCESS;
}
