#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include "sg_include.h"


/* Test code for D. Gilbert's extensions to the Linux OS SCSI generic ("sg")
   device driver.
*  Copyright (C) 1999 D. Gilbert
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2, or (at your option)
*  any later version.

   This program outputs debug information to the console/log for _all_
   active sg devices.

   Version 0.53 (990710)
*/



int main(int argc, char * argv[])
{
    int fd, res, debug;
    char ebuff[256];
    
    if ((argc != 2) || ('-' == *argv[1])) {
        printf("Usage: sg_debug <sg_device>\n");
        return 1;
    }
    fd = open(argv[1], O_RDONLY | O_NONBLOCK);
    if (fd < 0) {
        if (EBUSY == errno)
            printf("Failed trying to open %s because it is busy\n", argv[1]);
        else {
            sprintf(ebuff, "sg_debug: Error trying to open %s ", argv[1]);
            perror(ebuff);
        }
        return 1;
    }

    debug = 10;
    res = ioctl(fd, SG_SET_DEBUG, &debug);
    if (res < 0) {
        perror("sg_debug: ioctl error on SG_SET_DEBUG");
        return 1;
    }
    
    res = close(fd);
    if (res < 0) {
        sprintf(ebuff, "sg_debug: trying to close %s ", argv[1]);
        perror(ebuff);
        return 1;
    }
    return 0;
}
