// -*-c++-*-
/* $Id: tempfile.h,v 1.1 1999/09/28 02:40:22 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "str.h"

class tempfile {
  friend class tempfileout;

  int fd;
  int err;
  str path;
  strbuf buf;

  void destroy ();
  void flush (bool force = false);

public:
  tempfile (const str &path, mode_t mode);
  ~tempfile () { destroy (); }
  bool rename (str dest);
};

class tempfileout : public strbuf {
  tempfile *tfp;

public:
  tempfileout (tempfile &tf) : strbuf (tf.buf), tfp (&tf) {}
  ~tempfileout () { tfp->flush (); }
};

template<class T> inline const strbuf &
operator<< (const tempfileout &o, const T &a)
{
  return strbuf_cat (o, a);
}
inline const strbuf &
operator<< (const tempfileout &o, const str &s)
{
  suio_print (o.tosuio (), s);
  return o;
}
// XXX - gcc bug requires this:
inline const strbuf &
operator<< (const tempfileout &o, const char *a)
{
  return strbuf_cat (o, a);
}
