#!/usr/bin/python

# convert output extracted from ergane into .tei format
# output should already be in utf-8
# you should replace '@' in resulting tei with spaces
# experanto translations are preserved
# THIS IS DOG SLOW because the esperanto translations
# are converted from post-h into utf8 with konwert


import sys, string, popen2, kjbuckets

def konwert(s, fr, to, par=""):
    if fr==to:
        return s
    pout, pin = popen2.popen2("konwert %s-%s%s" % (fr, to, par))
    pin.write(s)
    pin.close()
    ns = pout.read()
    pout.close()
    return ns


f = open(sys.argv[1], "r")



def teiheader():
    print """<!DOCTYPE TEI.2       PUBLIC "-//TEI P3//DTD Main Document Type//EN"  [
   <!ENTITY % TEI.dictionaries "INCLUDE" >
]>

<tei.2>
  <teiHeader>
    <filedesc>
      <titlestmt>
        <title>           </title>
      </titlestmt>
      <publicationstmt>
        <authority>Freedict.de</authority>
      </publicationstmt>
      <sourcedesc>
        <p>http://www.freedict.de</p>
      </sourcedesc>
    </filedesc>
  </teiHeader>
"""    

words = {}

block = ""

teiheader()
print "<text>"
print "<body>"

lines = f.readlines()

i=0

while 1:
    #i = readblock(f) # or f.readline
    l = lines[i]
    assert l[0]<>' '
    header = string.strip(l)
    trans = []
    while 1:
        i = i+1
        if i>=len(lines):
            break
        ll = lines[i]
        if ll[0]<>' ':
            break
        ll = string.strip(ll[4:])
        a = string.find(ll, '(')
        if a>0:
            b = string.rfind(ll, ')')
            esp = ll[a+1:b]
            ll = string.strip(ll[:a]+ll[b+1:])
            ### komment this out and you will get rid of esperanto translations
            ### it will be much faster, too
            esp = konwert(esp, 'hmetodo', 'UTF8')
            esp = string.replace(esp, '@', 'ux')
            esp = konwert(esp, 'xmetodo', 'UTF8')
            ###
        trans.append("%s (%s)" % (ll, esp))
        #trans.append(ll)
    trans = kjbuckets.kjSet(trans).items()
                
    print "<entry>"
    print "  <form>"
    print "    <orth>"+header+"</orth>"
    print "  </form>"
    print "  <trans>"
    for k in trans:
        print "    <tr>"+k+"</tr>"
    print "  </trans>"
    print "</entry>"

    if i>=len(lines):
        break

print "</body>"
print "</text>"

print "</tei.2>"
