<?php # $Id: config_local.inc.php 2231 2008-04-16 10:11:12Z garvinhicking $
# Copyright (c) 2003-2005, Jannis Hermanns (on behalf the Serendipity Developer Team)
# All rights reserved.  See LICENSE file for licensing details

    // Here be dragons and NO application logic!

    $res = array();
    $res['database'] =
             array('title'       => INSTALL_CAT_DB,
                   'description' => INSTALL_CAT_DB_DESC,
                   'items' => array(array('var'         => 'dbType',
                                          'title'       => INSTALL_DBTYPE,
                                          'description' => INSTALL_DBTYPE_DESC,
                                          'type'        => 'list',
                                          'default'     => array(),
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave', 'simpleInstall', 'probeDefault')),

                                    array('var'         => 'dbHost',
                                          'title'       => INSTALL_DBHOST,
                                          'description' => INSTALL_DBHOST_DESC,
                                          'type'        => 'string',
                                          'default'     => 'localhost',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave', 'simpleInstall')),

                                    array('var'         => 'dbUser',
                                          'title'       => INSTALL_DBUSER,
                                          'description' => INSTALL_DBUSER_DESC,
                                          'type'        => 'string',
                                          'default'     => 'serendipity',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave', 'simpleInstall')),

                                    array('var'         => 'dbPass',
                                          'title'       => INSTALL_DBPASS,
                                          'description' => INSTALL_DBPASS_DESC,
                                          'type'        => 'protected',
                                          'default'     => '',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave', 'hideValue', 'simpleInstall')),

                                    array('var'         => 'dbName',
                                          'title'       => INSTALL_DBNAME,
                                          'description' => INSTALL_DBNAME_DESC,
                                          'type'        => 'string',
                                          'default'     => 'serendipity',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave', 'simpleInstall')),

                                    array('var'         => 'dbPrefix',
                                          'title'       => INSTALL_DBPREFIX,
                                          'description' => INSTALL_DBPREFIX_DESC,
                                          'type'        => 'string',
                                          'default'     => 'serendipity_',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave')),

                                    array('var'         => 'dbPersistent',
                                          'title'       => INSTALL_DBPERSISTENT,
                                          'description' => INSTALL_DBPERSISTENT_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('nosave')),

                                    array('var'         => 'dbNames',
                                          'title'       => INSTAL_DB_UTF8,
                                          'description' => INSTAL_DB_UTF8_DESC,
                                          'type'        => 'bool',
                                          'default'     => true,
                                          'permission'  => 'siteConfiguration')
                                ));

    $res['paths'] =
             array('title'          => INSTALL_CAT_PATHS,
                   'description'    => INSTALL_CAT_PATHS_DESC,
                   'items' => array(array('var'         => 'serendipityPath',
                                          'title'       => INSTALL_FULLPATH,
                                          'description' => INSTALL_FULLPATH_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => '/webroot/serendipity/'),

                                    array('var'         => 'uploadPath',
                                          'title'       => INSTALL_UPLOADPATH,
                                          'description' => INSTALL_UPLOADPATH_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'uploads/'),

                                    array('var'         => 'serendipityHTTPPath',
                                          'title'       => INSTALL_RELPATH,
                                          'description' => INSTALL_RELPATH_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => '/serendipity/'),

                                    array('var'         => 'templatePath',
                                          'title'       => INSTALL_RELTEMPLPATH,
                                          'description' => INSTALL_RELTEMPLPATH_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'templates/'),

                                    array('var'         => 'uploadHTTPPath',
                                          'title'       => INSTALL_RELUPLOADPATH,
                                          'description' => INSTALL_RELUPLOADPATH_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'uploads/'),

                                    array('var'         => 'baseURL',
                                          'title'       => INSTALL_URL,
                                          'description' => INSTALL_URL_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'http://www.example.com/serendipity/'),

                                    array('var'         => 'autodetect_baseURL',
                                          'title'       => INSTALL_AUTODETECT_URL,
                                          'description' => INSTALL_AUTODETECT_URL_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => false),

                                    array('var'         => 'indexFile',
                                          'title'       => INSTALL_INDEXFILE,
                                          'description' => INSTALL_INDEXFILE_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'index.php'),
                                ));


    $res['permalinks'] =
             array('title'          => INSTALL_CAT_PERMALINKS,
                   'description'    => INSTALL_CAT_PERMALINKS_DESC,
                   'items' => array(
                                    array('var'         => 'permalinkStructure',
                                          'title'       => INSTALL_PERMALINK,
                                          'description' => INSTALL_PERMALINK_DESC,
                                          'type'        => 'string',
                                          'default'     => 'archives/%id%-%title%.html',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkAuthorStructure',
                                          'title'       => INSTALL_PERMALINK_AUTHOR,
                                          'description' => INSTALL_PERMALINK_AUTHOR_DESC,
                                          'type'        => 'string',
                                          'default'     => 'authors/%id%-%realname%',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkCategoryStructure',
                                          'title'       => INSTALL_PERMALINK_CATEGORY,
                                          'description' => INSTALL_PERMALINK_CATEGORY_DESC,
                                          'type'        => 'string',
                                          'default'     => 'categories/%id%-%name%',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkFeedCategoryStructure',
                                          'title'       => INSTALL_PERMALINK_FEEDCATEGORY,
                                          'description' => INSTALL_PERMALINK_FEEDCATEGORY_DESC,
                                          'type'        => 'string',
                                          'default'     => 'feeds/categories/%id%-%name%.rss',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkFeedAuthorStructure',
                                          'title'       => INSTALL_PERMALINK_FEEDAUTHOR,
                                          'description' => INSTALL_PERMALINK_FEEDAUTHOR_DESC,
                                          'type'        => 'string',
                                          'default'     => 'feeds/authors/%id%-%realname%.rss',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkArchivesPath',
                                          'title'       => INSTALL_PERMALINK_ARCHIVESPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'archives',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkArchivePath',
                                          'title'       => INSTALL_PERMALINK_ARCHIVEPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'archive',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkCategoriesPath',
                                          'title'       => INSTALL_PERMALINK_CATEGORIESPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'categories',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkAuthorsPath',
                                          'title'       => INSTALL_PERMALINK_AUTHORSPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'authors',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkUnsubscribePath',
                                          'title'       => INSTALL_PERMALINK_UNSUBSCRIBEPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'unsubscribe',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkDeletePath',
                                          'title'       => INSTALL_PERMALINK_DELETEPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'delete',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkApprovePath',
                                          'title'       => INSTALL_PERMALINK_APPROVEPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'approve',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkFeedsPath',
                                          'title'       => INSTALL_PERMALINK_FEEDSPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'feeds',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkPluginPath',
                                          'title'       => INSTALL_PERMALINK_PLUGINPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'plugin',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkAdminPath',
                                          'title'       => INSTALL_PERMALINK_ADMINPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'admin',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkSearchPath',
                                          'title'       => INSTALL_PERMALINK_SEARCHPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'search',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                                    array('var'         => 'permalinkCommentsPath',
                                          'title'       => INSTALL_PERMALINK_COMMENTSPATH,
                                          'description' => '',
                                          'type'        => 'string',
                                          'default'     => 'comments',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('ifEmpty')),

                    )
            );

    $res['settings'] =
             array('title'          => INSTALL_CAT_SETTINGS,
                   'description'    => INSTALL_CAT_SETTINGS_DESC,
                   'items' => array(array('var'         => 'user',
                                          'title'       => INSTALL_USERNAME,
                                          'description' => INSTALL_USERNAME_DESC,
                                          'type'        => 'string',
                                          'default'     => 'John Doe',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('installOnly', 'local', 'simpleInstall')),

                                    array('var'         => 'pass',
                                          'title'       => INSTALL_PASSWORD,
                                          'description' => INSTALL_PASSWORD_DESC,
                                          'type'        => 'protected',
                                          'default'     => 'john',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('installOnly', 'local', 'simpleInstall')),

                                    array('var'         => 'realname',
                                          'title'       => USERCONF_REALNAME,
                                          'description' => USERCONF_REALNAME_DESC,
                                          'type'        => 'string',
                                          'default'     => 'John Doe',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('installOnly', 'local', 'simpleInstall')),

                                    array('var'         => 'email',
                                          'title'       => INSTALL_EMAIL,
                                          'description' => INSTALL_EMAIL_DESC,
                                          'type'        => 'string',
                                          'default'     => 'john@example.com',
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('installOnly', 'local', 'simpleInstall')),

                                    array('var'         => 'want_mail',
                                          'title'       => INSTALL_SENDMAIL,
                                          'description' => INSTALL_SENDMAIL_DESC,
                                          'type'        => 'bool',
                                          'default'     => true,
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('installOnly', 'local')),

                                    array('var'         => 'allowSubscriptions',
                                          'title'       => INSTALL_SUBSCRIBE,
                                          'description' => INSTALL_SUBSCRIBE_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => true),

                                    array('var'         => 'blogTitle',
                                          'title'       => INSTALL_BLOGNAME,
                                          'description' => INSTALL_BLOGNAME_DESC,
                                          'type'        => 'string',
                                          'default'     => 'John Doe\'s personal blog',
                                          'permission'  => 'blogConfiguration',
                                          'flags'       => array('simpleInstall')),

                                    array('var'         => 'blogDescription',
                                          'title'       => INSTALL_BLOGDESC,
                                          'description' => INSTALL_BLOGDESC_DESC,
                                          'type'        => 'string',
                                          'default'     => 'My little place on the web...',
                                          'permission'  => 'blogConfiguration',
                                          'flags'       => array('simpleInstall')),

                                    array('var'         => 'blogMail',
                                          'title'       => INSTALL_BLOG_EMAIL,
                                          'description' => INSTALL_BLOG_EMAIL_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => ''),

                                    array('var'         => 'lang',
                                          'title'       => INSTALL_LANG,
                                          'description' => INSTALL_LANG_DESC,
                                          'type'        => 'list',
                                          'default'     => $serendipity['languages'],
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('simpleInstall')),

                                    array('var'         => 'charset',
                                          'title'       => INSTALL_CHARSET,
                                          'description' => INSTALL_CHARSET_DESC,
                                          'type'        => 'list',
                                          'default'     => $serendipity['charsets'],
                                          'permission'  => 'siteConfiguration'),

                                    array('var'         => 'calendar',
                                          'title'       => INSTALL_CAL,
                                          'description' => INSTALL_CAL_DESC,
                                          'type'        => 'list',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => $serendipity['calendars']),

                                    array('var'         => 'lang_content_negotiation',
                                          'title'       => AUTOLANG,
                                          'description' => AUTOLANG_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'enablePluginACL',
                                          'title'       => PERMISSION_FORBIDDEN_ENABLE,
                                          'description' => PERMISSION_FORBIDDEN_ENABLE_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'blogConfiguration'),
                            ));

    $res['display'] =
             array('title'          => INSTALL_CAT_DISPLAY,
                   'description'    => INSTALL_CAT_DISPLAY_DESC,
                   'items' => array(array('var'         => 'fetchLimit',
                                          'title'       => INSTALL_FETCHLIMIT,
                                          'description' => INSTALL_FETCHLIMIT_DESC,
                                          'type'        => 'int',
                                          'default'     => 15,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'RSSfetchLimit',
                                          'title'       => INSTALL_RSSFETCHLIMIT,
                                          'description' => INSTALL_RSSFETCHLIMIT_DESC,
                                          'type'        => 'int',
                                          'default'     => 15,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'enforce_RFC2616',
                                          'title'       => SYNDICATION_RFC2616,
                                          'description' => SYNDICATION_RFC2616_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'useGzip',
                                          'title'       => INSTALL_USEGZIP,
                                          'description' => INSTALL_USEGZIP_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => false),

                                    array('var'         => 'wysiwyg',
                                          'title'       => INSTALL_WYSIWYG,
                                          'description' => INSTALL_WYSIWYG_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'blogConfiguration',
                                          'flags'       => array('simpleInstall', 'installOnly')),

                                    array('var'         => 'enablePopup',
                                          'title'       => INSTALL_POPUP,
                                          'description' => INSTALL_POPUP_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'embed',
                                          'title'       => INSTALL_EMBED,
                                          'description' => INSTALL_EMBED_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'false'),

                                    array('var'         => 'top_as_links',
                                          'title'       => INSTALL_SHOW_EXTERNAL_LINKS,
                                          'description' => INSTALL_SHOW_EXTERNAL_LINKS_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => false),

                                    array('var'         => 'trackReferrer',
                                          'title'       => INSTALL_TRACKREF,
                                          'description' => INSTALL_TRACKREF_DESC,
                                          'type'        => 'bool',
                                          'default'     => true,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'blockReferer',
                                          'title'       => INSTALL_BLOCKREF,
                                          'description' => INSTALL_BLOCKREF_DESC,
                                          'type'        => 'string',
                                          'default'     => ';',
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'rewrite',
                                          'title'       => INSTALL_REWRITE,
                                          'description' => INSTALL_REWRITE_DESC,
                                          'type'        => 'list',
                                          'default'     => array(),
                                          'permission'  => 'siteConfiguration',
                                          'flags'       => array('probeDefault')),

                                    array('var'         => 'serverOffsetHours',
                                          'title'       => INSTALL_OFFSET,
                                          'description' => INSTALL_OFFSET_DESC,
                                          'type'        => 'int',
                                          'default'     => 0,
                                          'permission'  => 'blogConfiguration',
                                          'flags'       => array('parseDescription')),

                                    array('var'         => 'showFutureEntries',
                                          'title'       => INSTALL_SHOWFUTURE,
                                          'description' => INSTALL_SHOWFUTURE_DESC,
                                          'type'        => 'bool',
                                          'default'     => false,
                                          'permission'  => 'blogConfiguration'),

                                    array('var'         => 'enableACL',
                                          'title'       => INSTALL_ACL,
                                          'description' => INSTALL_ACL_DESC,
                                          'type'        => 'bool',
                                          'default'     => true,
                                          'permission'  => 'blogConfiguration'),
                            ));

    $res['imagehandling'] =
             array('title' => INSTALL_CAT_IMAGECONV,
                   'description' => INSTALL_CAT_IMAGECONV_DESC,
                   'items' => array(array('var'         => 'magick',
                                          'title'       => INSTALL_IMAGEMAGICK,
                                          'description' => INSTALL_IMAGEMAGICK_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => false),

                                    array('var'         => 'convert',
                                          'title'       => INSTALL_IMAGEMAGICKPATH,
                                          'description' => INSTALL_IMAGEMAGICKPATH_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => '/usr/local/bin/convert'),

                                    array('var'         => 'thumbSuffix',
                                          'title'       => INSTALL_THUMBSUFFIX,
                                          'description' => INSTALL_THUMBSUFFIX_DESC,
                                          'type'        => 'string',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 'serendipityThumb'),

                                    array('var'         => 'thumbSize',
                                          'title'       => INSTALL_THUMBWIDTH,
                                          'description' => INSTALL_THUMBWIDTH_DESC,
                                          'type'        => 'int',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => 110),

                                    array('var'         => 'maxFileSize',
                                          'title'       => MEDIA_UPLOAD_SIZE,
                                          'description' => MEDIA_UPLOAD_SIZE_DESC,
                                          'type'        => 'int',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => ''),

                                    array('var'         => 'maxImgWidth',
                                          'title'       => MEDIA_UPLOAD_MAXWIDTH,
                                          'description' => MEDIA_UPLOAD_MAXWIDTH_DESC,
                                          'type'        => 'int',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => ''),

                                    array('var'         => 'maxImgHeight',
                                          'title'       => MEDIA_UPLOAD_MAXHEIGHT,
                                          'description' => MEDIA_UPLOAD_MAXHEIGHT_DESC,
                                          'type'        => 'int',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => ''),

                                    array('var'         => 'onTheFlySynch',
                                          'title'       => ONTHEFLYSYNCH,
                                          'description' => ONTHEFLYSYNCH_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => true),

                                    array('var'         => 'dynamicResize',
                                          'title'       => MEDIA_DYN_RESIZE,
                                          'description' => MEDIA_DYN_RESIZE_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => false),

                                    array('var'         => 'mediaExif',
                                          'title'       => MEDIA_EXIF,
                                          'description' => MEDIA_EXIF_DESC,
                                          'type'        => 'bool',
                                          'permission'  => 'siteConfiguration',
                                          'default'     => true),

                                    array('var'         => 'mediaProperties',
                                          'title'       => MEDIA_PROP,
                                          'description' => MEDIA_PROP_DESC . MEDIA_PROP_MULTIDESC,
                                          'type'        => 'string',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => 'DPI:IMAGE;RUN_LENGTH:VIDEO:AUDIO;DATE;COPYRIGHT;TITLE;COMMENT1:MULTI;COMMENT2:MULTI'),

                                    array('var'         => 'mediaKeywords',
                                          'title'       => MEDIA_KEYWORDS,
                                          'description' => MEDIA_KEYWORDS_DESC,
                                          'type'        => 'textarea',
                                          'permission'  => 'blogConfiguration',
                                          'default'     => ''),
                            ));

    return $res;
?>
