#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: gustaf_mate_joining
class: CommandLineTool
cwlVersion: v1.0
doc: "Joining two paired-end files into one file with joined (single-end) reads. Automatically\
  \ reverse-complements reads of the second input file.\nThis simple program takes\
  \ as input two mate pair or paired-end files and outputs a file where both mate\
  \ sequences have been joined together. The FASTA file with joined mates is an required\
  \ input file for the paired-end mode of Gustaf. The tool assumes the mates in the\
  \ second file to be reverse complemented compared to the first file. This behaviour\
  \ can be turned off using the command line argument \"-rc\".\nGiven only one input\
  \ file and two output files, the program will split the reads from the input files\
  \ at half length, and write the first half of each sequence as mates1 into the first\
  \ output file and the reversed complemented second half of each sequence as mates2\
  \ into the second output file. Reverse complementing the sequences can again be\
  \ turned off using \"-rc\".\nTo prepare the joined mate file for the Gustaf paired-end\
  \ example, call \n ./gustaf_mate_joining adeno_modified_reads_mates1.fa adeno_modified_reads_mates2.fa\
  \ -rc -o adeno_modified_reads_joinedMates.fa\n\n\n\nFor more information, visit\
  \ http://www.seqan.de"
inputs:
- default: "['joined_mates.fa']"
  doc: Filename for outPath output file
  id: param_outPath_filename
  inputBinding:
    prefix: -outPath
  label: Filename for outPath output file
  type:
  - 'null'
  - string
- default: 'false'
  doc: Disable reverse complementing second input file.
  id: param_revcompl
  inputBinding:
    prefix: -revcompl
  label: Disable reverse complementing second input file.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- doc: ''
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: ''
  type: File
label: Joining paired-end files.
outputs:
- doc: Set name of output FASTA/FASTQ file(s).
  id: param_outPath
  label: Set name of output FASTA/FASTQ file(s).
  outputBinding:
    glob: $(inputs.param_outPath_filename)
  type:
  - 'null'
  - File
