// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_GRAPH_MSA_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_MSA_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BlastLib_

struct BlastLib_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(68)

//____________________________________________________________________________
// FractionalScore_

struct FractionalScore_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(64)

//____________________________________________________________________________
// FrequencyCounting_

struct FrequencyCounting_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(73)

//____________________________________________________________________________
// GlobalPairwiseLibrary_

struct GlobalPairwiseLibrary_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(64)

//____________________________________________________________________________
// KmerDistance_

struct KmerDistance_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(63)

//____________________________________________________________________________
// KmerLibrary_

struct KmerLibrary_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(83)

//____________________________________________________________________________
// LcsLibrary_

struct LcsLibrary_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(93)

//____________________________________________________________________________
// LessMsaEdgeCargo_

template <typename TVertexDescriptor, typename TCargo> struct LessMsaEdgeCargo_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(279)

//____________________________________________________________________________
// LibraryDistance_

struct LibraryDistance_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(54)

//____________________________________________________________________________
// LocalPairwiseLibrary_

struct LocalPairwiseLibrary_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(74)

//____________________________________________________________________________
// MsaEdgeCargo_

template <typename TVertexDescriptor, typename TCargo> struct MsaEdgeCargo_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(261)

//____________________________________________________________________________
// MsaOptions

template <typename TAlphabet, typename TScore> struct MsaOptions;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(40)

//____________________________________________________________________________
// MummerLib_

struct MummerLib_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(79)

//____________________________________________________________________________
// NewickFormat_

struct NewickFormat_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(91)

//____________________________________________________________________________
// ProfileProfileScore

template <typename T> struct ProfileProfileScore;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(84)

//____________________________________________________________________________
// ReScore_

struct ReScore_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(81)

//____________________________________________________________________________
// TCoffeeLib_

struct TCoffeeLib_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(57)

//____________________________________________________________________________
// UpgmaAvg_

struct UpgmaAvg_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(314)

//____________________________________________________________________________
// UpgmaMax_

struct UpgmaMax_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(303)

//____________________________________________________________________________
// UpgmaMin_

struct UpgmaMin_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(292)

//____________________________________________________________________________
// UpgmaWeightAvg_

struct UpgmaWeightAvg_;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(325)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BlastLib

typedef Tag<BlastLib_> const BlastLib;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(69)

//____________________________________________________________________________
// FractionalScore

typedef Tag<FractionalScore_> const FractionalScore;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(65)

//____________________________________________________________________________
// FrequencyCounting

typedef Tag<FrequencyCounting_> const FrequencyCounting;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(74)

//____________________________________________________________________________
// GlobalPairwiseLibrary

typedef Tag<GlobalPairwiseLibrary_> const GlobalPairwiseLibrary;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(65)

//____________________________________________________________________________
// KmerDistance

typedef Tag<KmerDistance_> const KmerDistance;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(64)

//____________________________________________________________________________
// KmerLibrary

typedef Tag<KmerLibrary_> const KmerLibrary;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(84)

//____________________________________________________________________________
// LcsLibrary

typedef Tag<LcsLibrary_> const LcsLibrary;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(94)

//____________________________________________________________________________
// LibraryDistance

typedef Tag<LibraryDistance_> const LibraryDistance;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(55)

//____________________________________________________________________________
// LocalPairwiseLibrary

typedef Tag<LocalPairwiseLibrary_> const LocalPairwiseLibrary;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(75)

//____________________________________________________________________________
// MummerLib

typedef Tag<MummerLib_> const MummerLib;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(80)

//____________________________________________________________________________
// NewickFormat

typedef Tag<NewickFormat_> const NewickFormat;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(92)

//____________________________________________________________________________
// ReScore

typedef Tag<ReScore_> const ReScore;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(82)

//____________________________________________________________________________
// TCoffeeLib

typedef Tag<TCoffeeLib_> const TCoffeeLib;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(58)

//____________________________________________________________________________
// UpgmaAvg

typedef Tag<UpgmaAvg_> const UpgmaAvg;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(315)

//____________________________________________________________________________
// UpgmaMax

typedef Tag<UpgmaMax_> const UpgmaMax;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(304)

//____________________________________________________________________________
// UpgmaMin

typedef Tag<UpgmaMin_> const UpgmaMin;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(293)

//____________________________________________________________________________
// UpgmaWeightAvg

typedef Tag<UpgmaWeightAvg_> const UpgmaWeightAvg;       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(326)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _appendFragment

template <typename TSizeSpec, typename TSpec1, typename TSpec2, typename TSize> inline void _appendFragment(String<Fragment<TSizeSpec, ExactReversableFragment<TSpec1> >, TSpec2>& matches, TSize seq1Id, TSize beg1, TSize seq2Id, TSize beg2, TSize len, bool reversed);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(525)
template <typename TSizeSpec, typename TSpec1, typename TSpec2, typename TSize> inline void _appendFragment(String<Fragment<TSizeSpec, ExactFragment<TSpec1> >, TSpec2>& matches, TSize seq1Id, TSize beg1, TSize seq2Id, TSize beg2, TSize len, bool reversed);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(542)

//____________________________________________________________________________
// _appendNewMatch

template <typename TPos, typename TSpec2, typename TSpec1, typename TScores, typename TId, typename TSize> inline void _appendNewMatch(String<Fragment<TPos, ExactReversableFragment<TSpec2> >, TSpec1>& matches, TScores& scores, TId seq1Id, TId seq2Id, TSize beg1, TSize beg2, TSize len, bool);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(725)
template <typename TPos, typename TSpec2, typename TSpec1, typename TScores, typename TId, typename TSize> inline void _appendNewMatch(String<Fragment<TPos, ExactFragment<TSpec2> >, TSpec1>& matches, TScores& scores, TId seq1Id, TId seq2Id, TSize beg1, TSize beg2, TSize len, bool reversed);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(743)

//____________________________________________________________________________
// _appendSegmentMatches

template <typename TStrSpec, typename TSpec, typename TList, typename TScore, typename TSegmentMatches, typename TScores> inline void _appendSegmentMatches(StringSet<String<AminoAcid, TStrSpec>, Dependent<TSpec> > const& str, TList const& pList, TScore const&, TSegmentMatches& matches, TScores& scores);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(183)
template <typename TValue, typename TStrSpec, typename TSpec, typename TList, typename TScore, typename TSegmentMatches, typename TScores> inline void _appendSegmentMatches(StringSet<String<TValue, TStrSpec>, Dependent<TSpec> > const& str, TList const& pList, TScore const& score_type, TSegmentMatches& matches, TScores& scores);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(197)

//____________________________________________________________________________
// _buildLeafString

template <typename TStringSet, typename TCargo, typename TSpec, typename TPosition, typename TSequence> inline void _buildLeafString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TPosition const pos, TSequence& alignSeq);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(50)

//____________________________________________________________________________
// _buildNewickString

template <typename TCargo, typename TSpec, typename TNames, typename TNewickString, typename TVertexDescriptor> void _buildNewickString(Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, TNewickString& str, TVertexDescriptor v, bool collapseRoot);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(942)

//____________________________________________________________________________
// _collectSegmentMatches

template <typename TValue, typename TSpec2, typename TFragment, typename TSpec, typename TScores, typename TSize> void _collectSegmentMatches(String<TValue, TSpec2> const& mat, String<TFragment, TSpec>& matches, TScores& scores, TSize nseq);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(395)

//____________________________________________________________________________
// _createAlignmentGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TOutGraph> inline void _createAlignmentGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TOutGraph& gOut);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(84)

//____________________________________________________________________________
// _createMatchingGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TEdgeMap, typename TOutGraph> inline void _createMatchingGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TEdgeMap& edgeMap, TOutGraph& gOut, TEdgeMap& edgeMapOut);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(202)

//____________________________________________________________________________
// _debugMatches

template <typename TStringSet, typename TMatches> void _debugMatches(TStringSet& str, TMatches& matches);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(416)

//____________________________________________________________________________
// _debugRefinedMatches

template <typename TGraph> void _debugRefinedMatches(TGraph& g);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(453)

//____________________________________________________________________________
// _getTupelString

template <typename TString, typename TTupelString, typename TKTup, typename TAlphabet> inline void _getTupelString(TString const& str, TTupelString& tupelString, TKTup const ktup, TAlphabet);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_kmer.h"(51)

//____________________________________________________________________________
// _matchScore

template <typename TScore, typename TSc> inline void _matchScore(TScore&, TSc);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(45)
template <typename TValue, typename TSc> inline void _matchScore(Score<TValue, Simple>& sc, TSc msc);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(65)

//____________________________________________________________________________
// _mismatchScore

template <typename TScore, typename TSc> inline void _mismatchScore(TScore&, TSc);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(55)
template <typename TValue, typename TSc> inline void _mismatchScore(Score<TValue, Simple>& sc, TSc mmsc);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(75)

//____________________________________________________________________________
// _msaRefinement

template <typename TValue, typename TSpec, typename TSize, typename TAlphabet, typename TScore> inline void _msaRefinement(String<TValue, TSpec>& mat, TSize nseq, TSize splitPos, TScore& sc, TAlphabet);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(286)

//____________________________________________________________________________
// _recursiveProgressiveMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence> inline void _recursiveProgressiveMatching(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(429)

//____________________________________________________________________________
// _resizeWithRespectToDistance

template <typename TValue, typename TSpec, typename TSize> inline void _resizeWithRespectToDistance(String<TValue, TSpec>& dist, TSize nseq);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(375)
template <typename TCargo, typename TSpec, typename TSize> inline void _resizeWithRespectToDistance(Graph<Undirected<TCargo, TSpec> >& dist, TSize nseq);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(385)
template <typename TSize> inline void _resizeWithRespectToDistance(Nothing&, TSize);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(397)

//____________________________________________________________________________
// _scoreMatches

template <typename TString, typename TSpec, typename TScoreType, typename TSize, typename TSpec2, typename TScoreString, typename TScoreValue> inline void _scoreMatches(StringSet<TString, TSpec> const& seqSet, TScoreType const& scType, String<Fragment<TSize, ExactFragment<> >, TSpec2> const& matches, TScoreString& scores, TScoreValue offset);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(187)
template <typename TString, typename TSpec, typename TScoreType, typename TFragment, typename TSpec2, typename TScoreString> inline void _scoreMatches(StringSet<TString, TSpec> const& seqSet, TScoreType const& scType, String<TFragment, TSpec2> const& matches, TScoreString& scores);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(226)

//____________________________________________________________________________
// _setDistanceValue

template <typename TFragment, typename TSpec1, typename TString, typename TSpec2, typename TValue, typename TSpec, typename TSize> inline void _setDistanceValue(String<TFragment, TSpec1>& matches, StringSet<TString, TSpec2>& pairSet, String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, TSize from);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(412)
template <typename TFragment, typename TSpec1, typename TString, typename TSpec2, typename TCargo, typename TSpec, typename TSize> inline void _setDistanceValue(String<TFragment, TSpec1>& matches, StringSet<TString, TSpec2>& pairSet, Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, TSize from);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(441)
template <typename TFragment, typename TSpec, typename TString, typename TSpec2, typename TSize> inline void _setDistanceValue(String<TFragment, TSpec>&, StringSet<TString, TSpec2>&, Nothing&, TSize, TSize, TSize, TSize);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(468)

//____________________________________________________________________________
// _subTreeSearch

template <typename TGuideTree, typename TSeqGroups, typename TGroupRoot, typename TSize> inline void _subTreeSearch(TGuideTree& guideTree, TSeqGroups& seqGroups, TGroupRoot& groupRoot, TSize minMembers);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(370)

//____________________________________________________________________________
// _upgmaTreeMerge

template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaWeightAvg);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(340)
template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaAvg);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(370)
template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaMin);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(396)
template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaMax);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(421)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMax);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(444)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMin);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(478)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const& active, TEdgeDescriptor best, UpgmaWeightAvg);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(511)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaAvg);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(547)

//____________________________________________________________________________
// alignmentEvaluation

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TSize> inline typename Value<TScore>::Type alignmentEvaluation(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type, TSize& gapExCount, TSize& gapCount, TSize& pairCount, String<TSize>& numPairs, TSize& len);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(881)

//____________________________________________________________________________
// appendSegmentMatches

template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TSegmentMatches, typename TScores> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TSegmentMatches& matches, TScores& scores, LcsLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(209)
template <typename TString, typename TSpec, typename TSegmentMatches, typename TScores, typename TAlphabet, typename TSize> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, TSegmentMatches& matches, TScores& scores, TSize ktup, TAlphabet, KmerLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(258)
template <typename TString, typename TSpec, typename TSegmentMatches, typename TScores, typename TSize> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, TSegmentMatches& matches, TScores& scores, TSize ktup, KmerLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(317)
template <typename TString, typename TSpec, typename TSegmentMatches, typename TScores> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, TSegmentMatches& matches, TScores& scores, KmerLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(330)
template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TScore, typename TSegmentMatches, typename TScores> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TScore const& score_type, TSegmentMatches& matches, TScores& scores, LocalPairwiseLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(346)
template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TScore, typename TSegmentMatches, typename TScoreValues, typename TDistance, typename TAlignConfig> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TScore const& score_type, TSegmentMatches& matches, TScoreValues& scores, TDistance& dist, TAlignConfig const& ac, GlobalPairwiseLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(484)
template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TScore, typename TSegmentMatches, typename TScoreValues, typename TDistance> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TScore const& score_type, TSegmentMatches& matches, TScoreValues& scores, TDistance& dist, GlobalPairwiseLibrary);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(537)

//____________________________________________________________________________
// buildAlignmentGraph

template <typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, FractionalScore);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(98)
template <typename TFragment, typename TSpec1, typename TStringSet, typename TCargo, typename TSpec> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, FrequencyCounting);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(152)
template <typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>&, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, FrequencyCounting);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(174)
template <typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TScore const& scType, ReScore);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(241)

//____________________________________________________________________________
// convertAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TSource, typename TSpec2> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& gAlign, Align<TSource, TSpec2>& align);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(952)
template <typename TSource, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec> inline bool convertAlignment(Align<TSource, TSpec2> const& align, Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(1002)

//____________________________________________________________________________
// evaluateAlignment

template <typename TAlphabet, typename TScore> inline void evaluateAlignment(MsaOptions<TAlphabet, TScore> const& msaOpt);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(86)

//____________________________________________________________________________
// getAlignmentStatistics

template <typename TFragment, typename TSpec1, typename TStringSet, typename TPos, typename TSize1> inline void getAlignmentStatistics(String<TFragment, TSpec1> const& matches, TStringSet& str, TPos const from, TPos const to, TSize1& matchLength, TSize1& overlapLength, TSize1& alignLength);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(144)

//____________________________________________________________________________
// getDistanceMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, LibraryDistance);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(82)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize, typename TAlphabet> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, TAlphabet, KmerDistance);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(144)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, KmerDistance);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(166)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, KmerDistance);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(178)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_distance.h"(213)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TString, typename TSpec, typename THitMatrix, typename TSize, typename TAlphabet> inline void getKmerSimilarityMatrix(StringSet<TString, TSpec> const& strSet, THitMatrix& mat, TSize ktup, TAlphabet);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_kmer.h"(93)

//____________________________________________________________________________
// globalMsaAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet1, typename TNames, typename TAlphabet, typename TScore> inline void globalMsaAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign, TStringSet1& sequenceSet, TNames& sequenceNames, MsaOptions<TAlphabet, TScore> const& msaOpt);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(222)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void globalMsaAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign, TScore const& scoreObject);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(377)
template <typename TSource, typename TSpec, typename TScore> inline void globalMsaAlignment(Align<TSource, TSpec>& align, TScore const& scoreObject);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_msa.h"(397)

//____________________________________________________________________________
// graphBasedTripletLibraryExtension

template <typename TStringSet, typename TCargo, typename TSpec> inline void graphBasedTripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(599)

//____________________________________________________________________________
// heaviestMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TString, typename TOutString> inline TCargo heaviestMatching(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TOutString& align);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(245)

//____________________________________________________________________________
// msaRefinement

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void msaRefinement(Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign, TScore& sc);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(501)

//____________________________________________________________________________
// njTree

template <typename TValue, typename TStringSpec, typename TCargo, typename TSpec> inline void njTree(String<TValue, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(72)

//____________________________________________________________________________
// progressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(136)

//____________________________________________________________________________
// progressiveMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TEdgeMap, typename TOutGraph> inline void progressiveMatching(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TEdgeMap& edgeMap, TOutGraph& gOut, TEdgeMap& edgeMapOut);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_progressive.h"(471)

//____________________________________________________________________________
// read

template <typename TFile, typename TFragment, typename TSpec, typename TScoreValue, typename TSpec2, typename TNames> void read(TFile & file, String<TFragment, TSpec>& matches, String<TScoreValue, TSpec2>& scores, TNames const& names, TCoffeeLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(113)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, TCoffeeLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(235)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, FastaAlign);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(355)
template <typename TFile, typename TFragment, typename TSpec, typename TScoreValue, typename TSpec2, typename TNames> void read(TFile & file, String<TFragment, TSpec>& matches, String<TScoreValue, TSpec2>& scores, TNames const& origNames, FastaAlign);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(459)
template <typename TFile, typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TNames> inline void read(TFile & file, String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, TNames& names, BlastLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(557)
template <typename TFile, typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TNames> inline void read(TFile & file, String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, TStringSet const& strSet, TNames const& names, MummerLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(761)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void read(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, NewickFormat);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(826)

//____________________________________________________________________________
// score

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(242)

//____________________________________________________________________________
// scoreGapExtendHorizontal

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1 pos1, TPos2, TSeq1 const& seq1, TSeq2 const&);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(135)

//____________________________________________________________________________
// scoreGapExtendVertical

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1, TPos2 pos2, TSeq1 const &, TSeq2 const & seq2);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(189)

//____________________________________________________________________________
// scoreGapOpenHorizontal

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1 pos1, TPos2, TSeq1 const & seq1, TSeq2 const &);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(161)

//____________________________________________________________________________
// scoreGapOpenVertical

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1, TPos2 pos2, TSeq1 const &, TSeq2 const & seq2);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_refinement.h"(215)

//____________________________________________________________________________
// selectPairs

template <typename TString, typename TSpec, typename TSize2, typename TSpec2> inline void selectPairs(StringSet<TString, TSpec> const& str, String<TSize2, TSpec2>& pList);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_library.h"(111)

//____________________________________________________________________________
// sumOfPairsScore

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(762)

//____________________________________________________________________________
// sumOfPairsScoreInd

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScoreInd(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(818)

//____________________________________________________________________________
// tripletLibraryExtension

template <typename TStringSet, typename TCargo, typename TSpec> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(307)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TSize> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& guideTree, TSize minMembers);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_base.h"(505)

//____________________________________________________________________________
// upgmaTree

template <typename TStringValue, typename TStringSpec, typename TCargo, typename TSpec, typename TTag> inline void upgmaTree(String<TStringValue, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g, TTag);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(582)
template <typename TValue, typename TSpec1, typename TCargo, typename TSpec2, typename TTag> inline void upgmaTree(Graph<Undirected<TValue, TSpec1> >& pairGraph, Graph<Tree<TCargo, TSpec2> >& g, TTag);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(698)
template <typename TDistance, typename TCargo, typename TSpec> inline void upgmaTree(TDistance& dist, Graph<Tree<TCargo, TSpec> >& g);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(874)

//____________________________________________________________________________
// write

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TCoffeeLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(271)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TEdgeMap> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TEdgeMap& edgeMap, BlastLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(632)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, BlastLib);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(699)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, bool collapseRoot, NewickFormat);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(1016)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, NewickFormat);       	// "seqan-1.3.1/seqan/graph_msa/graph_align_tcoffee_io.h"(1036)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

