#
# This file is GPL.
#

#
# pt
#
EXE_TARGS+=$(PT_EXE)
OBJ_TARGS+=$(PT_OBJS)

INST_TARGS+=install_pt
UNINST_TARGS+=uninstall_pt

PT_EXE:=utils/pt
PT_OBJS:=utils/pt.o

PT_LIBS=$(LIBFLNETLINK_LIB) $(LIBFLUTIL_LIB)

$(PT_EXE): $(PT_OBJS) $(PT_LIBS)
	$(CC) $(LDFLAGS) -o $@ $^ $(PT_LIBS)

install_pt: $(PT_EXE)
	@install --verbose -s -m 755 -o root -g root $(PT_EXE) $(SBINDIR)
	
uninstall_pt:
	@rm -fv $(SBINDIR)/pt

#
# ct
#
EXE_TARGS+=$(CT_EXE)
OBJ_TARGS+=$(CT_OBJS)

INST_TARGS+=install_ct
UNINST_TARGS+=uninstall_ct

CT_EXE:=utils/ct
CT_OBJS:=utils/ct.o

CT_LIBS=$(LIBFLNETLINK_LIB) $(LIBFLUTIL_LIB)

$(CT_EXE): $(CT_OBJS) $(CT_LIBS)
	$(CC) $(LDFLAGS) -o $@ $^ $(CT_LIBS)

install_ct: $(CT_EXE)
	@install --verbose -s -m 755 -o root -g root $(CT_EXE) $(SBINDIR)
	
uninstall_ct:
	@rm -fv $(SBINDIR)/ct

#
# qt
#
EXE_TARGS+=$(QT_EXE)
OBJ_TARGS+=$(QT_OBJS)

INST_TARGS+=install_qt
UNINST_TARGS+=uninstall_qt

QT_EXE:=utils/qt
QT_OBJS:=utils/qt.o

QT_LIBS=$(LIBFLNETLINK_LIB) $(LIBFLUTIL_LIB)

$(QT_EXE): $(QT_OBJS) $(QT_LIBS)
	$(CC) $(LDFLAGS) -o $@ $^ $(QT_LIBS)

install_qt: $(QT_EXE)
	@install --verbose -s -m 755 -o root -g root $(QT_EXE) $(SBINDIR)
	
uninstall_qt:
	@rm -fv $(SBINDIR)/qt


#
# flmon
#
EXE_TARGS+=$(FLMON_EXE)
OBJ_TARGS+=$(FLMON_OBJS)

INST_TARGS+=install_flmon
UNINST_TARGS+=uninstall_flmon

FLMON_EXE:=utils/flmon
FLMON_OBJS:=utils/flmon.o

FLMON_LIBS=$(LIBFLNETLINK_LIB) $(LIBFLUTIL_LIB)

$(FLMON_EXE): $(FLMON_OBJS) $(FLMON_LIBS)
	$(CC) $(LDFLAGS) -o $@ $^ $(FLMON_LIBS)

install_flmon: $(FLMON_EXE)
	@install --verbose -s -m 755 -o root -g root $(FLMON_EXE) $(BINDIR)
	
uninstall_flmon:
	@rm -fv $(BINDIR)/flmon


#
# uclient is now obsolete, allow it to be uninstalled only
#
UNINST_TARGS+=uninstall_uclient

uninstall_uclient:
	@rm -fv $(BINDIR)/uclient

