#include <proc_secure.h>
#include <stdlib.h>

int main(int argc, char **argv, char **envp)
{
	security_id_t sid;
	int rc;

	if (argc < 3) {
		printf("usage:  %s sid/context pathname arguments...\n",
		       argv[0]);
		exit(1);
	}

	sid = atoi(argv[1]);
	if (!sid) {
		rc = security_context_to_sid(argv[1], strlen(argv[1]) + 1,
					     &sid);
		if (rc) {
			perror(argv[1]);
			exit(1);
		}
	}

	if (execvp_secure(argv[2], sid, &argv[2]) < 0) {
		perror("execvp_secure");
		exit(2);
	}

	exit(0);
}
