/*   ScwView
 *   Copyright 2005  Kalle Vahlman
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __SCW_VIEW_H__
#define __SCW_VIEW_H__

#include <time.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define SCW_TYPE_VIEW            (scw_view_get_type ())
#define SCW_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCW_TYPE_VIEW, ScwView))
#define SCW_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCW_TYPE_VIEW, ScwViewClass))
#define SCW_IS_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCW_TYPE_VIEW))
#define SCW_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCW_TYPE_VIEW))
#define SCW_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), SCW_TYPE_VIEW, ScwViewClass))


typedef struct _ScwView       ScwView;
typedef struct _ScwViewClass  ScwViewClass;

struct _ScwView
{
  GtkWidget parent;

};

struct _ScwViewClass
{
  GtkWidgetClass parent_class;
  
  void    (* activate) (ScwView  *view,
                         gchar    *action_id,
                         gchar    *action_data);

  void    (* context_request) (ScwView  *view,
                               gchar    *action_id,
                               gchar    *action_data,
                               gint     event_x,
                               gint     event_y);

  void    (* buffer_request) (ScwView  *view,
                         GtkTreeModel    *model,
                         gboolean fill_start);

  void    (* set_scroll_adjustments) (ScwView          *view,
                                      GtkAdjustment    *hadjustment,
                                      GtkAdjustment    *vadjustment);
};

#define SCW_TYPE_TIMESTAMP            (scw_timestamp_get_type ())
#define SCW_TYPE_PRESENCE             (scw_presence_get_type ())
#define SCW_TYPE_ROW_COLOR            (scw_row_color_get_type ())
#define SCW_TYPE_INTERACTION          (scw_interaction_get_type ())

GType      scw_view_get_type  (void) G_GNUC_CONST;
GType      scw_timestamp_get_type  (void) G_GNUC_CONST;
GType      scw_presence_get_type  (void) G_GNUC_CONST;
GType      scw_row_color_get_type  (void) G_GNUC_CONST;
GType      scw_interaction_get_type  (void) G_GNUC_CONST;

typedef enum
{
  SCW_INTERACTION_SELECT,
  SCW_INTERACTION_SMART_PAN,
  SCW_INTERACTION_PAN
} ScwInteraction;


/* Public API, documented in the code and a gtk-doc reference */

void scw_view_scroll_to_end (ScwView *view);
void scw_view_scroll_to_row (ScwView *view, const gchar *path);

void scw_view_set_column_foldable (ScwView *view,
                                   gint column,
                                   gboolean foldable);
gboolean scw_view_get_column_foldable (ScwView *view, gint column);

void scw_view_set_column_visible (ScwView *view, gint column, gboolean visible);
gboolean scw_view_get_column_visible (ScwView *view, gint column);

G_END_DECLS

#endif /* __SCW_VIEW_H__ */
