/****************************************************************************
** Form implementation generated from reading ui file 'Bib.ui'
**
** Created: Sun Oct 14 19:47:56 2001
**
****************************************************************************/
#include "scrap.h"
#include "scrap.moc"
#include <qfileinfo.h>
#include <qfile.h>
#include <qurl.h>
#include <qtextstream.h>
#include <qdom.h>
#include <qfiledialog.h>
#include <qpainter.h>
#include <qrect.h>
#include <qimage.h>
#include <qregion.h>
#include <stdlib.h>
#include "missing.h"
#include "query.h"
// #include <iostream.h>
extern QPixmap loadIcon(QString nam);
extern bool loadTextQS(QString nam, QString *Buffer);
extern float QStoFloat(QString in);
extern int QStoInt(QString in);
extern QImage LoadPict(QString fn);
extern QString GetAttr(QDomElement *el, QString at, QString def="0");

/* The Scrapbook View Class
 * inherited from QIconView */
BibView::BibView(QWidget* parent, SCFonts &avail, preV *prefs) : QIconView(parent)
{
	Objekte.clear();
	EFonts = avail;
  Prefs = prefs;
}

BibView::~BibView()
{
}

QDragObject *BibView::dragObject()
{
	QDragObject *dr = new QTextDrag(Objekte[currentItem()->text()].Data, this);
	dr->setPixmap(loadIcon("DragPix.xpm"));
	return dr;
}

void BibView::AddObj(QString name, QString daten, QPixmap Bild)
{
	struct Elem DrElem;
 	DrElem.Data = daten;
 	DrElem.Preview = Bild;
 	Objekte.insert(name, DrElem);
}

void BibView::SaveContents(QString name)
{
	QDomDocument docu("scribus");
	QString st="<SCRIBUSSCRAP></SCRIBUSSCRAP>";
	docu.setContent(st);
	QDomElement ele=docu.documentElement();
	QMap<QString,Elem>::Iterator itf;
	for (itf = Objekte.begin(); itf != Objekte.end(); ++itf)
		{
		QDomElement dc=docu.createElement("OBJEKT");
		dc.setAttribute("NAME",itf.key());
		dc.setAttribute("DATA",itf.data().Data);
		ele.appendChild(dc);
		}
	QFile f(name);
	if(!f.open(IO_WriteOnly))
		return ;
	QTextStream s(&f);
	s<<docu.toCString();
	f.close();
}

void BibView::ReadContents(QString name)
{
	QDomDocument docu("scridoc");
	QFile f(name);
	if(!f.open(IO_ReadOnly))
		return;
	if(!docu.setContent(&f))
		{
		f.close();
		return;
		}
	f.close();
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIBUSSCRAP")
		return;
	clear();
	Objekte.clear();
	QDomNode DOC=elem.firstChild();
	while(!DOC.isNull())
		{
		QDomElement dc=DOC.toElement();
		if (dc.tagName()=="OBJEKT")
			AddObj(GetAttr(&dc, "NAME"), GetAttr(&dc, "DATA"), createPreview(GetAttr(&dc, "DATA")));
		DOC=DOC.nextSibling();
		}
	QMap<QString,Elem>::Iterator itf;
	for (itf = Objekte.begin(); itf != Objekte.end(); ++itf)
		{
    (void) new QIconViewItem(this, itf.key(), itf.data().Preview);
	  }
}

void BibView::RebuildView()
{
	clear();
	QMap<QString,Elem>::Iterator itf;
	for (itf = Objekte.begin(); itf != Objekte.end(); ++itf)
		{
		itf.data().Preview = createPreview(itf.data().Data);
    (void) new QIconViewItem(this, itf.key(), itf.data().Preview);
	  }
}

QPixmap BibView::createPreview(QString data)
{
	struct CLBuf OB;
	struct Pti *hg;
	struct Pti *hl;
  QList<Pti> Ptexti;
	CMYKColor lf = CMYKColor();
	QMap<QString,CMYKColor> Farben;
	QFont fo;
	QMap<QString,QString> DoFonts;
	QMap<QString,QFont> DoFonts2;
	QString tmpf, tmpx, tmp2, tmp3;
	int x, y;
	QPixmap tmp = QPixmap(Prefs->PSize * 3, Prefs->PSize * 3);
	QPainter pm;
	tmp.fill(white);
	pm.begin(&tmp);
	pm.translate(Prefs->PSize,Prefs->PSize);
	pm.setFont(QFont("Helvetica", 8));
	pm.drawText(0, 12, "Preview");
	pm.drawText(0, 20, "not");
	pm.drawText(0, 28, "available");
	QDomDocument docu("scridoc");
	docu.setContent(data);
	QDomElement elem=docu.documentElement();
	if (elem.tagName() != "SCRIBUSELEM")
		{
		QRect pr = QRegion(pm.xForm(QRect(0, 0, Prefs->PSize, Prefs->PSize))).boundingRect();
		QImage tmpi1 = tmp.convertToImage();
		QImage tmpi = tmpi1.copy(pr);
		tmp.convertFromImage(tmpi.smoothScale(Prefs->PSize,Prefs->PSize));
		pm.end();
		return tmp;
		}
	if(QStoInt(elem.attribute("COUNT", "1")) > 1)
		{
		tmp.fill(white);
		pm.drawText(0, 20, "Group");
		QRect pr = QRegion(pm.xForm(QRect(0, 0, Prefs->PSize, Prefs->PSize))).boundingRect();
		QImage tmpi1 = tmp.convertToImage();
		QImage tmpi = tmpi1.copy(pr);
		tmp.convertFromImage(tmpi.smoothScale(Prefs->PSize,Prefs->PSize));
		pm.end();
		return tmp;
		}
	QDomNode DOC=elem.firstChild();
	DoFonts.clear();
	while(!DOC.isNull())
		{
		QDomElement pg=DOC.toElement();
		if(pg.tagName()=="FONT")
			{
			tmpf = GetAttr(&pg, "NAME");
			if (!EFonts.find(tmpf))
				{
				DmF *dia = new DmF(0, tmpf, EFonts);
				dia->exec();
				tmpf = dia->Ersatz;
				delete dia;
				}
			fo = EFonts[tmpf]->Font;
			fo.setPointSize(12);
			DoFonts[GetAttr(&pg, "NAME")] = tmpf;
			DoFonts2[GetAttr(&pg, "NAME")] = fo;
			}
		if(pg.tagName()=="COLOR")
			{
			if (pg.hasAttribute("CMYK"))
				lf.setNamedColor(GetAttr(&pg, "CMYK"));
			else
				lf.fromQColor(QColor(GetAttr(&pg, "RGB")));
		  Farben[GetAttr(&pg, "NAME")] = lf;
			}
		DOC=DOC.nextSibling();
		}
	DOC=elem.firstChild();
	while(!DOC.isNull())
		{
		QDomElement pg=DOC.toElement();
		if(pg.tagName()=="ITEM")
			{
			OB.PType = QStoInt(GetAttr(&pg, "PTYPE"));
			OB.Width = QStoFloat(GetAttr(&pg, "WIDTH"));
			OB.Height = QStoFloat(GetAttr(&pg, "HEIGHT"));
			OB.RadRect = QStoFloat(GetAttr(&pg, "RADRECT","0"));
			OB.Pwidth = QStoInt(GetAttr(&pg, "PWIDTH"));
			OB.Pcolor = GetAttr(&pg, "PCOLOR");
			OB.Pcolor2 = GetAttr(&pg, "PCOLOR2");
			OB.Shade = QStoInt(GetAttr(&pg, "SHADE"));
			OB.Shade2 = QStoInt(GetAttr(&pg, "SHADE2"));
			OB.Rot = QStoFloat(GetAttr(&pg, "ROT"));
			OB.PLineArt = Qt::PenStyle(QStoInt(GetAttr(&pg, "PLINEART")));
			OB.PLineEnd = Qt::PenCapStyle(QStoInt(GetAttr(&pg, "PLINEEND","0")));
			OB.PLineJoin = Qt::PenJoinStyle(QStoInt(GetAttr(&pg, "PLINEJOIN","0")));
			OB.LineSp = QStoFloat(GetAttr(&pg, "LINESP"));
			OB.ExtraV = QStoFloat(GetAttr(&pg, "EXTRAV","0"));
			OB.LocalScX = QStoFloat(GetAttr(&pg, "LOCALSCX"));
			OB.LocalScY = QStoFloat(GetAttr(&pg, "LOCALSCY"));
			OB.LocalX = QStoFloat(GetAttr(&pg, "LOCALX"));
			OB.LocalY = QStoFloat(GetAttr(&pg, "LOCALY"));
			OB.PicArt = QStoInt(GetAttr(&pg, "PICART"));
			OB.flippedH = QStoInt(GetAttr(&pg, "FLIPPEDH"));
			OB.flippedV = QStoInt(GetAttr(&pg, "FLIPPEDV"));
			OB.BBoxX = QStoFloat(GetAttr(&pg, "BBOXX"));
			OB.BBoxH = QStoFloat(GetAttr(&pg, "BBOXH"));
			if (QStoInt(GetAttr(&pg, "TRANSPARENT","0")) == 1)
				OB.Pcolor = "None";
			OB.Extra = QStoFloat(GetAttr(&pg, "EXTRA"));
			OB.Ausrich = QStoInt(GetAttr(&pg, "ALIGN","0"));
			OB.Pfile = GetAttr(&pg, "PFILE");
			OB.IProfile = GetAttr(&pg, "PRFILE","");
			OB.EmProfile = GetAttr(&pg, "EPROF","");
			OB.IRender = QStoInt(GetAttr(&pg, "IRENDER","3"));
			OB.UseEmbedded = QStoInt(GetAttr(&pg, "EMBEDDED","1"));
			OB.Clip.resize(GetAttr(&pg, "NUMCLIP").toUInt());
			tmpx = GetAttr(&pg, "CLIPCOOR");
			QTextStream f(&tmpx, IO_ReadOnly);
			for (uint c=0; c<GetAttr(&pg, "NUMCLIP").toUInt(); c++)
				{
				f >> x;
				f >> y;
				OB.Clip.setPoint(c, x, y);
				}
			tmpx = "";
			QDomNode IT=DOC.firstChild();
			while(!IT.isNull())
				{
				QDomElement it=IT.toElement();
				if (it.tagName()=="ITEXT")
						{
						tmp2 = GetAttr(&it, "CH");
						tmp3 = "\t" + DoFonts[GetAttr(&it, "CFONT")] + "\t";
						tmp3 += GetAttr(&it, "CSIZE") + "\t";
						tmp3 += GetAttr(&it, "CCOLOR") + "\t";
						tmp3 += GetAttr(&it, "CEXTRA") + "\t";
						tmp3 += GetAttr(&it, "CSHADE") + "\t";
						tmp3 += GetAttr(&it, "CSTYLE") + "\t";
						tmp3 += "0\n";
//						tmp3 += it.attribute("CAB","0") + "\n";
						for (uint cxx=0; cxx<tmp2.length(); cxx++)
							{
							tmpx += tmp2.at(cxx)+tmp3;
							}
						}
					else
						{
						tmpx += QString(QChar(QStoInt(GetAttr(&it, "CH")))) + "\t";
						tmpx += DoFonts[GetAttr(&it, "CFONT")] + "\t";
						tmpx += GetAttr(&it, "CSIZE") + "\t";
						tmpx += GetAttr(&it, "CCOLOR") + "\t";
						tmpx += GetAttr(&it, "CEXTRA") + "\t";
						tmpx += GetAttr(&it, "CSHADE") + "\t";
						tmpx += GetAttr(&it, "CSTYLE") + "\t";
						tmpx += "0\n";
//						tmpx += it.attribute("CAB","0") + "\n";
						}
					IT=IT.nextSibling();
				}
			OB.Ptext = tmpx;
			if (OB.Ptext != "")
				{
				QTextStream t(&OB.Ptext, IO_ReadOnly);
				QString cc;
				while (!t.atEnd())
					{
					cc = t.readLine();
					QStringList wt;
					QStringList::Iterator it;
					wt = QStringList::split("\t", cc);
					it = wt.begin();
					hg = new Pti;
					hg->ch = (*it);
					it++;
					hg->cfont = *it;
					it++;
					hg->csize = (*it).toInt();
					it++;
					hg->ccolor = *it;
					it++;
					hg->cextra = (*it).toInt();
					it++;
					hg->cshade = (*it).toInt();
					hg->cselect = false;
					it++;
					if (it == NULL)
						{
						hg->cstyle = 0;
						}
					else
						{
						hg->cstyle = (*it).toInt();
						}
					it++;
					if (it == NULL)
						{
						hg->cab = 0;
						}
					else
						{
						hg->cab = (*it).toInt();
						}
					hg->xp = 0;
					hg->yp = 0;
					Ptexti.append(hg);
					}
				}
			tmpx = GetAttr(&pg, "TEXTCOOR","0 0");
			QTextStream ft(&tmpx, IO_ReadOnly);
			for (uint ct=0; ct<GetAttr(&pg, "NUMTEXT","0").toUInt(); ct++)
				{
				ft >> Ptexti.at(ct)->xp;
				ft >> Ptexti.at(ct)->yp;
				}
			tmpx = "";
			}
		DOC=DOC.nextSibling();
		}
	float pmmax = Prefs->PSize / QMAX(OB.Width, OB.Height);
	int h, s, v, sneu;
	QColor tmpfa;
	QString chx;
	QFont ffo;
	pm.scale(pmmax, pmmax);
	pm.rotate(double(OB.Rot));
	if (OB.flippedH % 2 != 0)
		{
		pm.translate(OB.Width, 0);
		pm.scale(-1, 1);
		}
	if (OB.flippedV % 2 != 0)
		{
		pm.translate(0, OB.Height);
		pm.scale(1, -1);
		}
	if (OB.Pcolor != "None")
		{
		Farben[OB.Pcolor].getRGBColor().rgb(&h, &s, &v);
		if ((h == s) && (s == v))
			{
			Farben[OB.Pcolor].getRGBColor().hsv(&h, &s, &v);
			sneu = 255 - ((255 - v) * OB.Shade / 100);
			tmpfa.setHsv(h, s, sneu);			
			}
		else
			{
			Farben[OB.Pcolor].getRGBColor().hsv(&h, &s, &v);
			sneu = s * OB.Shade / 100;
			tmpfa.setHsv(h, sneu, v);
			}
		pm.setBrush(tmpfa);
		pm.setBackgroundColor(tmpfa);
		}
	else
		pm.setBrush(NoBrush);
	if (OB.Pcolor2 != "None")
		{
		Farben[OB.Pcolor2].getRGBColor().rgb(&h, &s, &v);
		if ((h == s) && (s == v))
			{
			Farben[OB.Pcolor2].getRGBColor().hsv(&h, &s, &v);
			sneu = 255 - ((255 - v) * OB.Shade2 / 100);
			tmpfa.setHsv(h, s, sneu);			
			}
		else
			{
			Farben[OB.Pcolor2].getRGBColor().hsv(&h, &s, &v);
			sneu = s * OB.Shade2 / 100;
			tmpfa.setHsv(h, sneu, v);
			}
		pm.setPen(QPen(tmpfa, int(OB.Pwidth*pmmax), PenStyle(OB.PLineArt), PenCapStyle(OB.PLineEnd), PenJoinStyle(OB.PLineJoin)));
		}
	else
		pm.setPen(NoPen);
	switch (OB.PType)
		{
		case 1:
			tmp.fill(white);
			pm.drawEllipse(0, 0, int(OB.Width), int(OB.Height));
			break;
		case 2:
			tmp.fill(white);
			pm.setClipRegion(QRegion(pm.xForm(OB.Clip)));
			if (OB.Pcolor != "None")
				{
				pm.setPen(NoPen);
				pm.drawPolygon(OB.Clip);
				}
			if (OB.Pfile == "")
				{
				pm.setPen(QPen(black, 1, SolidLine, FlatCap, MiterJoin));
				pm.drawLine(0, 0, OB.Width, OB.Height);
				pm.drawLine(0, OB.Height, OB.Width, 0);
				}
			else
				{
				QFileInfo fi = QFileInfo(OB.Pfile);
				if (!fi.exists())
					{
					pm.setPen(QPen(black, 1, SolidLine, FlatCap, MiterJoin));
					pm.drawLine(0, 0, OB.Width, OB.Height);
					pm.drawLine(0, OB.Height, OB.Width, 0);
					pm.save();
					if (OB.flippedH % 2 != 0)
						{
						pm.translate(OB.Width, 0);
						pm.scale(-1, 1);
						}
					if (OB.flippedV % 2 != 0)
						{
						pm.translate(0, OB.Height);
						pm.scale(1, -1);
						}
					pm.setBackgroundMode(OpaqueMode);
					pm.setFont(QFont("Helvetica", 18));
					int leng = pm.fontMetrics().width(fi.fileName());
					int xp = int(OB.Width / 2 - leng / 2);
					int yp = int(OB.Height / 2 + pm.fontMetrics().height() / 2);
					pm.drawText(xp, yp, fi.fileName());
					pm.restore();
					}
				else
					{
					pm.save();
					pm.scale(OB.LocalScX, OB.LocalScY);
					QString ext = fi.extension(false).lower();
					QImage pixm = LoadPict(OB.Pfile);
					pm.drawImage(OB.LocalX, OB.LocalY, pixm);
					pm.restore();
					}
				}
			break;
		case 3:
			tmp.fill(white);
			if (OB.RadRect != 0)
				{
				QPointArray e1 = QPointArray();
				QPointArray e2 = QPointArray();
				QPointArray e3 = QPointArray();
				QPointArray e4 = QPointArray();
				e1.makeArc(0, 0, int(OB.RadRect), int(OB.RadRect), 1440, 1440);
				e2.makeArc(0, int(OB.Height-OB.RadRect), int(OB.RadRect), int(OB.RadRect), 2880, 1440);
				e3.makeArc(int(OB.Width-OB.RadRect), int(OB.Height-OB.RadRect), int(OB.RadRect), int(OB.RadRect), 4320, 1440);
				e4.makeArc(int(OB.Width-OB.RadRect), 0, int(OB.RadRect), int(OB.RadRect), 0, 1440);
				QPointArray e5 = QPointArray(e1.size()+e2.size()+e3.size()+e4.size());
				for (uint ae = 0; ae < e1.size(); ae++)
					{
					e5.setPoint(ae, e1.point(ae));
					}
				for (uint ae = 0; ae < e2.size(); ae++)
					{
					e5.setPoint(ae+e1.size(), e2.point(ae));
					}
				for (uint ae = 0; ae < e3.size(); ae++)
					{
					e5.setPoint(ae+e1.size()+e2.size(), e3.point(ae));
					}
				for (uint ae = 0; ae < e4.size(); ae++)
					{
					e5.setPoint(ae+e1.size()+e2.size()+e3.size(), e4.point(ae));
					}
				pm.drawPolygon(e5);
				}
			else
				pm.drawRect(0, 0, int(OB.Width), int(OB.Height));
			break;
		case 4:
			if (Ptexti.count() != 0)
				{
				tmp.fill(white);
				pm.setClipRegion(QRegion(pm.xForm(OB.Clip)));
				if (OB.Pcolor != "None")
					{
					pm.setPen(NoPen);
					pm.drawPolygon(OB.Clip);
					}
				for (uint a = 0; a < Ptexti.count(); a++)
					{
					hl = Ptexti.at(a);
					if (hl->ch == QChar(13))
						continue;
					ffo = DoFonts2[hl->cfont];
					if (hl->ccolor != "None")
						{
						Farben[hl->ccolor].getRGBColor().rgb(&h, &s, &v);
						if ((h == s) && (s == v))
							{
							Farben[hl->ccolor].getRGBColor().hsv(&h, &s, &v);
							sneu = 255 - ((255 - v) * hl->cshade / 100);
							tmpfa.setHsv(h, s, sneu);			
							}
						else
							{
							Farben[hl->ccolor].getRGBColor().hsv(&h, &s, &v);
							sneu = s * hl->cshade / 100;
							tmpfa.setHsv(h, sneu, v);
							}
						pm.setPen(tmpfa);
						}
					pm.setFont(ffo);
					chx = hl->ch;
					ffo.setPointSize(hl->csize);
					if (hl->cstyle != 0)
						{
						if (hl->cstyle & 32)
							ffo.setBold(true);
						if (hl->cstyle & 16)
							ffo.setStrikeOut(true);
						if (hl->cstyle & 8)
							ffo.setUnderline(true);
						if (hl->cstyle & 4)
							ffo.setItalic(true);
						if (hl->cstyle & 1)
							ffo.setPointSize(hl->csize * Prefs->DVHochSc / 100);
						if (hl->cstyle & 2)
							ffo.setPointSize(hl->csize * Prefs->DVTiefSc / 100);
						if (hl->cstyle & 64)
							{
							if (chx.upper() != chx)
								ffo.setPointSize(hl->csize * Prefs->DVKapit / 100);
							}
						pm.setFont(ffo);
						}
					else
						{
						ffo.setPointSize(hl->csize);
						pm.setFont(ffo);
						}
					pm.drawText(qRound(hl->xp), qRound(hl->yp), hl->ch);
					}
				}
			break;
		case 5:
			tmp.fill(white);
			pm.drawLine(0, 0, int(OB.Width), int(OB.Height));
			break;
		}
	QRect pr = pm.xForm(QRect(0, 0, OB.Width, OB.Height));
	QImage tmpi1 = tmp.convertToImage();
	QImage tmpi = tmpi1.copy(pr);
	pm.end();
	if (pr.width() >= pr.height())
		{
		float xfa = Prefs->PSize / float(pr.width());
		tmpi1 = tmpi.smoothScale(Prefs->PSize,pr.height()*xfa);
		}
	else
		{
		float xfa = Prefs->PSize / float(pr.height());
		tmpi1 = tmpi.smoothScale(pr.width()*xfa,Prefs->PSize);
		}
	tmp = QPixmap(Prefs->PSize, Prefs->PSize);
	tmp.fill(white);
	pm.begin(&tmp);
	pm.drawImage(((Prefs->PSize-tmpi1.width()) / 2),((Prefs->PSize-tmpi1.height()) / 2), tmpi1);
	pm.end();
	return tmp;
}

/* This is the main Dialog-Class for the Scrapbook */
Biblio::Biblio( QWidget* parent, SCFonts &avail, preV *prefs)
    : QDialog( parent, "Sclib", false, WStyle_Customize | WStyle_DialogBorder )
{
    resize( 230, 190 );
    setCaption( tr( "Scrapbook" ) );
  	setIcon(loadIcon("AppIcon.xpm"));
  	ScFilename = "";
  	Prefs = prefs; 	
    BiblioLayout = new QVBoxLayout( this );
    BiblioLayout->setSpacing( 0 );
    BiblioLayout->setMargin( 0 );
  	fmenu = new QPopupMenu();
  	fmenu->insertItem(loadIcon("DateiNeu16.png"), tr("New"), this, SLOT(NewLib()), CTRL+Key_N);
  	fSave = fmenu->insertItem(loadIcon("DateiSave16.png"), tr("Save"), this, SLOT(Save()), CTRL+Key_S);
  	fmenu->insertItem(tr("Save as..."), this, SLOT(SaveAs()));
  	fmenu->insertItem(loadIcon("DateiOpen16.png"), tr("Load..."), this, SLOT(Load()), CTRL+Key_O);
  	fmenu->insertItem(loadIcon("DateiClos16.png"), tr("Close"), this, SLOT(CloseWin()));
  	vmenu = new QPopupMenu();
    vS = vmenu->insertItem( tr( "Small" ) );
    vM = vmenu->insertItem( tr( "Medium" ) );
    vB = vmenu->insertItem( tr( "Big" ) );
    switch (prefs->PSize)
    	{
    	case 40:
    		vmenu->setItemChecked(vS, true);
    		break;
    	case 60:
    		vmenu->setItemChecked(vM, true);
    		break;
    	case 80:
    		vmenu->setItemChecked(vB, true);
    		break;
    	}
  	menuBar = new QMenuBar(this);
		menuBar->insertItem(tr("File"), fmenu);
		menuBar->insertItem(tr("Preview"), vmenu);
    BiblioLayout->setMenuBar( menuBar );

    Frame3 = new QFrame( this, "Frame3" );
    Frame3->setFrameShape( QFrame::Box );
    Frame3->setFrameShadow( QFrame::Sunken );
    Frame3Layout = new QVBoxLayout( Frame3 );
    Frame3Layout->setSpacing( 6 );
    Frame3Layout->setMargin( 11 );

    BibWin = new BibView(Frame3, avail, prefs);
    BibWin->setAutoArrange(true);
    BibWin->setSorting(true);
    Frame3Layout->addWidget( BibWin );
    BiblioLayout->addWidget( Frame3 );
    connect(BibWin, SIGNAL(dropped(QDropEvent *, const QValueList<QIconDragItem> &)),
						this, SLOT(DropOn(QDropEvent *)));
		connect(BibWin, SIGNAL(rightButtonClicked(QIconViewItem*, const QPoint &)),
						this, SLOT(HandleMouse(QIconViewItem*)));
	  connect(vmenu, SIGNAL(activated(int)), this, SLOT(SetPreview(int)));
}

Biblio::~Biblio()
{
}

void Biblio::closeEvent(QCloseEvent *ce)
{
	emit Schliessen();
	ce->accept();
}

void Biblio::CloseWin()
{
	emit Schliessen();
}

void Biblio::Save()
{
	if ((!ScFilename.isEmpty()) && (BibWin->Objekte.count() != 0))
		BibWin->SaveContents(ScFilename);
}

void Biblio::SaveAs()
{
  QString fn = QFileDialog::getSaveFileName(0, tr("Scrapbooks (*.scs);; All Files (*)"), this);
  if (!fn.isEmpty())
  	{
  	BibWin->SaveContents(fn);
  	ScFilename = fn;
  	setCaption(fn);
  	fmenu->setItemEnabled(fSave, 1);
  	}
}

void Biblio::Load()
{
	QString fileName = QFileDialog::getOpenFileName(0,tr("Scrapbooks (*.scs);; All Files (*)"),this);
	if (!fileName.isEmpty())
		{
		BibWin->ReadContents(fileName);
		ScFilename = fileName;
		setCaption(fileName);
		}
}

void Biblio::SetPreview(int id)
{
	int a = vmenu->indexOf(id);
	switch (a)
		{
		case 0:
			Prefs->PSize = 40;
			break;
		case 1:
			Prefs->PSize = 60;
			break;
		case 2:
			Prefs->PSize = 80;
			break;
		}
	AdjustMenu();
	BibWin->RebuildView();
}

void Biblio::AdjustMenu()
{
	vmenu->setItemChecked(vS, false);
	vmenu->setItemChecked(vM, false);
	vmenu->setItemChecked(vB, false);
  switch (Prefs->PSize)
  	{
   	case 40:
   		vmenu->setItemChecked(vS, true);
   		break;
   	case 60:
   		vmenu->setItemChecked(vM, true);
   		break;
   	case 80:
   		vmenu->setItemChecked(vB, true);
   		break;
   	}
}

void Biblio::HandleMouse(QIconViewItem *ite)
{
	int mret, del;
	if (ite != 0)
		{
		QPopupMenu *pmenu = new QPopupMenu();
		qApp->setOverrideCursor(QCursor(ArrowCursor), true);
		del = pmenu->insertItem(tr("Delete"));
		mret = pmenu->exec(QCursor::pos());
		if (mret == del)
				DeleteObj(ite->text(), ite);
		delete pmenu;		
		}
}

void Biblio::NewLib()
{
	BibWin->Objekte.clear();
	BibWin->clear();
	ScFilename = "";
  setCaption(tr("Scrapbook"));
  fmenu->setItemEnabled(fSave, 0);
}

void Biblio::DeleteObj(QString name, QIconViewItem *ite)
{
	BibWin->Objekte.remove(name);
	delete ite;
	BibWin->arrangeItemsInGrid(true);
}

void Biblio::DropOn(QDropEvent *e)
{
	QString text, tmp, nam;
	bool img;
	tmp = "";
	if (QTextDrag::decode(e, text))
		{
		QUrl ur(text);
		QFileInfo fi = QFileInfo(ur.path());
		QString ext = fi.extension(false).lower();
		img = ((ext=="eps")||(ext=="ps")||(ext=="png")||(ext=="gif")||(ext=="jpg")||(ext=="xpm"));
		if ((fi.exists()) && (!img))
			{
			if (loadTextQS(ur.path(), &text))
				{
				if (text.startsWith("<SCRIBUSELEM>"))
					{
					tmp = text;
    			}
    		}	
			}
		else
			{
			if (text.startsWith("<SCRIBUSELEM>"))
				{
				tmp = text;
    		}
    	}
    nam = tr("Object") + tmp.setNum(BibWin->Objekte.count());
    Query *dia = new Query(this, "tt", 1, 0, "Name:", "New Entry");
    dia->Answer->setText(nam);
    dia->Answer->selectAll();
    if (dia->exec())
    	{
    	nam = dia->Answer->text();
    	while (BibWin->Objekte.contains(nam))
    		{
    		if (!dia->exec())
    			{
    			delete dia;
    			return;
    			}
    		nam = dia->Answer->text();
    		}
    	}
    else
    	{
    	delete dia;
    	return;
    	}
    delete dia;
		QPixmap pm = BibWin->createPreview(text);
    BibWin->AddObj(nam, text, pm);
    (void) new QIconViewItem(BibWin, nam, pm);
		}
}

