#ifndef PICSTATUS_H
#define PICSTATUS_H

#include <qvariant.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qheader.h>
#include <qlist.h>
#include <qvaluelist.h>
#include "scribusdoc.h"
#include "scribusview.h"

class PicStatus : public QDialog
{ 
    Q_OBJECT

public:
    PicStatus(QWidget* parent, ScribusDoc *docu, ScribusView *viewi);
    ~PicStatus();

    QTable* PicTable;
    QHeader *Header;
    QPushButton* CancelB;
    QPushButton* OkB;
    ScribusDoc *doc;
    ScribusView *view;
    int Zeilen;
    QList<QCheckBox> FlagsPic;
    QValueList<uint> ItemNrs;

private slots:
    void GotoPic();
    void SearchPic();
    void PrintPic();

protected:
    QVBoxLayout* PicStatusLayout;
    QHBoxLayout* Layout2;

signals:
		void GotoSeite(int);
};

#endif // PICSTATUS_H
