;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeman/man.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:03:53 2001                          */
;*    Last change :  Wed Jan  9 16:05:00 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The translator scribe->man                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeman_man
   
   (library scribeapi)

   (export  (generic man ::obj)))

   
;*---------------------------------------------------------------------*/
;*    title-number ::%block ...                                        */
;*---------------------------------------------------------------------*/
(define-generic (title-number obj::%container)
   "")

;*---------------------------------------------------------------------*/
;*    title-number ::%chapter ...                                      */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%chapter)
   (with-access::%chapter obj (number)
      (if (not number)
	  ""
	  (->string (*scribe-chapter-numbering* number)))))

;*---------------------------------------------------------------------*/
;*    do-number ...                                                    */
;*---------------------------------------------------------------------*/
(define (do-number sup cur)
   (if (and (string? sup) (not (=fx (string-length sup) 0)))
       (string-append sup "." cur)
       cur))

;*---------------------------------------------------------------------*/
;*    title-number ::%section ...                                      */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%section)
   (with-access::%section obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-section-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-section-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    title-number ::%subsection ...                                   */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%subsection)
   (with-access::%subsection obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-subsection-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-subsection-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    title-number ::%subsubsection ...                                */
;*---------------------------------------------------------------------*/
(define-method (title-number obj::%subsubsection)
   (with-access::%subsubsection obj (number parent)
      (cond
	 ((not (number? number))
	  "")
	 ((not parent)
	  (->string (*scribe-subsubsection-numbering* number)))
	 (else
	  (do-number (title-number parent)
		     (->string (*scribe-subsubsection-numbering* number)))))))

;*---------------------------------------------------------------------*/
;*    string-replace ...                                               */
;*---------------------------------------------------------------------*/
(define (string-replace str1 c1 c2)
   (let* ((len (string-length str1))
	  (str2 (make-string len)))
      (let loop ((r 0))
	 (if (=fx r len)
	     str2
	     (let ((c (string-ref str1 r)))
		(if (char=? c c1)
		    (string-set! str2 r c2)
		    (string-set! str2 r c))
		(loop (+fx r 1)))))))

;*---------------------------------------------------------------------*/
;*    man-string ...                                                   */
;*---------------------------------------------------------------------*/
(define (man-string str)
   (define (inner str)
      (let ((len (string-length str)))
	 (let loop ((r 0)
		    (nlen len))
	    (if (=fx r len)
		(if (=fx nlen len)
		    str
		    (let ((res (make-string nlen)))
		       (let loop ((r 0)
				  (w 0))
			  (if (=fx w nlen)
			      res
			      (let ((c (string-ref str r)))
				 (case c
				    ((#\-)
				     (string-set! res w #\\)
				     (string-set! res (+fx 1 w) c)
				     (loop (+fx r 1) (+fx w 2)))
				    (else
				     (string-set! res w c)
				     (loop (+fx r 1) (+fx w 1)))))))))
		(case (string-ref str r)
		   ((#\-)
		    (loop (+fx r 1) (+fx nlen 1)))
		   (else
		    (loop (+fx r 1) nlen)))))))
   (if (pair? str)
       (apply string-append
	      (map (lambda (x)
		      (if (string? x)
			  (inner x)
			  (with-output-to-string (lambda () (man x)))))
		   str))
       (inner str)))

;*---------------------------------------------------------------------*/
;*    man ::obj ...                                                    */
;*---------------------------------------------------------------------*/
(define-generic (man obj::obj)
   (cond
      ((procedure? obj)
       (man (obj)))
      ((string? obj)
       (display obj))
      ((number? obj)
       (display (number->string obj)))
      ((char? obj)
       (display obj))
      ((eq? obj #unspecified)
       obj)
      ((list? obj)
       (for-each man obj))
      ((or (symbol? obj) (boolean? obj))
       "")
      (else
       (with-access::%node obj (loc)
	  (error/location "man"
			  "Can't find method for node"
			  (find-runtime-type obj)
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    man ::%document ...                                              */
;*---------------------------------------------------------------------*/
(define-method (man obj::%document)
   (with-document
    obj
    (lambda ()
       (with-access::%document obj (title authors body footnotes)
	  (scribe-document->man title authors body)
	  (if (pair? footnotes)
	      (begin
		 (newline)
		 (newline)
		 (print "-------------")
		 (print ".Sp\n.nf\n.ta \w'100 'u")
		 (for-each (lambda (fn)
			      (with-access::%footnote fn (number note id)
				 (display"\\& ")
				 (display (string-append
					   "*"
					   (number->string number)
					   ": "))
				 (man note)
				 (newline)))
			   footnotes)
		 (print ".Sp\n.fi")))))))

;*---------------------------------------------------------------------*/
;*     scribe-document->man ...                                        */
;*---------------------------------------------------------------------*/
(define (scribe-document->man title authors body)
   (define (man-header)
      (print ".if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
'\\\"	# Start an argument description
.de AP
.ie !\"\\\\$4\"\" .TP \\\\$4
.el \\{\\
.   ie !\"\\\\$2\"\" .TP \\\\n()Cu
.   el          .TP 15
.\\}
.ta \\\\n()Au \\\\n()Bu
.ie !\"\\\\$3\"\" \\{\\
\\&\\\\$1	\\\\fI\\\\$2\\\\fP	(\\\\$3)
.\\\".b
.\\}
.el \\{\\
.br
.ie !\"\\\\$2\"\" \\{\\
\\&\\\\$1	\\\\fI\\\\$2\\\\fP
.\\}
.el \\{\\
\\&\\\\fI\\\\$1\\\\fP
.\\}
.\\}
..
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \\l'\\\\n(.lu\\(ul'
.if n .fi
..
'\\\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \\l'\\\\n(^lu\\(ul'
.el \\{\\
.\\\"	Draw four-sided box normally, but don't draw top of
.\\\"	box if the box started on an earlier page.
.ie !\\\\n(^b-1 \\{\\
\\h'-1.5n'\\L'|\\\\n(^yu-1v'\\l'\\\\n(^lu+3n\\(ul'\\L'\\\\n(^tu+1v-\\\\n(^yu'\\l'|0u-1.5n\\(ul'
.\\}
.el \\}\\
\\h'-1.5n'\\L'|\\\\n(^yu-1v'\\h'\\\\n(^lu+3n'\\L'\\\\n(^tu+1v-\\\\n(^yu'\\l'|0u-1.5n\\(ul'
.\\}
.\\}
.fi
.br
.nr ^b 0
..
'\\\"	# VS - start vertical sidebar
'\\\"	# ^Y = starting y location
'\\\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.."))
   ;; compute the first word of a title
   (define (first-word title)
      (let ((len (string-length title)))
	 (let loop ((i 0))
	    (cond
	       ((=fx i len)
		title)
	       ((memq (string-ref title i) '(#\space #\Newline #\Tab))
		(substring title 0 i))
	       (else
		(loop (+fx i 1)))))))
   ;; display the title and the authors
   (define (man-title title authors)
      (let ((stitle (man-string title)))
	 (print ".TH " (first-word stitle) " 1")
	 (print ".SH NAME")
	 (print stitle)))
   ;; display the footer
   (define (man-footer)
      (if *scribe-footer* (man *scribe-footer*)))
   ;; the very header
   (man-header)
   ;; the title
   (man-title title authors)
   ;; the body
   (man body)
   ;; the footer of the document
   (man-footer)
   ;; the authors
   (newline)
   (print ".SH AUTHOR")
   (for-each (lambda (a) (man a) (newline)) authors)
   ;; we are done
   (newline)
   (newline))

;*---------------------------------------------------------------------*/
;*    man ::%author ...                                                */
;*---------------------------------------------------------------------*/
(define-method (man obj::%author)
   (with-access::%author obj (name affiliation email url address)
      (man name)
      (if (or email url) (display ", "))
      (if email (print email (if url ", " "")))
      (if url (print url))
      (newline)))
   
;*---------------------------------------------------------------------*/
;*    man ::%toc ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (man obj::%toc)
   (with-access::%toc obj (chapter section)
      ;; display the toc for a subsectino
      (define (subsection-toc s margin)
	 (if margin
	     (begin
		(print ".RS " margin)
		(print ".TP")
		(display (make-string margin #\space))
		(man-subsection-ref s)
		(newline)
		(print ".RS " margin))
	     (begin
		(print ".TP")
		(man-subsection-ref s)
		(newline))))
      ;; display the toc for a section
      (define (section-toc s margin subsection)
	 (with-access::%section s (toc number title children)
	    (if (and toc
		     (or (eq? section #t)
			 (and (pair? section) (member title section))))
		(begin
		   (display "\\& ")
		   (if margin (display (make-string margin #\space)))
		   (man-section-ref s)
		   (newline)))
	    (if subsection
		(for-each (lambda (x)
			     (if (%subsection? x)
				 (subsection-toc x (+ margin 4))))
			  (section-subsections s)))))
      ;; display the toc for a chapter
      (define (chapter-toc c)
	 (with-access::%chapter c (toc number subtitle)
	    (if (and toc
		     (or (eq? chapter #t)
			 (and (pair? chapter) (member subtitle chapter))))
		(begin
		   (man-chapter-ref c)
		   (newline)))
	    (for-each (lambda (x)
			 (section-toc x 4 #f))
		      (chapter-sections c))))
      (define (partial-toc)
	 (let ((sections (if (current-chapter)
			     (chapter-sections (current-chapter))
			     (document-sections (current-document)))))
	    (for-each (lambda (x) (section-toc x 0 #t)) sections)))
      (define (full-toc)
	 ;; the top-level sections
	 (for-each (lambda (x)
		      (section-toc x 0 #f))
		   (document-sections (current-document)))
	 ;; the chapters
	 (for-each chapter-toc (document-chapters (current-document))))
      ;; begin the toc
      (print ".Sp\n.nf\n.ta \w'100 'u")
      (if (eq? chapter #t)
	  (full-toc)
	  (partial-toc))
      (print ".Sp\n.fi")))

;*---------------------------------------------------------------------*/
;*    man ::%text ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%text)
   (man (%text-body obj)))

;*---------------------------------------------------------------------*/
;*    man ::%linebreak ...                                             */
;*---------------------------------------------------------------------*/
(define-method (man obj::%linebreak)
   (let loop ((num (%linebreak-repetition obj)))
      (newline)
      (if (>fx num 1)
	  (begin
	     (newline)
	     (loop (-fx num 1))))))

;*---------------------------------------------------------------------*/
;*    man ::%center ...                                                */
;*---------------------------------------------------------------------*/
(define-method (man obj::%center)
   (man (%center-body obj)))

;*---------------------------------------------------------------------*/
;*    man ::%flush ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (man obj::%flush)
   (with-access::%flush obj (side)
      (man (%flush-body obj))))

;*---------------------------------------------------------------------*/
;*    man ::%atom ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%atom)
   (print (%atom-value obj)))

;*---------------------------------------------------------------------*/
;*    man ::%bold ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%bold)
   (display "\\fB")
   (man (%bold-body obj))
   (display "\\fR"))

;*---------------------------------------------------------------------*/
;*    man ::%emph ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%emph)
   (display "\\fI")
   (man (%emph-body obj))
   (display "\\fR"))

;*---------------------------------------------------------------------*/
;*    man ::%underline ...                                             */
;*---------------------------------------------------------------------*/
(define-method (man obj::%underline)
   (display "\\fI")
   (man (%underline-body obj))
   (display "\\fR"))

;*---------------------------------------------------------------------*/
;*    man ::%kbd ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (man obj::%kbd)
   (man (%kbd-body obj)))

;*---------------------------------------------------------------------*/
;*    man ::%it ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (man obj::%it)
   (display "\\fI")
   (man (%it-body obj))
   (display "\\fR"))

;*---------------------------------------------------------------------*/
;*    man ::%pre ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (man obj::%pre)
   (newline)
   (print ".Sp\n.nf")
   (man (%pre-body obj))
   (newline)
   (print ".Sp\n.fi"))

;*---------------------------------------------------------------------*/
;*    man ::%tt ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (man obj::%tt)
   (with-access::%tt obj (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%code ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%code)
   (with-access::%code obj (body)
      (display "`")
      (man body)
      (display "'")))

;*---------------------------------------------------------------------*/
;*    man ::%samp ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%samp)
   (with-access::%samp obj (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%var ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (man obj::%var)
   (with-access::%var obj (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%sc ...                                                    */
;*---------------------------------------------------------------------*/
(define-method (man obj::%sc)
   (with-access::%sc obj (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%sup ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (man obj::%sup)
   (with-access::%sup obj (body)
      (display "^")
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%sub ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (man obj::%sub)
   (with-access::%sub obj (body)
      (display "_")
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%color ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (man obj::%color)
   (with-access::%color obj (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%frame ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (man obj::%frame)
   (with-access::%frame obj (body margin)
      (newline)
      (print ".BS")
      (man body)
      (print ".BE")))

;*---------------------------------------------------------------------*/
;*    mark ...                                                         */
;*---------------------------------------------------------------------*/
(define-method (man obj::%mark)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    man ::%reference ...                                             */
;*---------------------------------------------------------------------*/
(define-method (man obj::%reference)
   (with-access::%reference obj (body anchor)
      (multiple-value-bind (file mark)
	 (find-reference obj (current-document))
	 (if (not mark)
	     (begin
		(warning "ref" "Can't find reference -- " anchor)
		(display "reference:???"))
	     (begin
		(man body))))))

;*---------------------------------------------------------------------*/
;*    man ::%url-ref ...                                               */
;*---------------------------------------------------------------------*/
(define-method (man obj::%url-ref)
   (with-access::%url-ref obj (url anchor body)
      (man body)
      (display " (\\fB")
      (man url)
      (if anchor
	  (begin
	     (display "#")
	     (man anchor)))
      (display "\\fR)")))
   
;*---------------------------------------------------------------------*/
;*    man ::%chapter-ref ...                                           */
;*---------------------------------------------------------------------*/
(define-method (man obj::%chapter-ref)
   (multiple-value-bind (_ chapter)
      (find-reference obj (current-document))
      (if (not chapter)
	  (with-access::%chapter-ref obj (anchor)
	     (warning "ref" "Can't find chapter -- " anchor)
	     (display "chapter:???"))
	  (man-chapter-ref chapter))))

;*---------------------------------------------------------------------*/
;*    man-chapter-ref ...                                              */
;*---------------------------------------------------------------------*/
(define (man-chapter-ref obj::%chapter)
   (display (make-chapter-title obj #f)))

;*---------------------------------------------------------------------*/
;*    man ::%section-ref ...                                           */
;*---------------------------------------------------------------------*/
(define-method (man obj::%section-ref)
   (multiple-value-bind (_ section)
      (find-reference obj (current-document))
      (if (not (%section? section))
	  (with-access::%section-ref obj (anchor)
	     (warning "ref" "Can't find section -- " anchor)
	     (display "section:???"))
	  (man-section-ref section))))

;*---------------------------------------------------------------------*/
;*    man-section-ref ...                                              */
;*---------------------------------------------------------------------*/
(define (man-section-ref obj::%section)
   (display (make-section-title obj)))
   
;*---------------------------------------------------------------------*/
;*    man ::%subsection-ref ...                                        */
;*---------------------------------------------------------------------*/
(define-method (man obj::%subsection-ref)
   (multiple-value-bind (_ subsection)
      (find-reference obj (current-document))
      (if (not (%subsection? subsection))
	  (with-access::%subsection-ref obj (anchor)
	     (warning "ref" "Can't find subsection -- " anchor)
	     (display "subsection:???"))
	  (man-subsection-ref subsection))))

;*---------------------------------------------------------------------*/
;*    man-subsection-ref ...                                           */
;*---------------------------------------------------------------------*/
(define (man-subsection-ref obj::%subsection)
   (display (make-subsection-title obj)))
   
;*---------------------------------------------------------------------*/
;*    man ::%subsubsection-ref ...                                     */
;*---------------------------------------------------------------------*/
(define-method (man obj::%subsubsection-ref)
   (multiple-value-bind (_ subsubsection)
      (find-reference obj (current-document))
      (if (not (%subsubsection? subsubsection))
	  (with-access::%subsubsection-ref obj (anchor)
	     (warning "ref" "Can't find subsubsection -- " anchor)
	     (display "subsubsection:???"))
	  (man-subsubsection-ref subsubsection))))

;*---------------------------------------------------------------------*/
;*    man-subsubsection-ref ...                                        */
;*---------------------------------------------------------------------*/
(define (man-subsubsection-ref obj::%subsubsection)
   (with-access::%subsubsection obj (title)
      (display title)))

;*---------------------------------------------------------------------*/
;*    man ::%biblio-ref ...                                            */
;*---------------------------------------------------------------------*/
(define-method (man obj::%biblio-ref)
   (error "man" "biblio-ref" "not implemented"))

;*---------------------------------------------------------------------*/
;*    mailto ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (man obj::%mailto)
   (with-access::%mailto obj (email body)
      (if (pair? body)
	  (man body)
	  (display email))))

;*---------------------------------------------------------------------*/
;*    man ::%item ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%item)
   (with-access::%item obj (value body)
      (if (not (null? value))
	  (begin
	     (man value)
	     (display ": ")))
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%itemize ...                                               */
;*---------------------------------------------------------------------*/
(define-method (man obj::%itemize)
   (with-access::%itemize obj (items)
      (for-each (lambda (item)
		   (print ".RS 2")
		   (print ".IP \\(bu 2")
		   (man item)
		   (newline)
		   (print ".RE"))
		items)))
      
;*---------------------------------------------------------------------*/
;*    man ::%enumerate ...                                             */
;*---------------------------------------------------------------------*/
(define-method (man obj::%enumerate)
   (with-access::%enumerate obj (items)
      (let loop ((num 1)
		 (items items))
	 (if (pair? items)
	     (let ((item (car items)))
		(print ".RS 2")
		(print ".TP")
		(print (integer->string num))
		(man item)
		(newline)
		(print ".RE")
		(loop (+fx num 1) (cdr items)))))))
      
;*---------------------------------------------------------------------*/
;*    man ::%description ...                                           */
;*---------------------------------------------------------------------*/
(define-method (man obj::%description)
   (with-access::%description obj (items)
      (for-each (lambda (item)
		   (print ".RS 3")
		   (print ".TP")
		   (display "\\&")
		   (with-access::%item item (body value)
		      (for-each (lambda (v)
				   (man v)
				   (display " "))
				(if (pair? value) value (list value)))
		      (newline)
		      (man body)
		      (newline)
		      (print ".RE")))
		items)))
      
;*---------------------------------------------------------------------*/
;*    make-section-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-section-title obj)
   (with-access::%section obj (title number)
      (if (not number)
	  title
	  (string-append (title-number obj) " -- "
			 (if (string? title)
			     title
			     (with-output-to-string 
				(lambda () (man title))))))))

;*---------------------------------------------------------------------*/
;*    man ::%section ...                                               */
;*---------------------------------------------------------------------*/
(define-method (man obj::%section)
   (with-access::%section obj (body title)
      (newline)
      (print ".SH " (make-section-title obj))
      (newline)
      (man body)))

;*---------------------------------------------------------------------*/
;*    make-subsection-title ...                                        */
;*---------------------------------------------------------------------*/
(define (make-subsection-title obj)
   (with-access::%subsection obj (title number)
      (if (not number)
	  title
	  (string-append (title-number obj) " -- "
			 (if (string? title)
			     title
			     (with-output-to-string 
				(lambda () (man title))))))))

;*---------------------------------------------------------------------*/
;*    man ::%subsection ...                                            */
;*---------------------------------------------------------------------*/
(define-method (man obj::%subsection)
   (with-access::%subsection obj (body title)
      (print ".SS " (make-subsection-title obj))
      (man body)))

;*---------------------------------------------------------------------*/
;*    make-subsubsection-title ...                                     */
;*---------------------------------------------------------------------*/
(define (make-subsubsection-title obj)
   (with-access::%subsubsection obj (title number)
      (if (not number)
	  title
	  (string-append (title-number obj) " -- " title))))

;*---------------------------------------------------------------------*/
;*    man ::%subsubsection ...                                         */
;*---------------------------------------------------------------------*/
(define-method (man obj::%subsubsection)
   (with-access::%subsubsection obj (body title)
      (print ".SH " (make-subsubsection-title obj))
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%paragraph ...                                             */
;*---------------------------------------------------------------------*/
(define-method (man obj::%paragraph)
   (with-access::%paragraph obj (body)
      (newline)
      (print ".P")
      (man body)))

;*---------------------------------------------------------------------*/
;*    make-chapter-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-chapter-title obj full)
   (with-access::%chapter obj (title subtitle number parent)
      (let* ((doc parent)
	     (title (cond
		       (title
			title)
		       ((and full
			     (%document? doc)
			     (or (string? (%document-title doc))
				 (and (pair? (%document-title doc))
				      (string? (car (%document-title doc))))))
			(string-append (if (string? (%document-title doc))
					   (%document-title doc)
					   (car (%document-title doc)))
				       " -- "
				       subtitle))
		       (else
			subtitle))))
	 (if (not number)
	     title
	     (string-append (title-number obj) " -- "
			    (if (string? title)
				title
				(with-output-to-string 
				   (lambda () (man title)))))))))

;*---------------------------------------------------------------------*/
;*    man ::%chapter ...                                               */
;*---------------------------------------------------------------------*/
(define-method (man obj::%chapter)
   (with-access::%chapter obj (body file title subtitle)
      (newline)
      (print ".SH " (make-chapter-title obj #t))
      (newline)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%hrule ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (man obj::%hrule)
   (print ".BS"))

;*---------------------------------------------------------------------*/
;*    man ::%font ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%font)
   (with-access::%font obj (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%image ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (man obj::%image)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    man ::%table ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (man obj::%table)
   (print ".Sp\n.nf")
   (print ".ta T 8c")
   (with-access::%table obj (rows)
      (for-each (lambda (r)
		   (with-access::%table-row r (cells)
		      (display "\\& ")
		      (for-each (lambda (c)
				   (man c)
				   (display #\tab))
				cells)
		      (newline)))
		rows))
   (print ".Sp\n.fi"))

;*---------------------------------------------------------------------*/
;*    man ::%table-header ...                                          */
;*---------------------------------------------------------------------*/
(define-method (man c::%table-header)
   (with-access::%table-header c (body)
      (display "\\fB")
      (man body)
      (display "\\fR")))

;*---------------------------------------------------------------------*/
;*    man ::%table-data ...                                            */
;*---------------------------------------------------------------------*/
(define-method (man c::%table-data)
   (with-access::%table-data c (body)
      (man body)))

;*---------------------------------------------------------------------*/
;*    man ::%character ...                                             */
;*---------------------------------------------------------------------*/
(define-method (man obj::%character)
   (case (%character-value obj)
      ((copyright)
       (display "(c)"))
      ((#\space)
       (display #\space))
      ((#\tab)
       (display #\tab))))

;*---------------------------------------------------------------------*/
;*    man ::%hook ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (man obj::%hook)
   (with-access::%hook obj (body before after process)
      (if (procedure? before)
	  (let ((bef (before)))
	     (if process (man bef))))
      (call-next-method)
      (if (procedure? after)
	  (let ((af (after)))
	     (if process (man af))))))

;*---------------------------------------------------------------------*/
;*    man ::%figure ...                                                */
;*---------------------------------------------------------------------*/
(define-method (man obj::%figure)
   (with-access::%figure obj (body legend number)
      (newline)
      (man body)
      (newline)
      (newline)
      (display "Fig. ")
      (display (number->string number))
      (display ": ")
      (man legend)
      (newline)))

;*---------------------------------------------------------------------*/
;*    man ::%footnote ...                                              */
;*---------------------------------------------------------------------*/
(define-method (man obj::%footnote)
   (with-access::%footnote obj (note body number)
      (man body)
      (display (string-append "(*" (number->string number) ")"))))

;*---------------------------------------------------------------------*/
;*    Top level form to register the newly loaded back-end             */
;*---------------------------------------------------------------------*/
(register-backend! 'man man)
