;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/sui.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov 19 10:54:17 2001                          */
;*    Last change :  Sun Dec  2 16:17:36 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Scribe Url Index ending.                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_sui

   (import __scribeapi_param)
   
   (export (scribe-url-index-search ::bstring i l c s ss sss)))

;*---------------------------------------------------------------------*/
;*    scribe-url-index-search ...                                      */
;*---------------------------------------------------------------------*/
(define (scribe-url-index-search sui id label chapter section subsection subsubsection)
   (if (>fx *scribe-verbose* 0)
       (fprint (current-error-port) "  [loading sui: " sui "]"))
   (let ((p (open-input-file sui)))
      (if (not (input-port? p))
	  (error "scribe" "Can't find `Scribe Url Index' file" sui)
	  (let ((sexp (read p)))
	     (close-input-port p)
	     (match-case sexp
		((scribe-url-index (? string?) :file ?file . ?index)
		 (cond
		    (label (search-index label (assq 'marks index)))
		    (chapter (search-index chapter (assq 'chapters index)))
		    (section (search-index section (assq 'sections index)))
		    (subsection (search-index subsection (assq 'subsections index)))
		    (subsubsection (search-index subsubsection (assq 'subsubsections index)))
		    (id (search-all id index))
		    (else (values file #f))))
		(else
		 (error "scribe" "Illegal `sui' format" sexp)))))))

;*---------------------------------------------------------------------*/
;*    search-index ...                                                 */
;*---------------------------------------------------------------------*/
(define (search-index str::bstring lst)
   (if (pair? lst)
       (let ((cell (assoc str (cdr lst))))
	  (match-case cell
	     ((or (?- :file ?file :mark ?mark) (?- :mark ?mark :file ?file))
	      (values file mark))
	     ((?- :file ?file)
	      (values file #f))
	     (else
	      (if (not cell)
		  (values #f str)
		  (error "scribe" "Illegal `sui' format" cell)))))
       (values #f str)))

;*---------------------------------------------------------------------*/
;*    search-all ...                                                   */
;*---------------------------------------------------------------------*/
(define (search-all str::bstring index::pair-nil)
   (let loop ((index index))
      (if (null? index)
	  (values #f str)
	  (multiple-value-bind (file mark)
	     (search-index str (car index))
	     (if file
		 (values file mark)
		 (loop (cdr index)))))))
   
