;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/rts.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 17 14:00:40 2001                          */
;*    Last change :  Wed Jan  9 14:40:26 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The runtime part of the Scribe API (i.e. the functions defined   */
;*    in that module are used to implement Scribe back-ends).          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_rts

   (import __scribeapi_ast
	   __scribeapi_misc
	   __scribeapi_param)
   
   (export (current-document)
	   (current-chapter)

	   (with-document ::%document ::procedure)
	   (with-chapter ::%chapter ::procedure)
	   
	   (document-chapters::pair-nil ::%document)
	   (document-sections::pair-nil ::%document)
	   (document-sections*::pair-nil ::%document)
	   (document-title ::%document)
	   (document-file ::%document)
	   
	   (chapter-sections::pair-nil ::%chapter)
	   (chapter-title ::%chapter)
	   (chapter-subtitle ::%chapter)
	   (chapter-children ::%chapter)
	   (chapter-file ::%chapter)
	   (chapter-next ::%chapter)
	   (chapter-previous ::%chapter)
	   
	   (section-subsections::pair-nil ::%section)
	   (section-title ::%section)
	   
	   (subsection-subsubsections::pair-nil ::%subsection)
	   (subsection-title ::%subsection)
	   
	   (subsubsection-title ::%subsubsection)

	   (strip-ref-base::bstring ::bstring)
	   
	   (generic find-reference ::obj ::%document)
	   
	   (generic container-file ::%container))

   (eval   (export-exports)))

;*---------------------------------------------------------------------*/
;*    *current-document* ...                                           */
;*---------------------------------------------------------------------*/
(define *current-document* #f)

;*---------------------------------------------------------------------*/
;*    current-document ...                                             */
;*---------------------------------------------------------------------*/
(define (current-document)
   *current-document*)

;*---------------------------------------------------------------------*/
;*    with-document ...                                                */
;*---------------------------------------------------------------------*/
(define (with-document doc proc)
   (let ((old *current-document*))
      (set! *current-document* doc)
      (let ((res (proc)))
	 (set! *current-document* old)
	 res)))

;*---------------------------------------------------------------------*/
;*    *current-chapter* ...                                            */
;*---------------------------------------------------------------------*/
(define *current-chapter* #f)

;*---------------------------------------------------------------------*/
;*    current-chapter ...                                              */
;*---------------------------------------------------------------------*/
(define (current-chapter)
   *current-chapter*)

;*---------------------------------------------------------------------*/
;*    with-chapter ...                                                 */
;*---------------------------------------------------------------------*/
(define (with-chapter doc proc)
   (let ((old *current-chapter*))
      (set! *current-chapter* doc)
      (let ((res (proc)))
	 (set! *current-chapter* old)
	 res)))

;*---------------------------------------------------------------------*/
;*    Aliasing ...                                                     */
;*---------------------------------------------------------------------*/
(define document-title %document-title)
(define document-file %document-file)

(define chapter-title %chapter-title)
(define chapter-subtitle %chapter-subtitle)
(define chapter-children %chapter-children)

(define section-title %section-title)

(define subsection-title %subsection-title)

(define subsubsection-title %subsubsection-title)

;*---------------------------------------------------------------------*/
;*    document-chapters ...                                            */
;*---------------------------------------------------------------------*/
(define (document-chapters doc::%document)
   (with-access::%document doc (chapters children)
      (if (or (null? chapters) (pair? chapters))
	  chapters
	  (begin
	     (set! chapters (filter %chapter? children))
	     chapters))))

;*---------------------------------------------------------------------*/
;*    document-sections ...                                            */
;*---------------------------------------------------------------------*/
(define (document-sections doc::%document)
   (with-access::%document doc (sections children)
      (if (or (null? sections) (pair? sections))
	  sections
	  (begin
	     (set! sections (filter %section? children))
	     sections))))

;*---------------------------------------------------------------------*/
;*    document-sections* ...                                           */
;*---------------------------------------------------------------------*/
(define (document-sections* doc::%document)
   (with-access::%document doc (sections* children)
      (if (or (null? sections*) (pair? sections*))
	  sections*
	  (begin
	     (set! sections*
		   (apply append
			  (cons (document-sections doc)
				(map chapter-sections
				     (document-chapters doc)))))
	     sections*))))

;*---------------------------------------------------------------------*/
;*    chapter-sections ...                                             */
;*---------------------------------------------------------------------*/
(define (chapter-sections doc::%chapter)
   (with-access::%chapter doc (sections children)
      (if (or (null? sections) (pair? sections))
	  sections
	  (begin
	     (set! sections (filter %section? children))
	     sections))))

;*---------------------------------------------------------------------*/
;*    chapter-file ...                                                 */
;*---------------------------------------------------------------------*/
(define (chapter-file o::%chapter)
   (with-access::%chapter o (file parent)
      (if (string? file)
	  file
	  (%document-file parent))))

;*---------------------------------------------------------------------*/
;*    chapter-previous ...                                             */
;*---------------------------------------------------------------------*/
(define (chapter-previous o::%chapter)
   (let loop ((chaps (filter (lambda (x)
				(and (%chapter? x) (%chapter-number x)))
			     (%container-children (%chapter-parent o)))))
      (cond
	 ((null? chaps)
	  #f)
	 ((null? (cdr chaps))
	  #f)
	 ((eq? chaps o)
	  #f)
	 ((eq? o (cadr chaps))
	  (car chaps))
	 (else
	  (loop (cdr chaps))))))

;*---------------------------------------------------------------------*/
;*    chapter-next ...                                                 */
;*---------------------------------------------------------------------*/
(define (chapter-next o::%chapter)
   (let* ((chaps (filter (lambda (x)
			    (and (%chapter? x) (%chapter-number x)))
			 (%container-children (%chapter-parent o))))
	  (rest (memq o chaps)))
      (if (and (pair? rest) (pair? (cdr rest)))
	  (cadr rest)
	  #f)))

;*---------------------------------------------------------------------*/
;*    section-subsections ...                                          */
;*---------------------------------------------------------------------*/
(define (section-subsections doc::%section)
   (with-access::%section doc (subsections children)
      (if (or (null? subsections) (pair? subsections))
	  subsections
	  (begin
	     (set! subsections (filter %subsection? children))
	     subsections))))

;*---------------------------------------------------------------------*/
;*    subsection-subsubsections ...                                    */
;*---------------------------------------------------------------------*/
(define (subsection-subsubsections doc::%subsection)
   (with-access::%subsection doc (subsubsections children)
      (if (or (null? subsubsections) (pair? subsubsections))
	  subsubsections
	  (begin
	     (set! subsubsections (filter %subsubsection? children))
	     subsubsections))))

;*---------------------------------------------------------------------*/
;*    container-file ...                                               */
;*---------------------------------------------------------------------*/
(define-generic (container-file c::%container))

;*---------------------------------------------------------------------*/
;*    container-file ::%document ...                                   */
;*---------------------------------------------------------------------*/
(define-method (container-file c::%document)
   (%document-file c))

;*---------------------------------------------------------------------*/
;*    container-file ::%chapter ...                                    */
;*---------------------------------------------------------------------*/
(define-method (container-file c::%chapter)
   (with-access::%chapter c (file)
      (if (string? file)
	  file
	  (container-file (%chapter-parent c)))))

;*---------------------------------------------------------------------*/
;*    container-file ::%block ...                                      */
;*---------------------------------------------------------------------*/
(define-method (container-file c::%block)
   (container-file (%block-parent c)))

;*---------------------------------------------------------------------*/
;*    find-reference ::obj ...                                         */
;*---------------------------------------------------------------------*/
(define-generic (find-reference o::obj doc::%document)
   (find-reference (instantiate::%unknown-ref
		      (anchor o))
		   doc))

;*---------------------------------------------------------------------*/
;*    find-reference ::%unknown-ref ...                                */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%unknown-ref doc::%document)
   (with-access::%unknown-ref o (anchor)
      (multiple-value-bind (file val)
	 (find-reference
	  (instantiate::%mark-ref
	     (anchor anchor))
	  doc)
	 (if val
	     (values file val)
	     (multiple-value-bind (file val)
		(find-reference
		 (instantiate::%biblio-ref
		    (anchor anchor))
		 doc)
		(if val
		    (values file val)
		    (if (equal? anchor (%document-title doc))
			(values (strip-ref-base (%document-file doc)) #t)
			(multiple-value-bind (file val)
			   (find-reference
			    (instantiate::%chapter-ref
			       (anchor anchor))
			    doc)
			   (if val
			       (values file val)
			       (multiple-value-bind (file val)
				  (find-reference
				   (instantiate::%section-ref
				      (anchor anchor))
				   doc)
				  (if val
				      (values file val)
				      (multiple-value-bind (file val)
					 (find-reference
					  (instantiate::%subsection-ref
					     (anchor anchor))
					  doc)
					 (if val
					     (values file val)
					     (multiple-value-bind (file val)
						(find-reference
						 (instantiate::%subsubsection-ref
						    (anchor anchor))
						 doc)
						(if val
						    (values file val)
						    (values #f #f))))))))))))))))

;*---------------------------------------------------------------------*/
;*    find-reference ::%url-ref ...                                    */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%url-ref doc::%document)
   (with-access::%url-ref o (anchor url)
      (values url anchor)))

;*---------------------------------------------------------------------*/
;*    find-reference ::%chapter-ref ...                                */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%chapter-ref doc::%document)
   (let* ((anchor (%reference-anchor o))
	  (c (if (%chapter? anchor)
		 anchor
		 (let ((pred (lambda (c::%chapter)
				(if (or (equal? (%chapter-title c) anchor)
					(equal? (%chapter-subtitle c) anchor))
				    c
				    #f)))
		       (cs (document-chapters doc)))
		    (find-first pred cs)))))
      (if (%chapter? c)
	  (values (strip-ref-base (chapter-file c)) c)
	  (values #f #f))))

;*---------------------------------------------------------------------*/
;*    find-reference ::%section-ref ...                                */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%section-ref doc::%document)
   (let* ((anchor (%reference-anchor o))
	  (s (if (%section? anchor)
		 anchor
		 (let ((pred (lambda (s::%section)
				(if (equal? (%section-title s) anchor)
				    s
				    #f))))
		    (find-first pred (document-sections* doc))))))
      (if (%section? s)
	  (values (strip-ref-base (container-file s)) s)
	  (values #f #f))))
	  
;*---------------------------------------------------------------------*/
;*    find-reference ::%subsection-ref ...                             */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%subsection-ref doc::%document)
   (let* ((anchor (%reference-anchor o))
	  (s (if (%subsection? anchor)
		 anchor
		 (let* ((preds (lambda (s::%subsection)
				  (if (equal? (%subsection-title s) anchor)
				      s
				      #f)))
			(pred (lambda (s::%section)
				 (find-first preds (section-subsections s)))))
		    (find-first pred (document-sections* doc))))))
      (if (%subsection? s)
	  (values (strip-ref-base (container-file s)) s)
	  (values #f #f))))
	  
;*---------------------------------------------------------------------*/
;*    find-reference ::%subsubsection-ref ...                          */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%subsubsection-ref doc::%document)
   (let* ((anchor (%reference-anchor o))
	  (s (if (%subsubsection? anchor)
		 anchor
		 (let* ((predss (lambda (s::%subsubsection)
				   (if (equal? (%subsubsection-title s) anchor)
				       s
				       #f)))
			(preds (lambda (s::%subsection)
				  (find-first predss
					      (subsection-subsubsections s))))
			(pred (lambda (section::%section)
				 (find-first preds
					     (section-subsections section)))))
		    (find-first pred (document-sections* doc))))))
      (if (%subsubsection? s)
	  (values (strip-ref-base (container-file s)) s)
	  (values #f #f))))
	  
;*---------------------------------------------------------------------*/
;*    find-reference ::%mark-ref ...                                   */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%mark-ref doc::%document)
   (let* ((anchor (%reference-anchor o))
	  (val (if (%mark? anchor)
		   anchor
		   (let ((table (%document-mark-table doc)))
		      (hashtable-get table anchor)))))
      (if (%mark? val)
	  (values (strip-ref-base (container-file (%mark-parent val))) anchor)
	  (values #f #f))))
      
;*---------------------------------------------------------------------*/
;*    find-reference ::%bilbio-ref ...                                 */
;*---------------------------------------------------------------------*/
(define-method (find-reference o::%biblio-ref doc::%document)
   (values #f #f))

;*---------------------------------------------------------------------*/
;*    strip-ref-base ...                                               */
;*---------------------------------------------------------------------*/
(define (strip-ref-base file)
   (if (not (string? *scribe-ref-base*))
       file
       (let ((l (string-length *scribe-ref-base*)))
	  (cond
	     ((not (>fx (string-length file) (+fx l 2)))
	      file)
	     ((not (substring=? file *scribe-ref-base* l))
	      file)
	     ((not (char=? (string-ref file l) (file-separator)))
	      file)
	     (else
	      (substring file (+fx l 1) (string-length file)))))))
       
       
