;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribeapi/index.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec  2 08:29:15 2001                          */
;*    Last change :  Thu Jan 10 11:40:54 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Scribe index handling                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribeapi_index

   (import  __scribeapi_ast
	    __scribeapi_api
	    __scribeapi_rts
	    __scribeapi_param)

   (export  (scribe-print-index ::bool ::pair ::int)))

;*---------------------------------------------------------------------*/
;*    scribe-print-index ...                                           */
;*---------------------------------------------------------------------*/
(define (scribe-print-index split indexes char-offset)
   (define (index-ref name ref margin)
      (if (>=fx char-offset (string-length name))
	  (error "print-index" "char-offset out of bound" char-offset)
	  (cons (string-ref name char-offset)
		(list margin ref "\n"))))
   ;; produce one index master (i.e. first) ref
   (define (index-master-ref ie::%index)
      (with-access::%index ie (note name shape id)
	 (if note
	     (index-ref name (list (ref :mark id shape) (it " (" note ")")) "")
	     (index-ref name (ref :mark id shape) ""))))
   ;; produce one index master (i.e. second, third, ...) ref
   (define (index-slave-ref ie::%index)
      (with-access::%index ie (note name shape id)
	 (index-ref name (ref :mark id (it (or note shape)))
		    "   ...")))
   ;; print a list of index references according to the number of columns
   ;; and with a possible header line
   (define (print-index-references refs . header)
      (let ((body (pre (map cdr refs))))
	 (if (pair? header)
	     (list (bold (it (if *scribe-index-font-size*
				 (font :size *scribe-index-font-size*
				       (car header))
				 (car header))))
		   body)
	     body)))
   ;; accumulate all the entries starting with the same letter
   (define (letter-references refs)
      (let ((letter (car (car refs))))
	 (let loop ((refs refs)
		    (acc '()))
	    (if (or (null? refs) (not (char=? letter (car (car refs)))))
		(values refs (reverse! acc))
		(loop (cdr refs) (cons (car refs) acc))))))
   ;; sort the entries, flatten them and print them
   (let* ((entries (apply append (map hashtable->list indexes)))
	  (sorted (sort entries (lambda (e1 e2)
				   (string<? (%index-name (car e1))
					     (%index-name (car e2))))))
	  (flat (apply append
		       (map (lambda (e)
			       (let ((ies (sort (reverse e)
						(lambda (ie1 ie2)
						   (not (%index-note ie1))))))
				  (cons (index-master-ref (car ies))
					(map index-slave-ref (cdr ies)))))
			    sorted))))
      (if (not split)
	  (print-index-references flat)
	  (let loop ((refs flat)
		     (subindexes '()))
	     (if (null? refs)
		 (reverse! subindexes)
		 (multiple-value-bind (refs currents)
		    (letter-references refs)
		    (let ((header (string (car (car currents)))))
		       (loop refs
			     (cons (print-index-references currents header)
				   subindexes)))))))))
   
