#include <config.h>
#include <gnome.h>

#include "dtd.h"
#include "editor.h"
#include "htmlfuncs.h"
#include "page.h"
#include "php3.h"
#include "site.h"
#include "support.h"
#include "fileops.h"

extern GNode *editor_parse_tree;
extern GtkWidget *app;
extern Site *current_site;

static GHashTable *php_func_table;

void screem_php_build_function_hash_table()
{
	gchar *buffer;
	gchar *proto;
	gchar *name;
	gchar *temp;
	FILE *in;
	const gchar *func_file = SYNTAX_PATH"/php3_functions";

	php_func_table = g_hash_table_new(g_str_hash, g_str_equal);

	/* now place all php functions in the hash table,
	   the name of the function as the key, and the
	   prototype as the value */

	in = fopen( func_file, "r" );

	if( ! in )
		return;

	buffer = g_new( gchar, BUFSIZ );
	while( fgets( buffer, BUFSIZ, in ) ) {
		/* we have read in a line,
		   ignore the class the function belongs to 
		 */
		if( ! ( proto = strchr( buffer, ':' ) ) )
			continue;
		proto += 1;
		if( ! ( name = strchr( proto, ' ' ) ) )
			continue;
		name += 1;
		if( ! ( temp = strchr( name, '(' ) ) )
			continue;
		proto = g_strdup( proto );
		name = g_strndup( name, temp - name );
		g_hash_table_insert( php_func_table, name, proto );
	}
	g_free( buffer );
}

void screem_php_destroy_function_hash_table()
{
	g_hash_table_destroy( php_func_table );
}

void screem_php_authenticate()
{
	/* this is from the PHP3 manual */
	const gchar *auth = "\
<script language=\"php\">\n\
if(!isset($PHP_AUTH_USER)) {\n\
\tHeader(\"WWW-Authenticate: Basic realm=\\\"My Realm\\\"\");\n\
\tHeader(\"HTTP/1.0 401 Unauthorized\");\n\
\techo \"Text to send if user hits Cancel button\\n\";\n\
\texit;\n\
} else {\n\
\techo \"Hello $PHP_AUTH_USER.<P>\";\n\
\techo \"You entered $PHP_AUTH_PW as your password.<P>\";\n\
}\n\
</script>";
	screem_editor_insert( -1, auth );
}

void screem_php_require()
{
	gchar *filename;
	gchar *text;
	Page *page;
	gchar *path;
	gchar cwd[ 16384 ];
	const gchar *site_path;
	const gchar *require = "<?php require '%s' ?>";

	getcwd( cwd, 16384 );

	filename = file_select( _("Select file to include") );

	if( ! filename )
		return;

	/* make filename relative to the page path */
	page = screem_site_get_current_page( current_site );
	site_path = screem_site_get_pathname( current_site );
	screem_page_chdir( page );
	path = relative_path( filename, site_path );
	g_free( filename );
     
	text = g_strdup_printf( require, path );

	screem_editor_insert( -1, text );

	g_free( path );
	g_free( text );

	chdir( cwd );
}

gboolean php_tooltip( gint pos, gchar *text )
{
	gchar *word;
	gchar *value;
	gboolean ret;
	ScreemDTD *dtd;

	ret = FALSE;

	/* if pos is not inside a php tag / script context then
	   we don't want to do this */

	dtd = screem_get_doctype( text );
	if( ! editor_parse_tree )
                editor_parse_tree = screem_html_build_parse_tree( dtd,text,0 );

	/* get the word */
	word = screem_editor_get_word( pos, text );

	/* does word match a PHP function? 
	   what about a variable?

	   with a function we can show its prototype,
	   with a variable we could show its type and value */

	if( ! word )
		return ret;

	/* word obtained, is it a php function? */
	value = (gchar*)g_hash_table_lookup( php_func_table, word );
	if( value ) {
		/* it is */
		screem_show_message( value );
		ret = TRUE;
	}

	g_free( word );

	return ret;
}
