/*  Screem:  interface.c,
 *  This file creates the main interface for the program.
 * 
 *  Copyright (C) 1999, 2000, 2001  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gnome.h>
#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

#include <glade/glade.h>

#include "editor.h"
#include "interface.h"
#include "linkview.h"
#include "menus.h"
#include "pageUI.h"
#include "preferences.h"
#include "preview.h"
#include "siteTreeUI.h"
#include "siteUI.h"
#include "toolbar.h"

#include "structure.h"

extern Preferences *cfg;

GladeXML *main_interface_xml;

void edbook_tab_switch( GtkNotebook *notebook, GtkNotebookPage *page,
			guint page_num );
void sitebook_switch( GtkNotebook *notebook, GtkNotebookPage *page,
		      guint page_num );

void screem_interface_resize( GtkWidget *widget, GtkAllocation *a );

static gboolean screem_parse_layout_config( gchar *item, 
					    GnomeDockPlacement *place,
					    gint *band_num,
					    gint *band_pos,
					    gint *offset);

static GtkWidget *hack_hack_hack;

GtkWidget* create_splash()
{
	GladeXML *xml;
	GtkWidget *widget;
	GtkWidget *display;

	xml = glade_xml_new( cfg->glade_path, "splash" );
	display = glade_xml_get_widget( xml, "splash_display" );
	widget = glade_xml_get_widget( xml, "splash" );

	gtk_object_set_data( GTK_OBJECT( widget ), "text1", display );

	gtk_object_unref( GTK_OBJECT( xml ) );

	return widget;
}

void create_about()
{
	GladeXML *xml;

	xml = glade_xml_new( cfg->glade_path, "about" );
}

GtkWidget* create_app( gboolean normal, gchar *appname, gchar *title )
{
	GtkWidget *app;
	GtkWidget *toolbar;
	GtkWidget *htmlbook;
	GtkWidget *appbar;
	GtkWidget *label;
	GtkWidget *shell;

	GtkWidget *sitebook;
	GtkWidget *combo;
       	GtkWidget *tree;
	GtkWidget *list;

	GtkWidget *sw;
	GtkWidget *link_view;
	GtkWidget *link_view_legend;

	GtkWidget *notebook = NULL;
	GtkWidget *box;

	GladeXML *xml;

	gint bars;
	gint i;
	gint row;
	gint col;
	gchar *name;

	GnomeDockPlacement place;
	gint band_num;
	gint band_pos;
	gint offset;

	main_interface_xml = xml = glade_xml_new( cfg->glade_path, "main_app" );

	gtk_widget_push_visual(gdk_rgb_get_visual());
        gtk_widget_push_colormap(gdk_rgb_get_cmap());

	gtk_widget_pop_colormap();
        gtk_widget_pop_visual();

	shell = glade_xml_get_widget( xml, "guile_shell_table" );
#ifndef HAVE_GUILE
	gtk_widget_set_sensitive( shell, FALSE );
#endif

	/* get the app window */
	hack_hack_hack = app = glade_xml_get_widget( xml, "main_app" );

	gnome_app_enable_layout_config( GNOME_APP( app ), TRUE );

	gnome_app_create_menus( GNOME_APP( app ), main_menu );

	appbar = glade_xml_get_widget( xml, "appbar" );
     	gnome_app_install_menu_hints( GNOME_APP( app ), main_menu );

	/* the editing notebook area */
	notebook = glade_xml_get_widget( xml, "edbook" );
	gtk_object_set_data( GTK_OBJECT( app ), "notebook", notebook );

	gtk_notebook_set_page( GTK_NOTEBOOK( notebook ), 1 );

	/* add the link view canvas */
	link_view = glade_xml_get_widget( xml, "link_view" );
	link_view_legend = glade_xml_get_widget( xml, "link_view_legend" );
	sw = glade_xml_get_widget( xml, "link_view_window" );
	gtk_widget_set_usize( sw, cfg->editor_width, cfg->editor_height );
	gtk_object_set_data( GTK_OBJECT( app ), "link_view", link_view );
	gtk_object_set_data( GTK_OBJECT( app ), "link_view_legend", 
			     link_view_legend );
	gtk_object_set_data( GTK_OBJECT( link_view ), "window", sw );

	/* the editor status */
	label = glade_xml_get_widget( xml, "ed_stat" );
	gtk_object_set_data( GTK_OBJECT( app ), "editor_status", label );

	/* create/attach the menu/toolbars/statusbar */
	toolbar = create_toolbar1();
	screem_parse_layout_config( "toolbar1", &place, &band_num, &band_pos,
				    &offset);
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar1", GNOME_DOCK_ITEM_BEH_NORMAL,
			       place, band_num, band_pos, 0 );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolbar );

	toolbar = create_toolbar2();
	screem_parse_layout_config( "toolbar2", &place, &band_num, &band_pos,
				    &offset);
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar2", GNOME_DOCK_ITEM_BEH_NORMAL,
			       place, band_num, band_pos, 0 );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolbar );

	toolbar = create_toolbar3();
	screem_parse_layout_config( "toolbar3", &place, &band_num, &band_pos,
				    &offset);
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar3", GNOME_DOCK_ITEM_BEH_NORMAL,
			       place, band_num, band_pos, 0 );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolbar );

	toolbar = create_browsers_bar();
	screem_parse_layout_config( "external_browsers", &place, &band_num, 
				    &band_pos, &offset);
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "external_browsers", GNOME_DOCK_ITEM_BEH_NORMAL,
			       place, band_num, band_pos, 0 );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolbar );

	toolbar = create_toolbar4();
	screem_parse_layout_config( "toolbar4", &place, &band_num, 
				    &band_pos, &offset);
	gnome_app_add_toolbar( GNOME_APP( app ), GTK_TOOLBAR( toolbar ),
			       "toolbar4", GNOME_DOCK_ITEM_BEH_NORMAL,
			       place, band_num, band_pos, 0 );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolbar );

	if( cfg->mpage->viewbar ) {
		toolbar = create_sidebar();
		if( !screem_parse_layout_config( "sidebar", &place, &band_num, 
						 &band_pos, &offset) ) {
			place = GNOME_DOCK_RIGHT;
		}
		gnome_app_add_toolbar( GNOME_APP( app ), 
				       GTK_TOOLBAR( toolbar ),
				       "sidebar", 
				       GNOME_DOCK_ITEM_BEH_LOCKED |
				       GNOME_DOCK_ITEM_BEH_EXCLUSIVE,
				       place, band_num, band_pos, 0 );
		gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), 
				       GTK_TOOLBAR_ICONS );
		gtk_object_set_data( GTK_OBJECT( notebook ), "sidebar", 
				     toolbar );
		gtk_widget_show( toolbar );
	} else
		gtk_notebook_set_show_tabs( GTK_NOTEBOOK( notebook ), TRUE );
	
	/* the page notebook */
	box = glade_xml_get_widget( xml, "hack_box" );
	notebook = gtk_notebook_new();
	gtk_notebook_set_scrollable( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_BOTTOM );
	gtk_notebook_set_show_border( GTK_NOTEBOOK( notebook ), FALSE );
	gtk_notebook_set_tab_border( GTK_NOTEBOOK( notebook ), 0 );
	gtk_box_pack_start( GTK_BOX( box ), notebook, TRUE, TRUE, 0 );
	gtk_object_set_data( GTK_OBJECT( app ), "pagebook", notebook );
	gtk_signal_connect( GTK_OBJECT( notebook ), "switch_page",
			    GTK_SIGNAL_FUNC( page_book_switch ), NULL );
 
	glade_xml_signal_autoconnect( xml );

	xml = glade_xml_new( cfg->glade_path, "htmlbook" );
	htmlbook = glade_xml_get_widget( xml, "htmlbook" );
	
	bars = g_list_length( GTK_NOTEBOOK( htmlbook )->first_tab );
	row = 2;
	col = 1;
	for( i = 0; i < bars; i ++ ) {
		toolbar = gtk_notebook_get_nth_page( GTK_NOTEBOOK( htmlbook ),
						     i );
		label = gtk_notebook_get_tab_label( GTK_NOTEBOOK( htmlbook ),
						    toolbar );
		gtk_label_get( GTK_LABEL( label ), &name );
		if( ! cfg->mpage->notebookbar ) {
			gtk_widget_ref( toolbar );
			gtk_widget_unparent( toolbar );

			if( !screem_parse_layout_config( name, &place, 
							 &band_num, 
							 &band_pos, &offset) ){
				place = GNOME_DOCK_TOP;
				band_num = row;
				band_pos = col;
			}
			gnome_app_add_toolbar( GNOME_APP( app ), 
					       GTK_TOOLBAR( toolbar ),
					       name, 
					       GNOME_DOCK_ITEM_BEH_NORMAL,
					       place, band_num, band_pos, 0 );
			gtk_widget_unref( toolbar );
		}
                gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ),
				       GTK_TOOLBAR_ICONS );
		gtk_widget_show( toolbar );
		/* increase col by number of buttons in the toolbar */
		col += GTK_TOOLBAR( toolbar )->num_children;
		if( col > 10 ) {
			row ++;
			col = 0;
		}
	}
	
	toolbar = glade_xml_get_widget( xml, "formbar" );
	gtk_object_set_data( GTK_OBJECT( app ), "form_bar", toolbar );

	toolbar = glade_xml_get_widget( xml, "helperbar" );
	gtk_object_set_data( GTK_OBJECT( app ), "helperbar", toolbar );

      	/* a toolbar to put wizards on */
	toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
				   GTK_TOOLBAR_ICONS );
	gtk_toolbar_set_button_relief( GTK_TOOLBAR( toolbar ), 
				       GTK_RELIEF_NONE );
	gtk_object_set_data( GTK_OBJECT( app ), "wizardbar", toolbar );

	if( cfg->mpage->notebookbar ) {
		label = gtk_label_new( _("Wizards") );
		gtk_widget_show( toolbar );
		gtk_widget_show( label );
		gtk_notebook_prepend_page( GTK_NOTEBOOK( htmlbook ), toolbar, 
					   label );
		if( !screem_parse_layout_config( "htmlbook", &place, 
						 &band_num, 
						 &band_pos, &offset) ){
			place = GNOME_DOCK_TOP;
			band_num = 2;
			band_pos = 1;
		}
		gnome_app_add_docked( GNOME_APP( app ), htmlbook,
				      "htmlbook", 
				      GNOME_DOCK_ITEM_BEH_EXCLUSIVE,
				      GNOME_DOCK_TOP, 2, 1, 0 );
	} else {
		if( !screem_parse_layout_config( "wizardbar", &place, 
						 &band_num, 
						 &band_pos, &offset) ){
			place = GNOME_DOCK_TOP;
			band_num = ++row;
			band_pos = 0;
		}
		gnome_app_add_toolbar( GNOME_APP( app ), 
				       GTK_TOOLBAR( toolbar ),
				       "wizardbar", 
				       GNOME_DOCK_ITEM_BEH_NORMAL,
				       place, band_num, band_pos, 0 );

	}
	gtk_toolbar_set_style( GTK_TOOLBAR( toolbar ), GTK_TOOLBAR_ICONS);
	gtk_widget_show( toolbar );

	glade_xml_signal_autoconnect( xml );

	/* handle dock items */
	xml = glade_xml_new( cfg->glade_path, "dockitems" );
	/* create the site notebook */
    	sitebook = glade_xml_get_widget( xml, "sitebook" );
	gtk_object_set_data( GTK_OBJECT( app ), "sitebook", sitebook );
	gtk_widget_set_usize( sitebook, cfg->file_width, cfg->file_height );
	gtk_widget_ref( sitebook );
	gtk_widget_unparent( sitebook );

	notebook = glade_xml_get_widget( xml, "messages_book" );
	gtk_widget_set_usize( notebook, -1, cfg->messages_height );
	gtk_widget_ref( notebook );
	gtk_widget_unparent( notebook );

	combo = glade_xml_get_widget( xml, "combo" );
	gtk_object_set_data( GTK_OBJECT( app ), "sitecombo", combo );

	/* the tree */
	tree = glade_xml_get_widget( xml, "tree" );
        gtk_clist_set_column_auto_resize( GTK_CLIST( tree ), 0, TRUE );

	gtk_drag_source_set( tree, ( GDK_BUTTON1_MASK | GDK_BUTTON2_MASK ),
			     site_tree_drag_types, site_tree_num_drag_types,
			     ( GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK ) );
	gtk_drag_dest_set(tree,
			  (GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP),
			  site_tree_drop_types, site_tree_num_drop_types,
			  (GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK)
			  );
	gtk_object_set_data( GTK_OBJECT( app ), "file_tree", tree );

	/* Add the browse tab to the sitebook */
	list = glade_xml_get_widget( xml, "list" );
	gtk_object_set_data( GTK_OBJECT( app ), "browse", list );

	gtk_drag_source_set( list, ( GDK_BUTTON1_MASK | GDK_BUTTON2_MASK ),
			     site_tree_drag_types, site_tree_num_drag_types,
			     ( GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK ) );
	gtk_drag_dest_set(list, 
			  (GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP),
			  site_tree_drop_types, site_tree_num_drop_types,
			  (GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_ASK)
			  );

	box = glade_xml_get_widget( xml, "attribute_box" );
	gtk_object_set_data( GTK_OBJECT( app ), "attr_box", box );

	/* create the resources tab/tree */
	sw = glade_xml_get_widget( xml, "resources_window" );
	gtk_object_set_data( GTK_OBJECT( app ), "resource_window", sw );

	tree = glade_xml_get_widget( xml, "resources_tree" );
	gtk_object_set_data( GTK_OBJECT( app ), "resource_tree", tree );
	gtk_drag_source_set( tree, ( GDK_BUTTON1_MASK | GDK_BUTTON2_MASK ),
			     site_tree_drag_types, site_tree_num_drag_types,
			     ( GDK_ACTION_COPY | GDK_ACTION_ASK ) );
	gtk_drag_dest_set(tree,
			  (GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP),
			  site_tree_drop_types, site_tree_num_drop_types,
			  (GDK_ACTION_COPY | GDK_ACTION_ASK)
			  );

	resource_list_display( tree );
	gtk_widget_set_usize( tree, cfg->tag_width, cfg->tag_height );

	/* setup the DnD for the structure tree */
	tree = glade_xml_get_widget( xml, "structure_tree" );
	gtk_drag_source_set( tree, ( GDK_BUTTON1_MASK | GDK_BUTTON2_MASK ),
			     structure_tree_drag_types, 
			     structure_tree_num_drag_types,
			     GDK_ACTION_MOVE );
	gtk_drag_dest_set( tree,	(GTK_DEST_DEFAULT_HIGHLIGHT |
					 GTK_DEST_DEFAULT_DROP),
			   structure_tree_drop_types, 
			   structure_tree_num_drop_types,
			   GDK_ACTION_MOVE );

	glade_xml_signal_autoconnect( xml );

	/* sitebook and notebook are the widgets we want */
	gtk_widget_show( sitebook );
	if( ! screem_parse_layout_config( "sitebook", &place, &band_num, 
					  &band_pos, &offset) ) {
		place = GNOME_DOCK_LEFT;
		band_num = band_pos = 1;
	}
	gnome_app_add_docked( GNOME_APP( app ), sitebook, "sitebook", 
			      GNOME_DOCK_ITEM_BEH_EXCLUSIVE,
			      place, band_num, band_pos, 0 );
	gtk_widget_show( notebook );
	if( ! screem_parse_layout_config( "messages_book", &place, &band_num, 
					  &band_pos, &offset) ) {
		place = GNOME_DOCK_BOTTOM;
		band_num = band_pos = 1;
	}
	gnome_app_add_docked( GNOME_APP( app ), notebook, "messages_book", 
			      GNOME_DOCK_ITEM_BEH_EXCLUSIVE,
			      place, band_num, band_pos, 0 );
	gtk_widget_show( sitebook );
	gtk_widget_show( notebook );

	return app;
}

void edbook_tab_switch( GtkNotebook *notebook, GtkNotebookPage *page,
			guint page_num )
{
  	switch( page_num ) {
	case 2:
		screem_link_view_create();
		break;
	case 1:
		preview_current_page();
		break;
	default:
		break;

	}
}

void sitebook_switch( GtkNotebook *notebook, GtkNotebookPage *page,
		      guint page_num )
{
	switch( page_num ) {
	case 2:
		build_page_structure_tree();
		break;
	case 3:
		build_attribute_list();
		break;
	default:
		break;

	}
}

/* show/hide a dockitem */
void show_hide( GtkWidget *menuitem, gchar *name)
{
	GtkWidget *widget;
	GtkWidget *view;
	gint w;
	gint h;

	GnomeDock *dock;
	GnomeDockPlacement place;
	guint band_num;
	guint band_pos;
	guint offset;

	static gboolean block = FALSE;

	if( block )
		return;

	/* get the dockitem with the matching name */
	dock = gnome_app_get_dock( GNOME_APP( hack_hack_hack ) );
	widget = gnome_dock_get_item_by_name( dock, name, &place,
					      &band_num, &band_pos, &offset );

	w = hack_hack_hack->allocation.width;
	h = hack_hack_hack->allocation.height;

	if( GTK_WIDGET_VISIBLE( widget ) )
		gtk_widget_hide( widget );
	else
		gtk_widget_show( widget );

	if( menuitem )
		gtk_widget_set_usize( hack_hack_hack, w, h );

	if( ( ! strcmp( "sitebook", name ) ) && menuitem  ) {
		/* we need to toggle the view menu item for this as well */
		if( menuitem != view_menu[ 4 ].widget ) {
			block = TRUE;
			gtk_menu_item_activate( GTK_MENU_ITEM(view_menu[ 4 ].widget) );
			block = FALSE;
		}
	}
	else if( ! strcmp( "messages_book", name ) && menuitem ) {
		/* we need to toggle the view menu item for this as well */
		if( menuitem != view_menu[ 5 ].widget ) {
			block = TRUE;
			gtk_menu_item_activate( GTK_MENU_ITEM(view_menu[ 5 ].widget) );
			block = FALSE;
		}
	}
}

/* this is a dirty hack because GnomeApp sucks and likes random resizes
   back to its last (non user) set size if a gtk_widget_set_usize doesn't set
   its size */
void screem_interface_resize( GtkWidget *widget, GtkAllocation *a ) 
{
	static gboolean lock = FALSE;

	if( lock || ! GTK_WIDGET_REALIZED( widget ) )
		return;

	lock = TRUE;
	gtk_widget_set_usize( widget, a->width, a->height );

	while( gtk_events_pending() )
		gtk_main_iteration();

	lock = FALSE;
}

static gboolean screem_parse_layout_config( gchar *item, 
					    GnomeDockPlacement *place,
					    gint *band_num,
					    gint *band_pos,
					    gint *offset)
{
	static GList *list = NULL;
	GList *tmp;
	gchar *temp;

	GnomeDock *dock;
	GnomeDockPlacement p;
	guint bn;
	guint bp;
	guint o;

	static int inc_band_pos = 0;

	dock = gnome_app_get_dock( GNOME_APP( hack_hack_hack ) );

	temp = strstr( cfg->dock_string, item );

	if( ! temp ) {
		*place = GNOME_DOCK_TOP;
		*band_num = 1;
		*band_pos = ++ inc_band_pos;
		*offset = 0;
		return FALSE;
	}
	temp += strlen( item );
	sscanf( temp, "\\%i,%i,%i,%i", place, band_num, band_pos, offset );

	/* now check to see there isn't another dock item in the same place,
	   and if there is move this one to the next row, set tmp to
	   ensure it isn't NULL to start off with */
	tmp = GINT_TO_POINTER( 1 );
	while( tmp ) {
		for( tmp = list; tmp; tmp = tmp->next ) {
			gnome_dock_get_item_by_name( dock, (gchar*)tmp->data,
						     &p, &bn, &bp, &o );
			if(p == *place && bn == *band_num && bp == *band_pos) {
				/* clash */
				(*band_num) ++;
				g_warning( "Clash of dock items\n" );
				/* break out of the for loop so we check all
				   dock items again */
				break;
			}
		}
	}

	list = g_list_append( list, g_strdup( item ) );
	return TRUE;
}

/* Again this is a bit of a hack as GnomeApp doesn't support this,
   it would be nice if it did using a fifth number to flag show/hide in
   the layout string */
gboolean dock_popup( GtkWidget *widget, GdkEventButton *event )
{
	gchar *layout;
	gchar **temp;
	gint i;
	GnomeDock *dock;
	GnomeDockLayout *dlayout;

	GtkWidget *menu;
	GtkWidget *item;
	gint junk;

	if( event->button != 3 )
		return FALSE;


	if( gtk_object_get_data( GTK_OBJECT( hack_hack_hack ), 
				 "EEK_ANOTHER_HACK" ) ) {
		gtk_object_set_data( GTK_OBJECT( hack_hack_hack ), 
				     "EEK_ANOTHER_HACK", NULL );
		return FALSE;
	}


	/* we have a right click on the dock */
	gtk_signal_emit_stop_by_name( GTK_OBJECT( widget ),
				      "button_press_event" );

	/* get dock layout string */
	dock = gnome_app_get_dock( GNOME_APP( hack_hack_hack ) );
	dlayout = gnome_dock_get_layout( dock );

	layout = gnome_dock_layout_create_string( dlayout );

	temp = g_strsplit( layout, "\\", 256 );
	menu = gtk_menu_new();
	item = NULL;
	for( i = 0; temp[ i ]; i += 2 ) {
		item = gtk_check_menu_item_new_with_label( temp[ i ] );
		gtk_check_menu_item_set_show_toggle( GTK_CHECK_MENU_ITEM(item),
						     TRUE );
		widget = gnome_dock_get_item_by_name( dock, temp[ i ], 
						      &junk, &junk, &junk,
						      &junk );
		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM( item ),
						GTK_WIDGET_VISIBLE( widget ) );

		gtk_widget_show( item );
		gtk_signal_connect_full( GTK_OBJECT( item ), "toggled",
					 GTK_SIGNAL_FUNC( show_hide ),
					 NULL, g_strdup( temp[ i ] ),
					 g_free, 0, 0 );
		gtk_menu_append( GTK_MENU( menu ), item );
	}
	g_strfreev( temp );

	if( item )
		gnome_popup_menu_do_popup_modal( menu, 0, 0, event, 0 );

	gtk_widget_unref( menu );

	return TRUE;
}
