/*  Screem:  guile.c,
 *  
 *  handles the guile editing area for executing scripts
 *
 *  Copyright (C) 2000  David A Knight
 *
 *  TODO:
 *  stop building the parse tree on each keypress.  It should be built
 *  once and then modified with changes made to the document.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>

#include <glade/glade.h>

#include "editor_guile.h"
#include "site_guile.h"
#include "page_guile.h"
#include "guile.h"

#include "support.h"

extern GladeXML *main_interface_xml;

static GList *scripts = NULL;

static void 
screem_guile_script_exec( GtkWidget *item, ScreemGuileScript *script );

void screem_guile_load_script()
{
	gchar *filename;
	FILE *in;
	GtkWidget *editor;
	gchar buffer[ 2048 ];
	gint pos;
	
	filename = file_select( _("Select Guile script to load") );

	if( ! filename )
		return;

	editor = glade_xml_get_widget( main_interface_xml, "guile_editor" );

	gtk_editable_delete_text( GTK_EDITABLE( editor ), 0, -1 );

	in = fopen( filename, "r" );
	pos = 0;
	while( in && fgets( buffer, 2048, in ) )
		gtk_editable_insert_text( GTK_EDITABLE( editor ),
					  buffer, strlen( buffer ),
					  &pos );
	if( in )
		fclose( in );

	g_free( filename );
}

void screem_guile_execute_script()
{
	GtkWidget *editor;
	gchar *script;

	editor = glade_xml_get_widget( main_interface_xml, "guile_editor" );
	script = gtk_editable_get_chars( GTK_EDITABLE( editor ), 0, -1 );

#ifdef HAVE_GUILE
	gh_eval_str_with_standard_handler( script );
#endif
	g_free( script );
}

void screem_init_guile()
{
#ifdef HAVE_GUILE
	screem_site_init_guile();
	screem_editor_init_guile();
	screem_page_init_guile();

	gh_new_procedure( "screem-script-register",
			  (gpointer)scm_screem_script_register, 4, 0, 0 );
#endif
}

GtkWidget* screem_guile_get_menu()
{
	GtkWidget *menu;
	GtkWidget *item;
	GtkWidget *ret;
	GList *list;
	ScreemGuileScript *script;
	GtkWidget *parent;
	GtkWidget *temp;
	gchar **path;
	gint pos;

	ret = gtk_menu_item_new_with_label( _("Guile Scripts") );
	gtk_widget_show( ret );
	menu = gtk_menu_new();
	gtk_menu_item_set_submenu( GTK_MENU_ITEM( ret ), menu );

	for( list = scripts; list; list = list->next ) {
		script = (ScreemGuileScript*)list->data;

		item = gtk_menu_item_new_with_label( script->label );
		gtk_widget_show( item );

		path = g_strsplit( script->menupath, "/", 10 );
		parent = menu;
		for( pos = 0; path[ pos ]; path ++ ) {
			temp = gnome_app_find_menu_pos( parent, path[ pos ], &pos );
			if( ! temp ) {
			/* create it */
				temp = gtk_menu_item_new_with_label( path[ pos ] );
				gtk_widget_show( temp );
				gtk_menu_append( GTK_MENU( parent ), temp );
				parent = gtk_menu_new();
				gtk_menu_item_set_submenu( GTK_MENU_ITEM( temp ),
							   parent );
			} else
				parent = temp;
		}
		gtk_menu_append( GTK_MENU( parent ), item );
		gtk_signal_connect(GTK_OBJECT( item ), "activate",
				   GTK_SIGNAL_FUNC( screem_guile_script_exec ),
				   script );
	}

	return ret;
}

#ifdef HAVE_GUILE
SCM scm_screem_script_register( SCM a, SCM c, SCM l, SCM m )
{
	gint len;
	ScreemGuileScript *script;

	script = g_new0( ScreemGuileScript, 1 );
	script->author = gh_scm2newstr( a, &len );
	script->callback = gh_scm2newstr( c, &len );
	script->label = gh_scm2newstr( l, &len );
	script->menupath = gh_scm2newstr( m, &len );

	scripts = g_list_append( scripts, script );

	return SCM_EOL;
}
#endif

void screem_guile_script_load( gchar *path )
{
	struct stat s;

	if( stat( path, &s ) < 0 )
		return;

#ifdef HAVE_GUILE
	/* evaluate it */
	gh_eval_file_with_standard_handler( path );
	
	/* execute the register function */
	gh_eval_str_with_standard_handler( "(script-register)" );
#endif	
}

static void 
screem_guile_script_exec( GtkWidget *item, ScreemGuileScript *script )
{
	if( ! script )
		return;
#ifdef HAVE_GUILE
	gh_eval_str_with_standard_handler( script->callback );
#endif
}
