#include <config.h>

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h> 
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gmodule.h>
#include <gnome.h>

#include "site.h"
#include "page.h"
#include "editor.h"

extern GtkWidget *app;
extern Site *current_site;

#define MAXHOSTNAME 64

/* FIXME: should really allow the user to specify a mail server */
#define DEST_IP   "127.0.0.1"
#define DEST_PORT 25

static GtkWidget* createDialog();
static void clicked( GtkWidget *widget, gint button, GtkWidget **dialog );
static void delete( GtkWidget *widget, GdkEvent *event, GtkWidget **dialog );
void mailWizard();

/*********************************************************************/
G_MODULE_EXPORT const gchar*
g_module_check_init( GModule *module )
{
        g_print("mailWizard: check-init\n");
        return NULL;
}
/*********************************************************************/
G_MODULE_EXPORT void
g_module_unload( GModule *module )
{
        g_print( "mailWizard: unloaded\n" );
}
/*********************************************************************/
G_MODULE_EXPORT void 
init() 
{
	GtkWidget *button;
	GtkWidget *toolbar;

	button = gnome_stock_new_with_icon( GNOME_STOCK_PIXMAP_MAIL_SND );
	
	toolbar = gtk_object_get_data( GTK_OBJECT( app ), "wizardbar" );

        /* place a button on the wizards toolbar */
	gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), "",
                                 _("Mail Page"), "", button, mailWizard, 0 );

        g_print( "mailWizard: initialised\n" );
}
/*********************************************************************/
void mailWizard()
{
	static GtkWidget *dialog = NULL;
	Page *page;
	
	page = screem_site_get_current_page( current_site );
	
	g_return_if_fail( page != NULL );

	dialog = createDialog();

	gtk_signal_connect( GTK_OBJECT( dialog ), "clicked", clicked, &dialog);
	gtk_signal_connect( GTK_OBJECT( dialog ), "delete_event", delete,
			    &dialog );

	gtk_widget_show_all( dialog );
}
/*********************************************************************/
GtkWidget* createDialog()
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *table;
	GtkWidget *to;
	GtkWidget *cc;
	GtkWidget *bcc;
	GtkWidget *subject;
	GtkWidget *label;

	dialog = gnome_dialog_new( _("Mail Wizard"),
				    GNOME_STOCK_PIXMAP_MAIL_SND,
				    GNOME_STOCK_BUTTON_CLOSE,
				    NULL );
	dialog_vbox = GNOME_DIALOG( dialog )->vbox;
	
	table = gtk_table_new( 2, 5, FALSE );
	gtk_box_pack_start( GTK_BOX( dialog_vbox ), table, TRUE, TRUE, 0 );
	
	to = gnome_entry_new( NULL );
	gtk_object_set_data( GTK_OBJECT( dialog ), "to", to );
	gtk_table_attach( GTK_TABLE( table ), to, 1, 2, 0, 1,
			  GTK_EXPAND | GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	
	cc = gnome_entry_new( NULL );
	gtk_object_set_data( GTK_OBJECT( dialog ), "cc", cc );
	gtk_table_attach( GTK_TABLE( table ), cc, 1, 2, 1, 2,
			  GTK_EXPAND | GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	
	bcc = gnome_entry_new( NULL );
	gtk_object_set_data( GTK_OBJECT( dialog ), "bcc", bcc );
	gtk_table_attach( GTK_TABLE( table ), bcc, 1, 2, 2, 3,
			  GTK_EXPAND | GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	
	subject = gnome_entry_new( NULL );
	gtk_object_set_data( GTK_OBJECT( dialog ), "subject", subject );
	gtk_table_attach( GTK_TABLE( table ), subject, 1, 2, 3, 4,
			  GTK_EXPAND | GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	
	label = gtk_label_new( _("Subject:") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 3, 4,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );

	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );
	
	label = gtk_label_new( _("bcc:" ) );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 2, 3,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );

	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );
	
	label = gtk_label_new( _("cc:") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 1, 2,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );

	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );
	
	label = gtk_label_new( _("To:") );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 1, 0, 1,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );

	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
	gtk_misc_set_alignment( GTK_MISC( label ), 0, 0.5 );
	
	label = gtk_label_new( _("Info: HTML shouldn't really be used for email" ) );
	gtk_table_attach( GTK_TABLE( table ), label, 0, 2, 4, 5,
			  GTK_FILL, 0, GNOME_PAD, GNOME_PAD );
	
	return dialog;
}
/*********************************************************************/
static void clicked( GtkWidget *widget, gint button, GtkWidget **dialog )
{
	GtkWidget *to;
	GtkWidget *cc;
	GtkWidget *bcc;
	GtkWidget *subject;

	gchar *t;
	gchar *c;
	gchar *b;
	gchar *s;

	const gchar *xmailer = "SCREEM " VERSION " - Site Creating and Editing Environment\r\n";
	const gchar *xmailerorigin = "http://www.screem.org\r\n";
	const gchar *contentType = "text/html; charset=iso-8859-1\r\n";
	const gchar *contentTransferEncoding = "8bit\r\n";
	const gchar *QUIT = "QUIT\r\n";
	const gchar *DATA = "DATA\r\n";
	gchar *msgid;
	gchar *date;
	gchar *addr;
	gchar *from;
	gchar **RCPT;    /* to store the to line */
	gchar **RCPT2;   /* to store the cc line */
	gchar **RCPT3;   /* to store the bcc line */
	gchar *rcpt;
	gchar *FROM;
	gchar *HELO;
	gchar *body;
	gchar *data;  /* the constructed mail header and body */
   
	time_t ti = time( 0 );
	struct tm *tm = gmtime( &ti );
	gchar hname[ MAXHOSTNAME + 1 ];

	Page *p;
	int sd; /* socket descriptor */
	struct sockaddr_in dest; 
	const int destSize = sizeof( struct sockaddr );
	gint user;

	p = screem_site_get_current_page( current_site );
		
	if( ( button == 0 ) && p) { /* Send mail was clicked */
		body = screem_editor_get_text( 0, screem_editor_get_length() );
		to = gtk_object_get_data( GTK_OBJECT( widget ), "to" );
		cc = gtk_object_get_data( GTK_OBJECT( widget ), "cc" );
		bcc = gtk_object_get_data( GTK_OBJECT( widget ), "bcc" );
		subject = gtk_object_get_data(GTK_OBJECT( widget ), "subject");

		to = gnome_entry_gtk_entry( GNOME_ENTRY( to ) );
		cc = gnome_entry_gtk_entry( GNOME_ENTRY( cc ) );
		bcc = gnome_entry_gtk_entry( GNOME_ENTRY( bcc ) );
		subject = gnome_entry_gtk_entry( GNOME_ENTRY( subject ) );

		t = gtk_entry_get_text( GTK_ENTRY( to ) );
		c = gtk_entry_get_text( GTK_ENTRY( cc ) );
		b = gtk_entry_get_text( GTK_ENTRY( bcc ) );
		s = gtk_entry_get_text( GTK_ENTRY( subject ) );

		/* FIXME: add the time zone to the end of date */
		date = g_strconcat( "Date: ", ctime( &ti ), NULL );

		/* construct a message id line */
		gethostname( hname, MAXHOSTNAME );
		msgid = g_strdup_printf( "Message-ID: <%i%i%i%i%i-screem %s-@%s>\r\n", tm->tm_year + 1900, tm->tm_mon, tm->tm_mday, tm->tm_hour, tm->tm_min, VERSION, hname );

		addr = g_strconcat( " <", g_get_user_name(), "@", hname, ">",
				    NULL );
		from = g_strconcat( "From: \"", g_get_real_name(), "\"",
				    addr, NULL );
		/* set up the HELO string */
		HELO = g_strconcat( "HELO ", hname, "\r\n", NULL );
	      
		/* set up the FROM string */
		FROM = g_strconcat( "MAIL FROM:", addr, "\r\n", NULL );

		/* set up the RCPT strings */
		RCPT = g_strsplit( t, ",", 255 );
		RCPT2 = g_strsplit( c, ",", 255 );
		RCPT3 = g_strsplit( b, ",", 255 );

		if( strlen( t ) )
			t = g_strconcat( "To: ", t, "\r\n", NULL );
		else
			t = "";
		if( strlen( c ) )
			c = g_strconcat( "cc: ", c, "\r\n", NULL );
		else
			c = "";
	
		if( strlen( s ) )
			s = g_strconcat( "Subject: ", s, "\r\n", NULL );
		else
			s = g_strdup( "Subject: <no subject>\r\n" );

		/* FIXME: we don't attach the users .sig file to the
		   end of the mail yet */
		data = g_strconcat( from, "\r\n", date,
				    t, c, s, msgid,
				    "X-Mailer: ",xmailer,
				    "X-Mailerorigin: ", xmailerorigin,
				    "MIME-Version: 1.0\r\n",
				    "Content-Type: ", contentType,
				    "Content-Transfer-Encoding: ",
				    contentTransferEncoding, "\r\n", 
				    body, "\r\n.\r\n", NULL );

		/* connect to mail server */
		sd = socket( AF_INET, SOCK_STREAM, 0 );
		if( sd ) {
#warning "no error checking performed in mail transfer"
			memset( &dest, 0, sizeof( dest ) );
			dest.sin_family = AF_INET;
			dest.sin_port = htons( DEST_PORT );
			dest.sin_addr.s_addr = inet_addr( DEST_IP );
			connect( sd, (struct sockaddr *)&dest, destSize );
			/* send HELO */
			send( sd, HELO, strlen( HELO ), 0 );
			/* send FROM */
			send( sd, FROM, strlen( FROM ), 0 );
			/* send all RCPT's */
			for( user = 0; RCPT[ user ]; user ++ ) {
				rcpt = g_strconcat( "RCPT TO:<", RCPT[ user ],
						    ">\r\n", NULL );
				send( sd, rcpt, strlen( rcpt ), 0 );
				g_free( rcpt );
			}
			for( user = 0; RCPT2[ user ]; user ++ ) {
				rcpt = g_strconcat( "RCPT TO:<", RCPT2[ user ],
						    ">\r\n", NULL );
				send( sd, rcpt, strlen( rcpt ), 0 );
				g_free( rcpt );
			}
			for( user = 0; RCPT3[ user ]; user ++ ) {
				rcpt = g_strconcat( "RCPT TO:<", RCPT3[ user ],
						    ">\r\n", NULL );
				send( sd, rcpt, strlen( rcpt ), 0 );
				g_free( rcpt );
			}
			/* send DATA */
			send( sd, DATA, strlen( DATA ), 0 );
			/* send message body */
			send( sd, data, strlen( data ), 0 );
			/* send QUIT */
			send( sd, QUIT, strlen( QUIT ), 0 );
		
			{
				gchar buffer;
				while( recv( sd, &buffer, 1, 0 ) > 0 ) {
					printf( "%c", buffer );
				}
				printf( "\n" );
			}

			close( sd );
		}
		g_free( msgid );
		g_free( from );
		g_free( addr );
		g_free( FROM );
		g_free( data );
		g_free( HELO );
		g_free( body );
		g_strfreev( RCPT );
		g_strfreev( RCPT2 );
		g_strfreev( RCPT3 );
	}

	gtk_widget_destroy( widget );
	*dialog = NULL;
}
/*********************************************************************/
static void delete( GtkWidget *widget, GdkEvent *event, GtkWidget **dialog )
{
	*dialog = NULL;
}
