/*  Screem:  colourWizard.c,
 * A GTK colour selector dialog to insert colours
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gmodule.h>
#include <gnome.h>

#include "site.h"
#include "page.h"
#include "editor.h"

extern GtkWidget *app;
extern Site *current_site;

static GtkWidget* create_dialog( void );
void colourWizard();
static void closed( GtkWidget *widget, GdkEvent *event, gpointer data );
static void clicked( GtkWidget *widget, gint button, GtkColorSelection *cs );

/*********************************************************************/
G_MODULE_EXPORT const gchar*
g_module_check_init( GModule *module )
{
        g_print("colourWizard: check-init\n");
        return NULL;
}
/*********************************************************************/
G_MODULE_EXPORT void
g_module_unload( GModule *module )
{
        g_print( "colourWizard: unloaded\n" );
}
/*********************************************************************/
G_MODULE_EXPORT void 
init() 
{
	GtkWidget *toolbar;

        GtkWidget *button;
        GnomeUIInfo menuinfo[] = { 
                {
                        GNOME_APP_UI_ITEM, N_("Colour..."),
                        N_("Insert a colour"),
                        colourWizard, NULL, NULL,
                        GNOME_APP_PIXMAP_STOCK,
                        GNOME_STOCK_MENU_BLANK,
                        0,
                        GDK_CONTROL_MASK, NULL
                },
                GNOMEUIINFO_END
        };

    	toolbar = gtk_object_get_data( GTK_OBJECT( app ), "wizardbar" );

        /* place menu item after image under insert */
        gnome_app_insert_menus( GNOME_APP( app ),
                                _("_Insert/"), menuinfo);

        /* place a button on the wizards toolbar */
        button = gnome_stock_new_with_icon( GNOME_STOCK_PIXMAP_COLORSELECTOR );
        gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), "",
                                 _("Colour Browser"), "", button ,
                                 colourWizard, 0 );

        g_print( "colourWizard: initialised\n" );
}
/*********************************************************************/
void colourWizard()
{
	static GtkWidget *dialog = NULL;
	Page *page;

	page = screem_site_get_current_page( current_site );
	
	g_return_if_fail( page != NULL );
	
        if( dialog ) {
                gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
        }

	dialog = create_dialog();

	gtk_object_set_data( GTK_OBJECT( dialog ), "dialog", &dialog );

	gtk_widget_show_all( dialog );
}
/*********************************************************************/
static void closed( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	GtkWidget **dialog;

	dialog = gtk_object_get_data( GTK_OBJECT( widget ), "dialog" );
	*dialog = NULL;
}
/*********************************************************************/
static void clicked( GtkWidget *widget, gint button, GtkColorSelection *cs )
{
	GtkWidget **dialog;
	gint r, g, b;
	gchar *text;
	gint16 pos;

	gint start;
	gint len;

	
	dialog = gtk_object_get_data( GTK_OBJECT( widget ), "dialog" );

	if( button < 2 ) {
		r = (cs->values[ 3 ] * 255);
		g = (cs->values[ 4 ] * 255);
		b = (cs->values[ 5 ] * 255);

		if( screem_editor_has_selection( &start, &len ) )
			screem_editor_clear_selection();

		text = g_strdup_printf( "\"#%.2x%.2x%.2x\"", r, g, b );
		pos = screem_editor_get_pos();
		screem_editor_insert( pos, text );
		g_free( text );
	}

	if( button == 1 ) {
		pos = screem_editor_get_pos();
		screem_editor_select_region( pos, pos + 9 );
		return;
	}

	if( button == 2 ) {  /* cancel */
		if( screem_editor_has_selection( &start, &len ) )
			screem_editor_clear_selection();
	}
	*dialog = NULL;
	gtk_widget_destroy( widget );
}

/*********************************************************************/
static GtkWidget*
create_dialog ()
{
	GtkWidget *dialog;
	GtkWidget *colourSel;
	
	dialog = gnome_dialog_new (_("Insert a colour"),
				   GNOME_STOCK_BUTTON_OK,
				   GNOME_STOCK_BUTTON_APPLY,
				   GNOME_STOCK_BUTTON_CLOSE,
				   NULL );
	
	colourSel = gtk_color_selection_new();
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dialog )->vbox ), colourSel,
			    TRUE, TRUE, GNOME_PAD );

	gtk_signal_connect( GTK_OBJECT( dialog ), "clicked", clicked,
			    colourSel );
	gtk_signal_connect(GTK_OBJECT( dialog ), "delete_event", closed, NULL);

	gtk_window_set_wmclass(GTK_WINDOW( dialog ), "color_wizard", "Screem");

	return dialog;
}
