#ifndef SUPPORT_H
#define SUPPORT_H

#include <gdk/gdkx.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <glade/glade.h>

#include "site.h"

void change_state( GtkWidget *widget, gpointer data );
gchar* file_select( gchar *title );
gint execute_command( const gchar *command );
gchar* escape_path( gchar *pathname );

typedef struct Icons {
	const gchar *mime_type;
	gchar *filename;
	GdkPixbuf *pixbuf;
	GdkPixmap *open;
	GdkPixmap *open_mask;
} Icons;

Icons *icon_from_mime_type( const gchar *filename, const gchar *mime_type );

GdkFilterReturn grab_key_filter( GdkXEvent *gdk_xevent, GdkEvent *event,
				 gpointer data );
char * convert_keysym_state_to_string( guint keysym, guint state );
void key_list_grab_key( GtkWidget *widget );


GList* add_recent( GList *list, const gchar *entry );

GString *load_text_file_with_dir( const gchar *dir, const gchar *file );
GString* load_text_file( const gchar *path );
GString* load_text_file_from_stream( FILE *in );


void screem_set_upload_flags( Site *site, GladeXML *xml, gchar *path );

#define screem_show_error( m ) screem_do_show_error( m, TRUE );
#define screem_show_warning( m ) screem_do_show_error( m, FALSE );
void screem_do_show_error( gchar *m, gboolean fatal );
void screem_show_message( gchar *m );


#endif
