#ifndef SCREEM_PREFERENCES_H
#define SCREEM_PREFERENCES_H

#include <glib.h>
#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

typedef struct _ColourClass ColourClass;

typedef enum EntityInsertion {
	OFF    = 0,
	ON     = 1,
	BY_SET = 2
} EntityInsertion;

typedef enum PrintOrientation {
	PRINT_ORIENT_LANDSCAPE,
	PRINT_ORIENT_PORTRAIT 
} PrintOrientation;

typedef enum KeyAction {
	TEXT = 0,
	ADD_CLOSE = 1
} KeyAction;

/* defined in preferences.c */
extern gchar *key_actions[];

typedef struct KeyCombo {
	gchar *key_name;
       	gchar *text;
	KeyAction action;
} KeyCombo;

typedef struct MiscPage {
	gchar           *default_filename;
	gchar           *default_charset;
	gchar           *default_dtd;
	gchar           *font_name;
	gchar           *hide_string;
	gboolean         auto_load;
	gboolean         auto_open;
	gboolean         highlighting;
	gboolean         inline_tagging;
	gboolean         auto_indent;
	gboolean         intelliclose;
	gboolean         notebookbar;
	gboolean         viewbar;
	gboolean         parse;
	EntityInsertion  ent;
	GdkFont         *font;
} MiscPage;

typedef struct KeysPage {
	GList *keys;
} KeysPage;

typedef struct ColourGroup {
	gchar   *name;
	GList   *patterns;
	gchar   *end;           /* all items in the group end with the
				   same pattern */
	gchar   *all_patterns;
	guint16  fore[ 5 ];     /* use, red, green, blue, alpha */
	guint16  back[ 5 ];     /* use, red, green, blue, alpha */
	guint16  bakfore[ 5 ];  /* use, red, green, blue, alpha */
	guint16  bakback[ 5 ];  /* use, red, green, blue, alpha */

	GdkColor fg;
	GdkColor bg;

	ColourClass *parent;
} ColourGroup;

struct _ColourClass {
	GList       *types;
    	ColourGroup *current;
	GList       *groups;   /* a list ColourGroups */
	GList       *context_groups;
	GList       *menus;    /* FIXME: the struct name should be changed 
				  as menus are nothing to do with colour */
	GList       *keys;     /* a list of callback names to process key
				  presses with */
	GList       *tips;     /* a list of callback names for editor
				  tooltips */
};

typedef struct ColourPage {
	guint16  back[ 3 ];
	guint16  fore[ 3 ];
	
	GList       *colour_classes;
} ColourPage;

typedef struct HelperPage {
	GList *helpers;
} HelperPage;

typedef struct PrintPage {
	gint  printwrap;
	gint  printlines;
	gint  printheader;
	gchar *papersize;
	guint  orientation;
} PrintPage;

typedef struct JavaPage {
	gchar *compiler;
} JavaPage;

typedef struct Preferences {
	GtkWidget  *box;     /* the prefs dialog */

	gint    tag_width;     /* width of the html tag tree */
	gint    tag_height;    /* height of html tag tree */
        gint    file_width;    /* width of the file tree */
	gint    file_height;   /* the height of the file tree */
	gint    editor_width, editor_height;
	gint    preview_width,preview_height;
	gint    messages_height;
	xmlDocPtr tag_tree;
	gint hints;     /* show hints on startup? */
	gint last_hint; /* the last hint we displayed */
	GList *recent_sites, *recent_pages;

	gchar *dock_string;  /* the dock item layout data */
	gchar *glade_path;   /* path to the glade xml file to use */

	MiscPage   *mpage;   /* the misc page of the preferences notebook */
	KeysPage   *kpage;   /* the keys page of the preferences notebook */
	ColourPage *cpage;   /* the colour page of the preferences notebook */
	HelperPage *hpage;   /* the helper page of the preferences notebook */
	PrintPage  *ppage;   /* the print page of the preferences notebook */
	JavaPage   *jpage;   /* the java page of the preferences notebook */
} Preferences;

typedef void (*Tabfn)();



void preferences_changed( void );
void preferences_apply( void );
void preferences_done( void );

void font_changed( GtkWidget *widget );

void tag_colour_sel( GtkEntry *widget );
void tag_use_change( GtkWidget *widget );
void tag_col_change( GnomeColorPicker *cp, guint r, guint g, guint b,
		     guint a );

void key_list_select( GtkCList *list, gint row, gint column, GdkEvent *event );
void key_list_unselect(GtkCList *list, gint row, gint column, GdkEvent *event);
void key_list_add_key( void );
void key_list_remove_key( void );
void key_list_update_key( void );

void helper_clicked( GtkCList *list, gint row, gint column,
		     GdkEventButton *event );
void helper_add( GtkWidget *button, gpointer data );
void helper_update( GtkWidget *button, gpointer data );
void helper_remove( GtkWidget *button, gpointer data );


void preferences_new( void );
void load_open( void );
void load_preferences( void );
void save_preferences( void );
void edit_preferences( void );

void preferences_clicked( GtkWidget *widget, gint button );
void preferences_page_selected( GtkWidget *list, gint row, gint col );

ColourClass* colour_class_from_type( const gchar *type );

void save_open( GList *sites );


#endif
