#ifndef SCREEM_PAGE_H
#define SCREEM_PAGE_H

#include <glib.h>
#include <time.h>

typedef gpointer Page;

typedef struct Undo {
	gboolean insert; /* was it an insert? if false then it was remove */
	gchar *text;     /* the text */
	gint pos;        /* the position of the action */
} Undo;

Page *screem_page_new( void );
void screem_page_destroy( Page *page );

void screem_page_set_pathname( Page *page, const gchar *path );
const gchar *screem_page_get_pathname( Page *page );
const gchar *screem_page_get_mime_type( Page *page );


void screem_page_set_tab( Page *page, gint num );
gint screem_page_get_tab( Page *page );

void screem_page_set_charset( Page *page, const gchar *charset );
const gchar *screem_page_get_charset( Page *page );

void screem_page_set_data( Page *page, const gchar *data );
const gchar *screem_page_get_data( Page *page );

void screem_page_set_changed( Page *page, gboolean flag );
gboolean screem_page_get_changed( Page *page );


Page *screem_page_from_tab_num( GList *list, gint num );
void screem_page_update_tab_nums( GList *list, gint num );

gboolean screem_page_read( Page *page, int fd );
gboolean screem_page_load( Page *page );
gboolean screem_page_revert( Page *page );
gboolean screem_page_save( Page *page );

gboolean screem_page_is_file_page( const gchar *path );
gboolean screem_page_is_mime_type_page( const gchar *mime_type );

void screem_page_set_mod_time( Page *page, time_t t );
time_t screem_page_get_mod_time( Page *page );

Undo* screem_page_get_undo_last_action( Page *page, gboolean remove );
void screem_page_set_undo_last_action( Page *page, gboolean insert, gint pos, 
				       const gchar *text );
void screem_page_add_undo_action( Page *page, Undo *undo );
void screem_page_clear_undo_list( Page *page );
Undo* screem_page_get_redo_last_action( Page *page, gboolean remove );
void screem_page_set_redo_last_action( Page *page, Undo *undo );
void screem_page_clear_redo_list( Page *page );

void screem_page_chdir( Page *page );

#endif
