#ifndef HTMLFUNCS_H
#define HTMLFUNCS_H

#include <glib.h>
#include "dtd.h"

typedef struct Node {
	gchar *name;       /* NULL if its just text */
	CloseState state;
	gchar *content;    /* the node content */
	GList *attributes; /* NULL if its just text */
	gint pos;          /* opened position */
	gint cpos;         /* closed position */
} Node;

gint in_attribute( const gchar *text, gint pos );
gint in_entity( const gchar *text, gint pos );
gint in_tag( const gchar *text, gint pos );
gchar *next_tag( const gchar *text, gint *pos, gchar **name );
gchar *previous_tag( const gchar *text, gint *pos );
gint binary_search_tags( const gchar *t );
gchar *tag_name( const gchar *tag );

GNode* screem_html_parse_tree_find_pos( GNode *node, gint pos, gboolean allow_text );
GNode* screem_html_parse_tree_find_node( GNode *current, const gchar *name );
gchar* screem_html_autoclose( const gchar *text, gint pos );

#define tag_is_close_tag( tag )  (tag[ 1 ] == '/')
#define tag_is_open_tag( tag ) ! tag_is_close_tag( tag );

GList* screem_html_attribute_from_list( GList *attributes, const gchar *name );
GList* screem_html_build_attributes_list( const gchar *tag, GList *list );

void screem_tags_change_case( gchar *text, gboolean upper );

GList *screem_html_get_links( const gchar *text );

gboolean screem_html_close_tag( const gchar *tag, const gchar *next );

void screem_html_parse_uri( const gchar *uri, 
			    gchar **protocol,
			    gchar **address,
			    gchar **port,
			    gchar **path );

GNode *screem_html_build_parse_tree( ScreemDTD *dtd, const gchar *text, 
					gint pos );
void screem_html_destroy_parse_tree( GNode *node );

gchar* screem_html_key_to_ent( guint keyval );

gchar *screem_html_fix_links( const gchar *text, const gchar *path,
				const gchar *spath,
				const gchar *src, const gchar *dest );

gchar* screem_html_encode_text( const gchar *text );
gboolean screem_html_next_tag_close( const gchar *text, gchar *tname, gint pos );

#endif
