#ifndef SCREEM_PAGE_MODEL_H
#define SCREEM_PAGE_MODEL_H

#include <gtk/gtktreestore.h>
#include <libxml/tree.h>

#include "screem-page.h"

#define SCREEM_TYPE_PAGE_MODEL            (screem_page_model_get_type ())
#define SCREEM_PAGE_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_PAGE_MODEL, ScreemPageModel))
#define SCREEM_PAGE_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_PAGE_MODEL, ScreemPageModelClass))
#define SCREEM_IS_PAGE_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_PAGE_MODEL))

typedef struct ScreemPageModelPrivate ScreemPageModelPrivate;

typedef struct  {
	GtkTreeStore parent;

	ScreemPageModelPrivate *priv;
} ScreemPageModel;

typedef struct {
        GtkTreeStoreClass parent_class;

} ScreemPageModelClass;

ScreemPageModel *screem_page_model_new( ScreemPage *page, GObject *app );
void screem_page_model_force_check( ScreemPageModel *model,
		gboolean in_progress );

void screem_page_model_build_model( ScreemPageModel *model );
void screem_page_model_ensure_built( ScreemPageModel *model );
gboolean screem_page_model_select_context( ScreemPageModel *model,
					  guint pos,
					  guint *start, guint *end,
					  gboolean select_text );
gboolean screem_page_model_select_parent_context( ScreemPageModel *model,
		guint pos,
		guint *start, guint *end,
		gboolean select_text );
gboolean screem_page_model_select_content( ScreemPageModel *model,
					  guint pos,
					  guint *start, guint *end,
					  gboolean select_text );
gchar *screem_page_model_query_context( ScreemPageModel *model,
		guint pos, gboolean query_text,
		gboolean build, 
		guint *depth, guint *start, guint *end,
		xmlNodePtr *node );

void screem_page_model_emit_building( ScreemPage *page );
void screem_page_model_emit_built( ScreemPage *page );

gboolean screem_page_model_is_default_charset( ScreemPageModel *model );

GType screem_page_model_get_type( void );

#endif
