/***************************************************************************
                          smspdu.c  -  description
                             -------------------
    begin                : Fri Aug 3 2001
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//help on SMS PDU encoding can be found at
//http://www.dreamfabric.com/sms/ (english) or
//http://www.nobbi.com/sms_pdu.htm (german)
//the Siemens manuals are no help at all (when it comes to the UD) :-(

#include "common.h"


#define ReplyPath		128 // reply path is set
#define UDHI				 64 //user data includes headers
#define SR					 32	//status report request/indication
#define VP_REL			 16	//validity period is relative (SMS-SUBMIT)
#define VP_ABS			 24	//validity period is absolute (SMS-SUBMIT)
#define RD					  4	//read Siemens documentation for this! (SMS-SUBMIT)
#define MMS					  4	//"more messages to send" indication (SMS_DELIVER)
#define SMS_COMMAND		2	//this SMS is an SMS-COMMAND
#define SMS_SUBMIT		1	//this SMS is an SMS-SUBMIT
#define SMS_DELIVER 	0 //this SMS is an SMS-DELIVER

struct number_sms_pdu {
	unsigned int length;
	unsigned int type;
	unsigned char number[17];
};

void create_smssubmit_pdu(char *pdu, char* smstext, char* smsnumber, int flash){	
	struct number_sms_pdu sca; //SMSC
	unsigned int pdutype; //8bits, convert to hex-string, use defined values!
	unsigned int mr=0; //message reference, 0-255, convert to hex-string
	struct number_sms_pdu da; //destination
	unsigned int pid=0; //protocol identifier, normally 0, convert to hex-string
	unsigned int dcs=0; //data coding scheme,DO NOT CHANGE!!!, convert to hex-string
	unsigned int vp_relative=255; //validity period (0-255, set to max=63 weeks), convert to hex-string
	unsigned char vp_absolute[15]; //validity period (YYMMDDhhmmss(TZ))
	unsigned int udl; //user data length, convert to hex-string
	unsigned char ud[281]; //use iso2gsm to create and then exchange odd and even digits
		
	char buffer,temp[17];
	int i;
	
	memset(sca.number,0,sizeof(sca.number));
	memset(da.number,0,sizeof(da.number));
	memset(vp_absolute,0,sizeof(vp_absolute));
	memset(ud,0,sizeof(ud));
	memset(temp,0,sizeof(temp));
	
	//set SMSC length to 0 to let the phone fill it in
	sca.length=0;
	//we do not have to set the rest of sca
	
	//set PDU type to standards (if you change it, make sure you know what you are doing!!!)
	//those are bits!
	pdutype = (SMS_SUBMIT | VP_REL);
	//leave message reference as is
	
	//process destination
	if (!strlen(smsnumber)){
		errexit("Error: no SMS number specified.\n");
	}
	strcpy(da.number,smsnumber);
	//check the numver
	if (!is_pnumber(smsnumber,1)) {
	    errexit("Hey, no poking around with bogus SMS numbers, please.\n");
	}
/*
	for(i=0;i<(strlen(SMSNR));i++){
		buffer=SMSNR[i];
		if (!((buffer=='+' && i==0) || ('0'<=buffer && buffer <='9'))){
		}
	}
*/
	buffer=smsnumber[0];
	if(buffer=='+'){
		da.type=145;
		da.length=strlen(da.number)-1;
		if ((strlen(da.number)%2)==0) {
		    sprintf(&da.number[strlen(da.number)],"F");
		}
		for(i=1;i<(strlen(da.number)-1);i=i+2){
			sprintf(&temp[strlen(temp)],"%c%c",da.number[i+1],da.number[i]);
		}		
	}else{
		da.type=129;
		da.length=strlen(da.number);
		if ((strlen(da.number)%2)==1) {
		    sprintf(&da.number[strlen(da.number)],"F");
		}
		for(i=0;i<(strlen(da.number)-1);i=i+2){
			sprintf(&temp[strlen(temp)],"%c%c",da.number[i+1],da.number[i]);
		}		
	}
	strcpy(da.number,temp);
	
	//differ between normal and flash-sms
	if (flash) {
	    dcs=240;    
	}
	//leave PID and vp_relative as is
	
	//process user data length and user data
	strcpy(ud,smstext);
	//convert to GSM charset
	udl=iso2gsm_sms(ud);
	
	//create PDU
	memset(pdu,0,sizeof(pdu));
	sprintf(&pdu[strlen(pdu)],"%02X",sca.length);
	sprintf(&pdu[strlen(pdu)],"%02X",pdutype);
	sprintf(&pdu[strlen(pdu)],"%02X",mr);	
	sprintf(&pdu[strlen(pdu)],"%02X%02X%s",da.length,da.type,da.number);
	sprintf(&pdu[strlen(pdu)],"%02X",pid);
	sprintf(&pdu[strlen(pdu)],"%02X",dcs);
	sprintf(&pdu[strlen(pdu)],"%02X",vp_relative);
	sprintf(&pdu[strlen(pdu)],"%02X%s",udl,ud);
}

void decode_smsdeliver_pdu(unsigned char* pdu, int status){
//this is much more complicated because we have to handle ALL sms types!!!
//right now, this only includes type SMS-DELIVER, SMS_SUBMIT
	struct number_sms_pdu sca; //SMSC
	unsigned int pdutype;
	struct number_sms_pdu oa;
	unsigned int pid=0;
	unsigned int dcs=0;
	unsigned char scts[30];
	unsigned int udl;
	unsigned char ud[281];
	unsigned int udh_length=0;
	unsigned char udh[BUFSIZ];
	
	unsigned char temp[281];
	unsigned char result[BUFSIZ];
	int i, where=0;
	
	memset(temp,0,sizeof(temp));
	memset(result,0,sizeof(result));
	memset(sca.number,0,sizeof(sca.number));
	memset(oa.number,0,sizeof(oa.number));
	memset(scts,0,sizeof(scts));
	memset(ud,0,sizeof(ud));
	memset(udh,0,sizeof(udh));
	
	//extracting SMSC	
	sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
	sca.length=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	if (sca.length){
		sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
		sca.type=hexstr2int(temp);
		memset(temp,0,sizeof(temp));
		if ((sca.type&112)==16){sprintf(sca.number,"+");}
		where+=sca.length*2;
		for (i=4;i<where;i+=2) {
		    sprintf(&sca.number[strlen(sca.number)],"%c%c",pdu[i+1],pdu[i]);
		}
		if (!strcmp(&sca.number[strlen(sca.number)-1],"F")) {
		    memset(&sca.number[strlen(sca.number)-1],0,1);
		}
	}
	
	//checking all type bits
	sprintf(temp,"%c%c",pdu[where], pdu[where+1]);
	pdutype=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	
	//checking if PDUtype is supported and can thus be decoded
	if (status==0 || status==1) {
	    if ((pdutype&3)!=0) {
		sprintf(result,"\nSorry, unsupported PDU type %d.%d\n", status, pdutype&3);
		memset(pdu,0,sizeof(pdu));
		sprintf(pdu,"%s",result);
		return;
	    }
	} else if (status==2 || status==3) {
	    if ((pdutype&3)!=1) {
		 sprintf(result,"\nSorry, unsupported PDU type %d.%d\n", status, pdutype&3);
		memset(pdu,0,sizeof(pdu));
		sprintf(pdu,"%s",result);
		return;
	    }	
	} else {
	    sprintf(result,"\nunknown sms status %d\n", status);
	    memset(pdu,0,sizeof(pdu));
	    sprintf(pdu,"%s",result);
	    return;
	}
	
	if((pdutype&3)==SMS_SUBMIT){ //SMS_SUBMIT has MR field
		where+=2;
	}
	
	//originator address (OA)
	sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
	oa.length=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
	oa.type=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	if (oa.length){
		if ((oa.type&112)==80){
			for(i=where;i<where+oa.length;i+=2){
				sprintf(&oa.number[strlen(oa.number)],"%c%c",pdu[i],pdu[i+1]);
			}
			gsm2iso_sms((oa.length*4/7),oa.number);
			where+=oa.length;
		}else{
			if ((oa.type&112)==16) {
			    sprintf(oa.number,"+");
			}
			for (i=where;i<where+oa.length;i+=2) {
				sprintf(&oa.number[strlen(oa.number)],"%c%c",pdu[i+1],pdu[i]);
			}
			where+=oa.length;
			if (!strcmp(&oa.number[strlen(oa.number)-1],"F")) {
			    memset(&oa.number[strlen(oa.number)-1],0,1);
			}
			if (oa.length%2) {
			    where++;
			}
		}
	}
	
	//we do not need PID information
	sprintf(temp,"%c%c",pdu[where], pdu[where+1]);
	pid=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	
	//DCS information is critical for decoding!!!
	sprintf(temp,"%c%c",pdu[where], pdu[where+1]);
	dcs=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	
	if((pdutype&3)==SMS_SUBMIT && (pdutype&24)==0){ //VP not present
		where+=0;
	}else if((pdutype&3)==SMS_SUBMIT && (pdutype&24)==VP_REL){ //VP relative
		sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
		sprintf(scts,"%d",hexstr2int(temp));
		memset(temp,0,sizeof(temp));
		where+=2;		
	}else{ //VP absolute
		//service center time stamp (valuable information)
		sprintf(scts,"20%c%c-%c%c-%c%c %c%c:%c%c:%c%c",pdu[where+1],pdu[where]
						,pdu[where+3],pdu[where+2],pdu[where+5],pdu[where+4]
						,pdu[where+7],pdu[where+6],pdu[where+9],pdu[where+8]
						,pdu[where+11],pdu[where+10]);
		sprintf(temp,"%c%c",pdu[where+13],pdu[where+12]);
		//timzone handling
		if(((atoi(temp)%80)/4)<=12){
			sprintf(&scts[strlen(scts)]," (GMT");
			if(atoi(temp)>=80){sprintf(&scts[strlen(scts)],"-");}
			else{sprintf(&scts[strlen(scts)],"+");}
			sprintf(&scts[strlen(scts)],"%d)",(atoi(temp)%80)/4);
		}
		memset(temp,0,sizeof(temp));
		where+=14;
	}	

	//user data length, this is hex
	sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
	udl=hexstr2int(temp);
	memset(temp,0,sizeof(temp));
	where+=2;
	
	//user data
	if(udl){
	    if ((pdutype&64)==64){
		sprintf(temp,"%c%c",pdu[where],pdu[where+1]);
		udh_length=hexstr2int(temp);
		memset(temp,0,sizeof(temp));
		//for(i=2;i<(udh_length*2)+2;i+=2){sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where+i],pdu[where+i+1]);}
		for(i=2;i<(udh_length*2)+2;i+=2){sprintf(&udh[strlen(udh)],"%c%c",pdu[where+i],pdu[where+i+1]);}
		//where+=;
	        //udh +udhl drinlassen, dekodieren und dann (udh_length+(udh_length*8)%7)/7 von vorne abschneiden
	    }
	    //all encodings of uncompressed 7bit
	    if((dcs&204)==0 ||(dcs&244)==240 || (dcs&224)==192){
	        sprintf(ud,"%s",&pdu[where]);
	        gsm2iso_sms(udl,ud);
		if ((pdutype&64)==64){
		    sprintf(temp,"%s",ud);
		    sprintf(ud,"%s",&temp[1+((udh_length*8)+(udh_length*8)%7)/7]);
		}
	    }
//* How can we sanely process those messages?
		//all encodings of uncompressed 16bit unicode
		else if((dcs&204)==8 ||(dcs&224)==224){
		    sprintf(ud,"%s",&pdu[where+2+udh_length*2]);
		    //unicode_sms(udl,ud);
		}
		//all encodings of 8bit data
		else if((dcs&204)==4 ||(dcs&244)==244){
		    sprintf(ud,"%s",&pdu[where+2+udh_length*2]);
		    //eightbit_sms(udl,ud);
		    //sprintf(PDU_8BIT,"%s\n",ud);
		}
//*/
	}
	if((pdutype&3)==SMS_SUBMIT){sprintf(&result[strlen(result)],"To: %s\n",oa.number);}
	else{sprintf(&result[strlen(result)],"From: %s\n",oa.number);}
	if((pdutype&3)==SMS_SUBMIT && (pdutype&24)==0){//VP not present
		sprintf(&result[strlen(result)],"Date: N/A");
	}else if((pdutype&3)==SMS_SUBMIT && (pdutype&24)==VP_REL){ //VP relative
		if(0<=atoi(scts) && atoi(scts)<=143){sprintf(temp,"%d minute(s)",atoi(scts)*5);}
		else if(144<=atoi(scts) && atoi(scts)<=167){sprintf(temp,"%d minute(s)",(12*60)+((atoi(scts)-143)*30));}
		else if(168<=atoi(scts) && atoi(scts)<=196){sprintf(temp,"%d day(s)",atoi(scts)-166);}
		else if(197<=atoi(scts) && atoi(scts)<=255){sprintf(temp,"%d week(s)",atoi(scts)-192);}
		sprintf(&result[strlen(result)],"Valid for: %s\n",temp);
	}else{ //VP absolute
		if((pdutype&3)==1){sprintf(&result[strlen(result)],"Valid until: %s\n",scts);}
		else{sprintf(&result[strlen(result)],"Date: %s\n",scts);}
	}
	if (sca.length){sprintf(&result[strlen(result)],"SMSC number: %s\n",sca.number);}
	else{sprintf(&result[strlen(result)],"SMSC number: N/A\n");}
	sprintf(&result[strlen(result)],"PDU type: ");
		if((pdutype&3)==0){sprintf(&result[strlen(result)],"SMS-DELIVER ");}
		else if((pdutype&3)==1){sprintf(&result[strlen(result)],"SMS-SUBMIT ");}
		else sprintf(&result[strlen(result)],"%d ",pdutype);
		if((pdutype&128)==128){sprintf(&result[strlen(result)],"ReplyPath ");}
		if((pdutype&64)==64){sprintf(&result[strlen(result)],"UDHI ");}
		if((pdutype&35)==32){sprintf(&result[strlen(result)],"SRI ");}
		if((pdutype&35)==33){sprintf(&result[strlen(result)],"SRR ");}
		if((pdutype&7)==4){sprintf(&result[strlen(result)],"MMS ");}
		if((pdutype&7)==5){sprintf(&result[strlen(result)],"RejectDuplicate ");}	
	sprintf(&result[strlen(result)],"\nData Coding Scheme: ");
		if((dcs&192)==0){
			if (dcs&32){sprintf(&result[strlen(result)],"compressed ");}
			if ((dcs&12)==0){sprintf(&result[strlen(result)],"7bit-GSM ");}
			else if ((dcs&12)==4){sprintf(&result[strlen(result)],"8bit ");}
			else if ((dcs&12)==8){sprintf(&result[strlen(result)],"16bit-UCS2 ");}
			if (dcs&16){sprintf(&result[strlen(result)],"(Class %d)",dcs&3);}
		}else if((dcs&192)==192){
			if((dcs&48)==48){
				if ((dcs&12)==0){sprintf(&result[strlen(result)],"7bit-GSM ");}
				else if ((dcs&12)==4){sprintf(&result[strlen(result)],"8bit ");}
				if (dcs&16){sprintf(&result[strlen(result)],"(Class %d)",dcs&3);}				
			}else{
				if((dcs&48)==0){sprintf(&result[strlen(result)],"discarded 7bit-GSM, ");}
				else if((dcs&48)==16){sprintf(&result[strlen(result)],"stored 7bit-GSM, ");}
				else if((dcs&48)==32){sprintf(&result[strlen(result)],"stored 16bit-UCS2, ");}
				if((dcs&8)==0){sprintf(&result[strlen(result)],"inactive ");}
				else if((dcs&8)==8){sprintf(&result[strlen(result)],"active ");}
				if((dcs&3)==0){sprintf(&result[strlen(result)],"voicemail message waiting ");}
				else if((dcs&3)==1){sprintf(&result[strlen(result)],"fax message waiting ");}
				else if((dcs&3)==2){sprintf(&result[strlen(result)],"e-mail message waiting ");}
				else if((dcs&3)==3){sprintf(&result[strlen(result)],"??? message waiting ");}
			}
		}else {sprintf(&result[strlen(result)],"unknown (%d)",dcs);}
		sprintf(&result[strlen(result)],"\n");
	sprintf(&result[strlen(result)],"Message length: %d\n",udl);
	if (udh_length){
		//sprintf(&result[strlen(result)],"Message Header: %s\n",udh);
		sprintf(&result[strlen(result)],"Message Header:\n");
		where=0;
		do{
			sprintf(temp,"%c%c",udh[where],udh[where+1]);
			where+=2;
			switch(hexstr2int(temp)){
				case 0: //multipart message (8bit sequence)
					sprintf(&result[strlen(result)],"\tMultipart message: ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)==3) {
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    where+=2;
					    sprintf(&result[strlen(result)],"sequence number=%d",hexstr2int(temp));
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where+2],udh[where+3]);
					    sprintf(&result[strlen(result)],", part %d",hexstr2int(temp));
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    where+=4;
					    sprintf(&result[strlen(result)]," of %d",hexstr2int(temp));
					} else {
					    sprintf(&result[strlen(result)],"...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				case 1: //special sms indication
					sprintf(&result[strlen(result)],"\tIndications: ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)==2) {
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    where+=2;
					    if ((hexstr2int(temp)&128)==128) {
						sprintf(&result[strlen(result)],"store");
					    } else {
						sprintf(&result[strlen(result)],"discard");
					    }
					    switch (hexstr2int(temp)&127) {
						case 0: //voice
							sprintf(&result[strlen(result)],", voicemail message waiting");
							break;
						case 1: //fax
							sprintf(&result[strlen(result)],", fax message waiting");
							break;
						case 2: //electronic mail
							sprintf(&result[strlen(result)],", e-mail message waiting");
							break;
						case 3: //specified as "other"
						default:
							sprintf(&result[strlen(result)],", ??? message waiting");
							break;
					    }					    
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    where+=2;
					    sprintf(&result[strlen(result)],", message count=%d",hexstr2int(temp));
					} else {
					    sprintf(&result[strlen(result)],"...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				case 4: //application port addressing 16bit address
					sprintf(&result[strlen(result)],"\tApplication port: ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)==2) {
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    sprintf(&result[strlen(result)],"destination port=%d",hexstr2int(temp));
					    where+=2;
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    sprintf(&result[strlen(result)],", originator port: %d",hexstr2int(temp));
					    where+=2;
					    break;
					} else {
					    sprintf(&result[strlen(result)],"...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				case 5: //application port addressing 16bit address
					sprintf(&result[strlen(result)],"\tApplication port: ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)==4) {
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c%c%c",udh[where],udh[where+1],udh[where+2],udh[where+3]);
					    sprintf(&result[strlen(result)],"destination port=%d",hexstr2int(temp));
					    where+=4;
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c%c%c",udh[where],udh[where+1],udh[where+2],udh[where+3]);
					    sprintf(&result[strlen(result)],", originator port: %d",hexstr2int(temp));
					    where+=4;
					    break;
					} else {
					    sprintf(&result[strlen(result)],"...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				case 7: //UDH source indicator
					sprintf(&result[strlen(result)],"\tThe following headers were created by the ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)==1) {
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    where+=2;
					    switch (hexstr2int(temp)){
						case 0:
							sprintf(&result[strlen(result)],"sending unit");
							break;
						case 1:
							sprintf(&result[strlen(result)],"receiving unit");
							break;
						case 2:
							sprintf(&result[strlen(result)],"SMSC");
							break;
						default:
							sprintf(&result[strlen(result)],"...Error: unknown value %d",hexstr2int(temp));
							break;
					    }
					} else {
					    sprintf(&result[strlen(result)]," ...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				case 8: //multipart message (16bit sequence)
					sprintf(&result[strlen(result)],"\tMultipart message: ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)==4) {
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c%c%c",udh[where],udh[where+1],udh[where+2],udh[where+3]);
					    where+=2;
					    sprintf(&result[strlen(result)],"sequence number=%d",hexstr2int(temp));
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where+2],udh[where+3]);
					    sprintf(&result[strlen(result)],", part %d",hexstr2int(temp));
					    memset(temp,0,sizeof(temp));
					    sprintf(temp,"%c%c",udh[where],udh[where+1]);
					    where+=4;
					    sprintf(&result[strlen(result)]," of %d",hexstr2int(temp));
					} else {
					    sprintf(&result[strlen(result)],"...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				case 9: // wireless control message protocol
					sprintf(&result[strlen(result)],"\tWCMP data unit: ");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					for (i=0;i<(hexstr2int(temp)*2);i+=2) {
					    sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
					    where+=2;
					}
					break;
				case 0x70:
				case 0x71:
				case 0x72:
				case 0x73:
				case 0x74:
				case 0x75:
				case 0x76:
				case 0x77:
				case 0x78:
				case 0x79:
				case 0x7a:
				case 0x7b:
				case 0x7c:
				case 0x7d:
				case 0x7e:
				case 0x7f: // SIM toolkit security header
					sprintf(&result[strlen(result)],"\tSIM toolkit security header");
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					if (hexstr2int(temp)!=0) {
					    sprintf(&result[strlen(result)]," ...Error: incorrect length (%d), ",hexstr2int(temp));
					    for (i=0;i<(hexstr2int(temp)*2);i+=2) {
						sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
						where+=2;
					    }
					}
					break;
				default: //unknown header type
					sprintf(&result[strlen(result)],"\tUnknown type (%02X): ",hexstr2int(temp));
					memset(temp,0,sizeof(temp));
					sprintf(temp,"%c%c",udh[where],udh[where+1]);
					where+=2;
					for (i=0;i<(hexstr2int(temp)*2);i+=2) {
					    sprintf(&udh[strlen(udh)],"0x%c%c ",pdu[where],pdu[where+1]);
					    where+=2;
					}
					break;
			}
		sprintf(&result[strlen(result)],"\n");
		}while(where<strlen(udh));
	}
	if(udl && ((dcs&204)==0 ||(dcs&244)==240 || (dcs&224)==192)){
		sprintf(&result[strlen(result)],"Message:\n%s\n",ud);
	} else {
		sprintf(&result[strlen(result)],"Message (as hexstring):\n%s\n",ud);
	}
	
	memset(pdu,0,sizeof(pdu));
	sprintf(pdu,"%s",result);
}
