/***************************************************************************
                          smcxx.c  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"

int main (int argc, char** argv) {
    char empty[] = ""; // to be used at init with all char pointers
    struct datapair mydata;
    char* myFILE;
    char* myPIPE;
    char* PBOOK;

    char* myttyport;
    speed_t myttyspeed;
    char SETTINGS=0;
    int SLOT=0;
    int flashsms=0;
        
    char at_command[128],
         ausgabe[BUFSIZ],
         ack[BUFSIZ];
    int option_index,
	arg,
	RUN_INFO=0,
	RUN_SETTIME=0,
	RUN_SETSMSC=0,
	RUN_HELP=0,
	RUN_VERSION=0,
	RESET=0;
    struct option myoptions[]={
	{"remove",0,0,'r'},{"send",0,0,'s'},{"get",0,0,'g'},
	{"bitmap",2,0,'B'},{"midi",2,0,'M'},{"vcal",2,0,'C'},{"vcard",1,0,'F'},
	{"pbook",1,0,'P'},{"sms",2,0,'S'},
	{"text",1,0,'t'},{"number",1,0,'n'},{"direct",0,0,0},{"flash",0,0,0},
	{"device",1,0,'d'},{"baud",1,0,'b'},
	{"file",1,0,'f'},{"pipe",1,0,'p'},
	{"pin",1,0,0},
	{"info",0,0,'i'},{"set-time",0,0,0},{"set-smsc",0,0,0},
	{"help",0,0,'h'},{"version",0,0,0},
	{"verbose",0,0,'v'},{"quiet",0,0,'q'},
	{"reset",0,0,0},
#if USE_GREEK_CHARS==0
	{"greek",0,0,0},
#else
	{"nogreek",0,0,0},
#endif
	{0,0,0,0}
    };

//start setup
    //begin init global vars	
    memset(PIN,0,sizeof(PIN));
    VERBOSE_LEVEL=0;
    mytty=-1;
#if USE_GREEK_CHARS==0
    use_greek_chars=0;
#else
    use_greek_chars=1;
#endif
    //end init global vars    

    mydata.text=empty;
    mydata.number=empty;
    myFILE=empty;
    myPIPE=empty;
    PBOOK=empty;
    //using env. var. SCMXX_TTY
    if (getenv("SCMXX_TTY")!=NULL) {
	myttyport=getenv("SCMXX_TTY");
    } else {
	myttyport=malloc(strlen(TTYPORT)+1);
	strcpy(myttyport,TTYPORT);
    }
    //using env. var. SCMXX_BAUD
    if (getenv("SCMXX_BAUD")!=NULL) {
        myttyspeed=ttyspeed(getenv("SCMXX_BAUD"));
    } else {
        myttyspeed=ttyspeed(TTYSPEED);
    }
	
    if (argc==1) {
	RUN_HELP=1;
    }
    while ((arg=getopt_long(argc,
                            argv,
                            "rsgB::M::C::F::P:S::t:n:d:b:f:p:ivqh",
                            myoptions,&option_index)
            ) != -1) {
        switch (arg){
            case 'r':
                    SETTINGS |= (1<<5);
                    break;
            case 's': 
                    SETTINGS |= (1<<6);
                    break;
            case 'g':
                    SETTINGS |= (1<<7);
                    break;
            case 'B':
		    SETTINGS &= (15<<4);
                    SETTINGS |= 1;
                    if (optarg) {
			if(is_number(optarg)) {
                            SLOT=atoi(optarg);
                	} else if (!strcmp(optarg,"all")) {
                            SLOT=-2;
                	} else {
			    errexit("\"%s\" is not a valid %s slot.\n",optarg,"bitmap");
			}
                    } else {
                        SLOT = -1;
                    }
                    break;
            case 'M':
		    SETTINGS &= (15<<4);
                    SETTINGS |= 3;
                    if (optarg) {
			if(is_number(optarg)) {
                            SLOT=atoi(optarg);
                	} else if (!strcmp(optarg,"all")) {
                            SLOT=-2;
                	} else {
			    errexit("\"%s\" is not a valid %s slot.\n",optarg,"midi");
			}
                    } else {
                        SLOT = -1;
                    }
                    break;
            case 'C':
		    SETTINGS &= (15<<4);
                    SETTINGS |= 5;
                    if (optarg) {
			if(is_number(optarg)) {
                            SLOT=atoi(optarg);
                	} else if (!strcmp(optarg,"all")) {
                            SLOT=-2;
                	} else {
			    errexit("\"%s\" is not a valid %s slot.\n",optarg,"vcal");
			}
                    } else {
                        SLOT = -1;
                    }
		    break;
            case 'F':
		    SETTINGS &= (15<<4);
                    SETTINGS |= 7;
                    if (optarg) {
			if(is_number(optarg)) {
                            SLOT=atoi(optarg);
                	} else if (!strcmp(optarg,"all")) {
                            SLOT=-2;
                	} else {
			    errexit("\"%s\" is not a valid %s slot.\n",optarg,"vcf");
			}
                    } else {
                        SLOT = -1;
                    }
                    break;
            case 'P':
		    SETTINGS &= (15<<4);
                    SETTINGS |= 2;
                    if (optarg) {
                        PBOOK=optarg;
                    } else {
                        errexit("You have to select a phonebook.\n");
                    }
                    break;
            case 'S':
		    SETTINGS &= (15<<4);
                    SETTINGS |= 0;
                    if (optarg) {
			if (is_number(optarg)) {
			    SLOT=atoi(optarg);
			} else {
			    if(!strcmp(optarg,"all")) {
				SLOT=-4;
			    } else if(!strcmp(optarg,"sent")) {
				SLOT=-3;
			    } else if(!strcmp(optarg,"unsent")) {
				SLOT=-2;
			    } else if(!strcmp(optarg,"read")) {
				SLOT=-1;
			    } else {
				SLOT=0;
			    }
			}
                    }
                    break;
            case 't':
                    if (optarg) {
                        mydata.text=optarg;
                    } else {
                        errexit("Zero length text makes no sense.\n");
                    }
                    break;
            case 'n':
                    if (optarg) {
			mydata.number=optarg;
                    }
                    break;
            case 'd':
                    if (optarg) {
			if (getenv("SCMXX_TTY")==NULL) {
			    free(myttyport);
			}
			myttyport=optarg;
                        //set_ttyport(myttyport,optarg);
                    }
                    break;
            case 'b':
                    if (optarg) {
                        myttyspeed=ttyspeed(optarg);
                    }
                    break;
            case 'f':
                    if (optarg) {
                        myFILE=optarg;
                    }
                    break;
            case 'p':
                    if (optarg) {
                        myPIPE=optarg;
                    }
                    break;
            case 'i':
                    RUN_INFO=1;
                    break;
            case 'v':
                    VERBOSE_LEVEL++;
                    break;
            case 'q':
                    VERBOSE_LEVEL--;
                    break;
            case 'h':
		    RUN_HELP=1;
                    break;
            case 0:
                    if (!strcmp(myoptions[option_index].name,"set-time")) {
                        RUN_SETTIME=1;
                    } else if (!strcmp(myoptions[option_index].name,"set-smsc")) {
                        RUN_SETSMSC=1;
                    } else if (!strcmp(myoptions[option_index].name,"direct")) {
			SETTINGS |= (1<<4);
                    } else if (!strcmp(myoptions[option_index].name,"pin")) {
                        if (optarg && strlen(optarg)<sizeof(PIN)) {
                            strcpy(PIN,optarg);
                        }
                    } else if (!strcmp(myoptions[option_index].name,"flash")) {
                        flashsms=1;
                    } else if(!strcmp(myoptions[option_index].name,"reset")) {
                        RESET=1;
                    } else if(!strcmp(myoptions[option_index].name,"version")) {
                        RUN_VERSION=1;
                    }
#if USE_GREEK_CHARS==0
                      else if (!strcmp(myoptions[option_index].name,"greek")) {
                        use_greek_chars=1;
                    }
#else
                      else if (!strcmp(myoptions[option_index].name,"nogreek")) {
                        use_greek_chars=0;
                    }
#endif
                    break;
        }
    }
//end of setup

    if (RESET) {
        /*
         * sending a sync frame
         * the phone may not respond without it because it thinks that all
         * send commands are still data from a previous run
         */
        open_mytty(myttyport,myttyspeed);
        myprintf(0,"Setting reset frame...");
        write_mytty("\x1a\r\n");
        myprintf(0,"done\n");
    } else if (RUN_HELP) {
	help(argv[0]);
    } else if (RUN_VERSION) {
	version();
    } else {
        open_mytty(myttyport,myttyspeed);
	//testing the device
	new_at_command(at_command,"Z");
	signal(SIGALRM,noAnswerFromPhone);
	alarm(10);
	com_mytty(at_command,ack);
	if (!strcmp(ack,"OK")) {
	    myprintf(0,"OK, a modem device is present.\n");
	} else if (!strcmp(ack,"ERROR")) {
	    errexit("ERROR, cannot communicate with device.\n");
	} else {
	    errexit("Unexpected return code: %s\n",ack);
	}
	alarm(0);
	//enabling advanced error response
	//not needed everywhere but this reduces code duplication
	new_at_command(at_command,"+CMEE=2");
	com_mytty(at_command,ack);
	if (strcmp(ack,"OK")) {
	    errexit("ERROR, aborting\n");
	}
	//disabling command echo
	new_at_command(at_command,"E0");
	com_mytty(at_command,ack);
	if (strcmp(ack,"OK")) {
	    errexit("ERROR, aborting\n");
	}
	//changing to GSM charset
	new_at_command(at_command,"+CSCS=GSM");
	com_mytty(at_command,ack);
	if (strcmp(ack,"OK")) {
	    errexit("ERROR, aborting\n");
	}
	if (strcasecmp(get_vendor(),"SIEMENS")) {
	    myprintf(0,"WARNING: Phones from this vendor were not confirmed to be working with this software!\n");
	}
	if(RUN_INFO) {
	    info();
	} else if (RUN_SETTIME) {
	    set_time();
	} else if (RUN_SETSMSC) {
	    set_smsc(mydata.number);
	} else {
	    strcpy(ausgabe,get_model());
	    myprintf(0,"Detected %s %s\n",get_vendor(),ausgabe);
	    if (!(!strcmp(ausgabe,"S35i") || !strcmp(ausgabe,"M35i") || !strcmp(ausgabe,"C35i")
		  || !strcmp(ausgabe,"SL45") || !strcmp(ausgabe,"C45")
		  || !strcmp(ausgabe,"S45") || !strcmp(ausgabe,"ME45")
		  || !strcmp(ausgabe,"S25"))) {
        	myprintf(0,"WARNING: this phone was not confirmed to be working with this software.\n");
	    }
	    if ((SETTINGS>>6)&1) {
		if ((SETTINGS&15)==0 && strlen(mydata.text)) {
		    handle_s35("",myPIPE,SETTINGS,SLOT,mydata,flashsms,PBOOK);
		}
		while (optind<argc) {
        	    handle_s35(argv[optind++],myPIPE,SETTINGS,SLOT,mydata,flashsms,PBOOK);
		}
	    } else {
		handle_s35(myFILE,myPIPE,SETTINGS,SLOT,mydata,flashsms,PBOOK);
	    }
	}
    }
    close_mytty();
    exit(0);
}

void errexit(char *errmessage, ...){
    va_list arg_list;
    va_start(arg_list,errmessage);
    vfprintf(stderr,errmessage,arg_list);
    va_end(arg_list);
    close_mytty();
    exit(1);
}

void myprintf(int verbose_level, char *output, ...){
    va_list arg_list;
    va_start(arg_list,output);
    if (verbose_level<=VERBOSE_LEVEL) {
        vfprintf(stderr,output,arg_list);
    }
    va_end(arg_list);
}
