/***************************************************************************
                          smcxx.c  -  description
                             -------------------
    copyright            : (C) 2001 by Hendrik Sattler
    email                : post@hendrik-sattler.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "version.h"

void help(char *me){
	printf("This is a program written by Hendrik Sattler (post@hendrik-sattler.de).\n");
	printf("This program is licenced with the GPL.\n");
	printf("Use at your own risk!\n");
	printf("You need a phone made by Siemens to get an useful result.\n\n");
	printf("Syntax: %s [options] [operation [slot[sms options]]] [file1 file2 ...]\n",me);
	printf("Options:\n");
	printf("--device <device>\t  -d\tspecify another than the compiled in device\n");
	printf("--baud <baudrate>\t  -b\tspecify another than the compiled in baudrate\n");
	printf("--file <file>\t\t  -f\tspecify a file to use ('-' for stdout)\n");
	printf("\t\t\t\twhen using slot \"all\" this gets expanded\n");
	printf("--pipe <program>\t  -p\tspecify a pipe to use\n");
	printf("--pin <pin>\t\t\tuse this pin if one is needed\n");
	printf("--quiet\t\t\t  -q\tdecreases verbosity by 1 (min verbosity: -1)\n");
	printf("--verbose\t\t  -v\tincreases verbosity by 1 (max verbosity: +1)\n");
	printf("--reset\t\t\t\ttry this if the phone does not respond after an\n");
	printf("\t\t\t\tuser-interrupted file transfer\n");
#if USE_GREEK_CHARS==0
	printf("--greek\t\t\t\tuse greek characters as default\n");
#else
	printf("--nogreek\t\t\tuse latin characters as default\n");
#endif
	printf("--help\t\t\t  -h\tprint this message\n");
	printf("--version\t\t\tprint the version number\n");
	printf("Operation:\n");
	printf("--remove\t\t  -r\tremoves an entry from the phone\n");
	printf("--send\t\t\t  -s\tsends a file to the phone\n");
	printf("--get\t\t\t  -g\tget an entry and save it to a file\n");
	printf("--info\t\t\t  -i\tcollect information\n");
	printf("--set-time\t\t\tsynchronize time on phone\n");
	printf("--set-smsc\t\t\tset the SMSC number (requires \"-n\")\n");
	printf("Slot (<slot#> is either a number or \"all\"):\n");
	printf("--bitmap[=<slot#>]\t  -B\tselect bitmap slot number\n");
	printf("--midi[=<slot#>]\t  -M\tselect midi slot number\n");
	printf("--vcal[=<slot#>]\t  -C\tselect calendar slot number\n");
	printf("--vcard[=<slot#>]\t  -F\tselect address book slot number\n");
	printf("--pbook[=]<phonebook>\t  -P\tselect phonebook\n");
	printf("--sms[=<slot#>|=<status>] -S\tselect short-message\n");
	printf("SMS options:\n");
	printf("--text <text>\t\t  -t\tspecify content of SMS (sending only)\n");
	printf("--number <number>\t  -n\tspecify number to send SMS to (sending only)\n");
	printf("--direct\t\t\tsend/receive without storing in the phone\n");
	printf("--flash\t\t\t\tmake the sms appear directly (if supported by\n");
	printf("\t\t\t\tthe receiving entity)\n");
	printf("\nSee README file for more detailed information.\n");	
	printf("Version: ");
	version();
}

void version () {
    printf("%s\n",VERSION);
}
