/*
 * gsmcodes.c - converting to/from gsm charset
 *
 * Author: Hendrik Sattler <post@hendrik-sattler.de>
 *
 * This file is part of SCMxx
 */


/*
 * there should be Unicode in the future (when common editors support this)
 * neither can all characters be displayed at once without this
 * nor can there be a complete conversion to GSM because of conflicting iso charsets
 * see gsmcharset.txt. for the GSM character set
 */


#include "common.h"

void gsm2iso (unsigned char *token){
  char temp[BUFSIZ];
  int buffer;
  int i;

  memset (temp, 0, sizeof (temp));
  for (i = 0; i < strlen (token); i++){
      switch (buffer = token[i]){
	case 1:	//Pound
	  temp[strlen (temp)] = 163;
	  break;
	case 2:	//Dollar
	  temp[strlen (temp)] = 36;
	  break;
	case 3:	//Yen
	  temp[strlen (temp)] = 165;
	  break;
	case 4:
	  temp[strlen (temp)] = 232;
	  break;
	case 5:
	  temp[strlen (temp)] = 233;
	  break;
	case 6:
	  temp[strlen (temp)] = 249;
	  break;
	case 7:
	  temp[strlen (temp)] = 236;
	  break;
	case 8:
	  temp[strlen (temp)] = 242;
	  break;
	case 9:
	  temp[strlen (temp)] = 199;
	  break;
	case 11:
	  if (use_greek_chars){
	      temp[strlen (temp)] = 92;
	      temp[strlen (temp)] = '/';
	  }else{
	      temp[strlen (temp)] = 216;
	  }
	  break;
	case 12:
	  temp[strlen (temp)] = 248;
	  break;
	case 14:
	  temp[strlen (temp)] = 197;
	  break;
	case 15:
	  temp[strlen (temp)] = 229;
	  break;
	case 16: //delta, this is only displayed correctly with iso8859-7
	  if (!use_greek_chars){
	      temp[strlen (temp)] = 92;
	      temp[strlen (temp)] = 'D';
	  }else{
	      temp[strlen (temp)] = 196;
	  }
	  break;
	case 17:
	  temp[strlen (temp)] = 95;
	  break;
	case 18: //phi, this is only displayed correctly with iso8859-7
	  if (!use_greek_chars){
	      temp[strlen (temp)] = 92;
	      temp[strlen (temp)] = 'F';
	  }else{
	      temp[strlen (temp)] = 214;
	  }
	  break;
	case 19: //gamma, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 195;
	  break;
	case 20: //lambda, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 203;
	  break;
	case 21: //omega, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 217;
	  break;
	case 22: //pi, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 208;
	  break;
	case 23: //psi, this is only displayed correctly with iso8859-7
	  if (!use_greek_chars){
	      temp[strlen (temp)] = 92;
	      temp[strlen (temp)] = 'C';
	  }else{
	      temp[strlen (temp)] = 216;
	  }
	  break;
	case 24: //sigma, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 211;
	  break;
	case 25: //theta, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 200;
	  break;
	case 26: //xi, this is only displayed correctly with iso8859-7
	  temp[strlen (temp)] = 206;
	  break;
	case 27: //GSM extension table character
	  i++;
	  buffer = token[i];
	  switch (buffer){
	    case 20:
	      temp[strlen (temp)] = 94;
	      break;;
	    case 27:
	      sprintf (&temp[strlen (temp)], " ");
	      break;;
	    case 40:
	      temp[strlen (temp)] = 123;
	      break;;
	    case 41:
	      temp[strlen (temp)] = 125;
	      break;;
	    case 47:
	      temp[strlen (temp)] = 92;
	      break;;
	    case 60:
	      temp[strlen (temp)] = 91;
	      break;;
	    case 61:
	      temp[strlen (temp)] = 126;
	      break;;
	    case 62:
	      temp[strlen (temp)] = 93;
	      break;;
	    case 64:
	      temp[strlen (temp)] = 124;
	      break;;
	    case 101: //Euro, this is only displayed correctly with iso8859-15
	      temp[strlen (temp)] = 164;
	      break;;
	    default:
	      i--;
	      break;;
	  }
	  break;
	case 28:
	  temp[strlen (temp)] = 198;
	  break;
	case 29:
	  temp[strlen (temp)] = 230;
	  break;
	case 30:
	  temp[strlen (temp)] = 223;
	  break;
	case 31:
	  temp[strlen (temp)] = 201;
	  break;
	case 36: //currency sign conflicts with EuroSign, so I map it to degree char
	  temp[strlen (temp)] = 176;
	  break;
	case 64: //inverted !
	  temp[strlen (temp)] = 161;
	  break;
	case 91:
	  if (use_greek_chars){
	      temp[strlen (temp)] = 92;
	      temp[strlen (temp)] = 'A';
	  }else{
	      temp[strlen (temp)] = 196;
	  }
	  break;
	case 92:
	  if (use_greek_chars){
	      temp[strlen (temp)] = 92;
	      temp[strlen (temp)] = 'O';
	  }else{
	      temp[strlen (temp)] = 214;
	  }
	  break;
	case 93:
	  temp[strlen (temp)] = 209;
	  break;
	case 94:
	  temp[strlen (temp)] = 220;
	  break;
	case 95:
	  temp[strlen (temp)] = 167;
	  break;
	case 96:
	  temp[strlen (temp)] = 191;
	  break;
	case 123:
	  temp[strlen (temp)] = 228;
	  break;
	case 124:
	  temp[strlen (temp)] = 246;
	  break;
	case 125:
	  temp[strlen (temp)] = 241;
	  break;
	case 126:
	  temp[strlen (temp)] = 252;
	  break;
	case 127:
	  temp[strlen (temp)] = 224;
	  break;
	// untrue match:
	case 128:		//must match rewrite in read_mytty!!!
	  temp[strlen (temp)] = 64;
	  break;
	// end of untrue match
	default:
	  temp[strlen (temp)] = buffer;
	  break;
      }
  }
  strcpy (token, temp);
}

void iso2gsm (unsigned char *token){
  char temp[BUFSIZ];
  int buffer, i;

  memset (temp, 0, sizeof (temp));
  for (i = 0; i < strlen (token); i++){
      buffer = token[i];
      switch (buffer){
	case 36:
	  temp[strlen (temp)] = 2;
	  break;
	case 64: // masking the 0x00 (the last 7 bits stay the same)
	  temp[strlen (temp)] = 128;
	  break;
	case 91:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 60; //see GSM extension table 1
	  break;
	case 93:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 62; //see GSM extension table 1
	  break;
	case 94:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 20; //see GSM extension table 1
	  break;
	case 95:
	  temp[strlen (temp)] = 17;
	  break;
	case 123:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 40; //see GSM extension table 1
	  break;
	case 124:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 64; //see GSM extension table 1
	  break;
	case 125:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 41; //see GSM extension table 1
	  break;
	case 126:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 61; //see GSM extension table 1
	  break;
	case 161:
	  temp[strlen (temp)] = 64;
	  break;
	case 163:
	  temp[strlen (temp)] = 1;
	  break;
	case 164:
	  temp[strlen (temp)] = 27; //GSM mask char
	  temp[strlen (temp)] = 101; //see GSM extension table 1
	  break;
	case 165:
	  temp[strlen (temp)] = 3;
	  break;
	case 167:
	  temp[strlen (temp)] = 95;
	  break;
	case 176:
	  temp[strlen (temp)] = 36;
	  break;
	case 191:
	  temp[strlen (temp)] = 96;
	  break;
	case 195:
	  temp[strlen (temp)] = 19; //gamma
	  break;
	case 196:
	  if (use_greek_chars){
	      temp[strlen (temp)] = 16;	//delta
	  }else{
	      temp[strlen (temp)] = 91;	//A with diaeresis
	  }
	  break;
	case 197:
	  temp[strlen (temp)] = 14;
	  break;
	case 198:
	  temp[strlen (temp)] = 28;
	  break;
	case 199:
	  temp[strlen (temp)] = 9;
	  break;
	case 200:
	  temp[strlen (temp)] = 25; //theta
	  break;
	case 201:
	  temp[strlen (temp)] = 31;
	  break;
	case 203:
	  temp[strlen (temp)] = 20; //lambda
	  break;
	case 206:
	  temp[strlen (temp)] = 26; //xi
	  break;
	case 208:
	  temp[strlen (temp)] = 22; //pi
	  break;
	case 209:
	  temp[strlen (temp)] = 93;
	  break;
	case 211:
	  temp[strlen (temp)] = 24; //sigma
	  break;
	case 214:
	  if (use_greek_chars){
	      temp[strlen (temp)] = 18;	//phi
	  }else{
	      temp[strlen (temp)] = 92;	//O with diaeresis
	  }
	  break;
	case 216:
	  if (use_greek_chars){
	      temp[strlen (temp)] = 23;	//psi
	  }else{
	      temp[strlen (temp)] = 11;	//O with stroke
	  }
	  break;
	case 217:
	  temp[strlen (temp)] = 21; //omega
	  break;
	case 220:
	  temp[strlen (temp)] = 94;
	  break;
	case 223:
	  temp[strlen (temp)] = 30;
	  break;
	case 224:
	  temp[strlen (temp)] = 127;
	  break;
	case 228:
	  temp[strlen (temp)] = 123;
	  break;
	case 229:
	  temp[strlen (temp)] = 15;
	  break;
	case 230:
	  temp[strlen (temp)] = 29;
	  break;
	case 232:
	  temp[strlen (temp)] = 4;
	  break;
	case 233:
	  temp[strlen (temp)] = 5;
	  break;
	case 236:
	  temp[strlen (temp)] = 7;
	  break;
	case 241:
	  temp[strlen (temp)] = 125;
	  break;
	case 242:
	  temp[strlen (temp)] = 8;
	  break;
	case 246:
	  temp[strlen (temp)] = 124;
	  break;
	case 248:
	  temp[strlen (temp)] = 12;
	  break;
	case 249:
	  temp[strlen (temp)] = 6;
	  break;
	case 252:
	  temp[strlen (temp)] = 126;
	  break;
	case 92: //enable masq. character (not GSM masq. char but '\')
	  i++;
	  buffer = token[i];
	  switch (buffer){
	    case 110:
	      temp[strlen (temp)] = 10;	// \n
	      break;
	    case 92:
	      temp[strlen (temp)] = 27;	//GSM mask char
	      temp[strlen (temp)] = 47;	//see GSM extension table 1
	      break;
	    case 'G':
	      temp[strlen (temp)] = 19;	//gamma
	      break;
	    case 'D':
	      temp[strlen (temp)] = 16;	//delta
	      break;
	    case 'U':
	      temp[strlen (temp)] = 25;	//theta
	      break;
	    case 'L':
	      temp[strlen (temp)] = 20;	//lambda
	      break;
	    case 'J':
	      temp[strlen (temp)] = 26;	//xi
	      break;
	    case 'P':
	      temp[strlen (temp)] = 22;	//pi
	      break;
	    case 'S':
	      temp[strlen (temp)] = 24;	//sigma
	      break;
	    case 'F':
	      temp[strlen (temp)] = 18;	//phi
	      break;
	    case 'C':
	      temp[strlen (temp)] = 23;	//psi
	      break;
	    case 'V':
	      temp[strlen (temp)] = 21;	//omega
	      break;
	    case 'A':
	      temp[strlen (temp)] = 91;	//A with diaeresis
	      break;
	    case 'O':
	      temp[strlen (temp)] = 92;	//O with diaeresis
	      break;
	    case '/':
	      temp[strlen (temp)] = 11;	//O with stroke
	      break;
	    default:
	      myprintf (0," %c (=0x%02x) is not a special, maskable character.\n",buffer, buffer);
	      break;
	  }
	  break;
	default: //this really depends on ASCII
	  if (buffer < 128 && (buffer == 10 ||
			       (32 <= buffer && buffer <= 35) ||
			       (37 <= buffer && buffer <= 63) ||
			       (65 <= buffer && buffer <= 90) ||
			       (97 <= buffer && buffer <= 122)))
	    {temp[strlen (temp)] = buffer;}
	  else{myprintf (0, " %c (=0x%02x) is not a GSM character\n", buffer,buffer);}
	  break;
      }
  }
  strcpy (token, temp);
}

void mask_pbook_chars (unsigned char *token){
  char temp[BUFSIZ];
  int buffer;
  int i;

  memset (temp, 0, sizeof (temp));
  for (i = 1; i < (strlen (token) - 1); i++){
      switch (buffer = token[i]){
	case 8: //masking the o` sign (0x08)
	  temp[strlen (temp)] = 92;
	  temp[strlen (temp)] = 48;
	  temp[strlen (temp)] = 56;
	  break;
	case 34: //masking the quote sign (0x22)
	  temp[strlen (temp)] = 92;
	  temp[strlen (temp)] = 50;
	  temp[strlen (temp)] = 50;
	  break;
	case 92: //masking the mask character (0x5C)
	  temp[strlen (temp)] = 92;
	  temp[strlen (temp)] = 53;
	  temp[strlen (temp)] = 67;
	  break;
	case 128: // masking the at character the 0x00
	  temp[strlen (temp)] = 92;
	  temp[strlen (temp)] = 48;
	  temp[strlen (temp)] = 48;
	  break;
	default:
	  temp[strlen (temp)] = buffer;
	  break;
      }
  }
  sprintf(token, "\"%s\"", temp);
}

int iso2gsm_sms (unsigned char *token){
  const int maxSmsSize = 160;
  unsigned char temp[281];
  int i, first, end, size;

  memset (temp, 0, sizeof (temp));
  iso2gsm (token);
  size = strlen (token);
  //make it easy to see if user data does not exceed the 140 octets limit
  //when there are characters from the extension table
  if (size > maxSmsSize){
      errexit ("SMS text is too long (max. %d characters).\nPlease be aware that some characters are encoded as 14bit (instead of 7bit), e.g. the euro character.\n",
               maxSmsSize);
  }
  //7bit-GSM octet encoding
  for (i = 0; i < size; i++){
      end = token[i] & 127; //the character are 7bit
      end >>= (i % 8);
      first = token[i + 1] & 127;
      first <<= 7 - (i % 8);
      first &= 255; //we only need the last eight bits (AND mask)
      sprintf (&temp[strlen (temp)], "%02X", (first | end));
      if ((i % 8) == 6){i++;} //every 8th char is already coded in (it really must be 6)
  }
  strcpy (token, temp);
  return size;
}

void gsm2iso_sms (unsigned int length, unsigned char *token){
  unsigned char temp[281], ud[281];
  unsigned char buffer;
  int i, first, end, offset = -1;

  memset (temp, 0, sizeof (temp));
  memset (ud, 0, sizeof (ud));
  if (!length){return;}
  for (i = 0; i < strlen (token); i += 2){
      sprintf (temp, "%c%c", token[i], token[i + 1]);
      ud[i / 2] = hexstr2int (temp);
      memset (temp, 0, sizeof (temp));
  }

  //unpack the 7bit chars from the octets
  for (i = 0; i < length; i++){
      if (i % 8){
	  first = ud[i - 1 - offset];
	  first >>= 8 - (i % 8);
	  end = ud[i - offset];
	  end <<= (i % 8);
	  buffer = first | end;
      }else{
	  offset++;
	  buffer = ud[i - offset];
      }
      if (buffer == 0){buffer = 128;}//special char @
      else{buffer &= 127;} //only the last 7 bits count
      temp[strlen (temp)] = buffer;
  }
  gsm2iso (temp);
  strcpy(token, temp);
}
