/* vim:set noet ts=4: */
/** 
 * scim-python
 * 
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: $
 */
#ifndef __SCIM_PYTHON_FACTORY_H_
#define __SCIM_PYTHON_FACTORY_H_
#define Uses_SCIM_IMENGINE
#define Uses_SCIM_CONFIG_BASE
#include <Python.h>
#include <scim.h>

using namespace scim;

struct PyIMEngineFactoryObject;

class PyIMEngineFactory : public IMEngineFactoryBase {
private:
	PyObject *self;
	PyObject *config;
	Connection reload_signal_connection;

private:
	PyIMEngineFactory (PyObject *self, PyObject *config);
	virtual ~PyIMEngineFactory ();

public:
	String get_attr_string (char *name) const;
	WideString get_attr_unicode (char *name) const;	
	virtual WideString  get_name () const;
	virtual String get_uuid () const;
	virtual String get_icon_file () const;
	virtual WideString get_authors () const;
	virtual WideString get_credits () const;
	virtual WideString get_help () const;
	virtual bool validate_encoding (const String& encoding);
	virtual bool validate_locale (const String& locale);
	virtual IMEngineInstancePointer create_instance (const String& encoding, int id = -1);

private:
	void reload_config (const ConfigPointer &config);

public:
	static PyObject *py_set_languages		(PyIMEngineFactoryObject	*self, 
											 PyObject					*args);
	static PyObject *py_validate_encoding	(PyIMEngineFactoryObject 	*self,
											 PyObject					*args);
	static PyObject *py_validate_locale		(PyIMEngineFactoryObject	*self,
											 PyObject					*args);
	static PyObject *py_new					(PyTypeObject				*type,
											 PyObject					*args,
											 PyObject					*kwds);
	static int py_init						(PyIMEngineFactoryObject	*self,
											 PyObject					*args,
											 PyObject					*kwds);
	static void py_dealloc					(PyIMEngineFactoryObject 	*self);
	static IMEngineFactoryBase *from_pyobject
											(PyObject					*object);

	static PyMethodDef py_methods[];

	static void operator delete 			(void						*p);

};

void init_factory (PyObject *module);

#endif /*__SCIM_PYTHON_FACTORY_H_*/
