/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ksecurity;

import com.sun.ksecurity.MessageDigest;

final class SHA
extends MessageDigest {
    private int[] state = new int[5];
    private int[] num = new int[1];
    private int[] count = new int[2];
    private int[] data = new int[16];
    private byte type = (byte)2;
    private byte len = (byte)20;

    SHA() {
        this.reset();
    }

    public byte getAlgorithm() {
        return this.type;
    }

    public byte getLength() {
        return this.len;
    }

    public void reset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.type = (byte)2;
        this.len = (byte)20;
        this.num[0] = 0;
        this.count[1] = 0;
        this.count[0] = 0;
        int i = 0;
        while (i < 16) {
            this.data[i] = 0;
            ++i;
        }
    }

    public void update(byte[] buf, int off, int len) {
        if (len == 0) {
            return;
        }
        int test = buf[off] + buf[len - 1] + buf[off + len - 1];
        SHA.nativeUpdate(buf, off, len, this.state, this.num, this.count, this.data);
    }

    private static native void nativeUpdate(byte[] var0, int var1, int var2, int[] var3, int[] var4, int[] var5, int[] var6);

    public short doFinal(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) {
        int test = outBuf[outOff] + outBuf[outOff + this.len - 1];
        this.update(inBuf, inOff, inLen);
        SHA.nativeFinal(outBuf, outOff, this.state, this.num, this.count, this.data);
        this.reset();
        return 20;
    }

    private static native void nativeFinal(byte[] var0, int var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public Object clone() {
        SHA cpy = new SHA();
        System.arraycopy(this.state, 0, cpy.state, 0, 5);
        System.arraycopy(this.num, 0, cpy.num, 0, 1);
        System.arraycopy(this.count, 0, cpy.count, 0, 2);
        System.arraycopy(this.data, 0, cpy.data, 0, 16);
        return cpy;
    }
}

