// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IntegerSubtypeDefinition.cc,v 1.3 1999/03/12 16:08:29 dmadhava Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIRScram_IntegerLiteral.hh"

IIRScram_IntegerSubtypeDefinition::~IIRScram_IntegerSubtypeDefinition() {}

void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_universal_value() {
  _cc_out << "ArrayInfo(";
  get_left()->_publish_cc_value();
  _cc_out << ", ";
  if(get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "to, ";
  }
  else {
    _cc_out << "downto, ";
  }
  get_right()->_publish_cc_value();
  _cc_out << ")";
}


void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_left() {
  if (_is_anonymous()) {
    get_left()->_publish_cc();
  }
  else {
    _publish_cc_type_name();
    _cc_out << "::LEFT(Savant";
    _get_declarator()->_publish_cc();
    _cc_out << "Type_info)";
  }    
}

void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_right() {
  if (_is_anonymous()) {
    get_right()->_publish_cc();
  }
  else {
    if (this->_is_kernel_type() == TRUE){
      _publish_cc_type_name();
      _cc_out << "::RIGHT()";
    }
    else {
      if (get_left() != NULL && get_right() != NULL){
	_cc_out << "IntegerType::RIGHT(";
	if (this->_is_scalar_type() == TRUE) {
	  this->_publish_cc();
	  _cc_out << "_info)";
	}
      }
      else {
	_publish_cc();
	_cc_out << "::RIGHT(";
	if (this->_is_scalar_type() == TRUE &&
	    this->_is_kernel_type() == FALSE){
	  this->_publish_cc_type_name();
	}
	else {
	_publish_cc();
	}
	_cc_out << "_info)";
      }
    }
  }
}

void 
IIRScram_IntegerSubtypeDefinition::_publish_cc_universal_type() {
  _cc_out << "UniversalInteger";
}

IIR_Boolean
IIRScram_IntegerSubtypeDefinition::_is_subtype() {
  return TRUE;
}

void
IIRScram_IntegerSubtypeDefinition::_publish_cc_type_info(){
  if(_is_scalar_type() == TRUE){
    _cc_out << "rangeInfo ";
    _publish_cc();
    _cc_out << "_info(";
    get_left()->_publish_cc_value();
    _cc_out << ", ";
    if(get_direction()->_is_ascending_range() == TRUE) {
      _cc_out << "to, ";
    }
    else {
      _cc_out << "downto, ";
    }
    get_right()->_publish_cc_value();
    _cc_out << ")";
  }
}    

void
IIRScram_IntegerSubtypeDefinition::_publish_cc_extern_type_info(){
  ASSERT (_is_scalar_type() == TRUE);

  if (_is_anonymous() == FALSE) {
    _cc_out << "extern rangeInfo ";
    _publish_cc();
    _cc_out << "_info;\n";
  }
  else {
    ASSERT (_get_base_type() != NULL);
    if (_get_base_type()->_is_anonymous() == FALSE) {
      _cc_out << "extern rangeInfo ";
      _get_base_type()->_publish_cc();
      _cc_out << "_info;\n";
    }
  }
}    

IIR *
IIRScram_IntegerSubtypeDefinition::_clone(){
  IIR_IntegerSubtypeDefinition *my_clone = new IIR_IntegerSubtypeDefinition();
  IIR_IntegerTypeDefinition::_clone( my_clone );
  my_clone->set_resolution_function( get_resolution_function() );
  return my_clone;
}









