// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DesignFile.cc,v 1.8 1999/07/23 21:08:03 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_DesignFile.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_Identifier.hh"
#include "scram.hh"

// This should all be replaced with architecture independent stuff (like an
// os_interface_manager class) or something.
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

extern char *entity_name, *arch_name, *config_name, *design_library_name;
#ifdef PROCESS_GRAPH
extern bool signal_graph;
#endif
dl_list<char>
IIRScram_DesignFile::use_list;

IIRScram_DesignFile::~IIRScram_DesignFile() {}

void 
IIRScram_DesignFile::_publish_vhdl(ostream &_vhdl_out) {
  library_units._publish_vhdl(_vhdl_out);
}


void 
IIRScram_DesignFile::_publish_cc() {
  IIRScram::_set_currently_publishing_unit(IIRScram::NONE);
  library_units._publish_cc();
  if ( design_library_name != NULL){
    _publish_cc_design_library_makefile();
  } else {
    _publish_cc_makefile();
  }

  library_units._publish_cc_elaborate();
  if ( design_library_name == NULL ){
    _publish_cc_mainNew();
  }
}


void
IIRScram_DesignFile::_publish_cc_makefile() {
  int i;
  char *libName = NULL;
  _cc_out.set_file(TRUE, "Makefile");

  // Get the uid and their home dir.
  int uid = getuid();
  char *username, *dir;
  struct passwd *pwd_entry;

  pwd_entry = getpwuid( uid );
  if (pwd_entry != NULL) {
    username = pwd_entry->pw_name;
    dir = pwd_entry->pw_dir;
  }
  else {
    username = dir = NULL;
  }
  ostrstream objectname;
  char *object;
  if((_current_entity_name != NULL) && (_current_architecture_name != NULL)) {
    //    objectname << "SEA";
    objectname << _current_entity_name << "_" << _current_architecture_name;
    //    objectname << "_elab" << ends;
  }
  else {
    objectname << "_savant_entity_elab";
  }
  objectname << ends;
  object = objectname.str();

  _cc_out << "#-*-makefile-*-\n";
  //   _cc_out << "TOP = " << dir << "/research\n";
  //   _cc_out << "TWDIR = $(TOP)/warped/src\n";
  //   _cc_out << "VHDLDIR = $(TOP)/tyvis/VHDLKernel\n";

  _cc_out << "SIMSRCS = $(wildcard *.cc)\n"
	  << "SIMOBJS = $(patsubst %.cc,%.o, $(SIMSRCS))\n\n"
	  << "DEPENDS = $(SIMOBJS)\n"
	  << "include " << _get_library_manager()->get_savant_root_directory() 
	  << "/lib/Makefile.common\n"
	  << "CPPFLAGS=$(SIMCPPFLAGS)\n"
	  << "CXXFLAGS=$(SIMCXXFLAGS)\n"
	  << "export METHOD\n";

  if( strcasecmp(IIR::_get_library_manager()->get_work_dir_name(), "work._savant_lib") != 0 ){
    _cc_out << "AR = ar cr \n\n";
  }
  // include design libraries here...
  _publish_cc_library_path();

  // Add stuff to the DEPENDS thing
  libName = use_list.first();
  if(use_list.num_elements() >= 1){
    _cc_out << "\nDEPENDS += ";
    for(i = 1; (i <= use_list.num_elements()); i++) {
      if (strcasecmp(libName, "work") != 0) {
	_cc_out << "$(DESIGN_LIB_DIR" << i << ")/" << libName
		<< "._savant_lib.a ";
	libName = use_list.successor(libName);
      }
    }
    _cc_out << "\n\n";
  }
  
  // include design libraries here...
  _publish_cc_phony_library();

  _cc_out << object << ": $(DEPENDS) ";
  // include design libraries here...
  _publish_cc_library_series();
  _cc_out << "\n";

  _cc_out << "\t$(CXX) -g $^\\\n";
  _cc_out << "\t$(LDFLAGS) $(LOADLIBES)\\\n";
  _cc_out << "\t$(LIBVHDL) $(LIBTW)\\\n";
  _cc_out << "\t-o $@\n\n";

  _cc_out << "shared:\n";
  _cc_out << "\t$(MAKE) -C $(VHDLDIR) shared\n\n";

  _cc_out << "debug: $(DEPENDS)\n";
  _cc_out << "\t$(CXX) -g $^\\\n";
  _cc_out << "\t$(LIBTW) $(LIBVHDL)\\\n";
  _cc_out << "\t$(LDFLAGS) $(LOADLIBES)\\\n";
  _cc_out << "\t-o $@\n\n";
  
  _cc_out << "# TyVis knows how to build warped for us if we need it\n";
  _cc_out << "$(LIBTW): \n"
	  << "\t$(MAKE) -C $(VHDLDIR)\n\n";

  _cc_out << "$(LIBCOMMON): \n"
	  << "\t$(MAKE) -C $(VHDLDIR)\n\n";

  _cc_out << "$(LIBVHDL): \n"
	  << "\t$(MAKE) -C $(VHDLDIR)\n\n";
  
  _cc_out << "pure: $(DEPENDS)  ";

  // publish all the libraries with the path in the dependency
  _publish_cc_library_series();

  _cc_out << "\n";
  _cc_out << "\t/local/packages/pure/bin/purify $(CXX) -g $^\\\n";
  _cc_out << "\t$(LDFLAGS) $(LOADLIBES)\\\n";
  _cc_out << "\t-o " << object << ".pure\n\n"; 
    
  // publish targets for the design libraries
  _publish_cc_additional_library();

    
  _cc_out << "depend: cleandep\n"
	  << "\t makedepend -p$(VHDLDIR)/ -f- -- $(CPPFLAGS) $(CXXFLAGS)"
	  << " -- $(DEPENDINC) $(SIMSRCS) > .depend\n";
//   _cc_out << "\t$(MAKE) -C $(COMMONDIR) depend\n";
//   _cc_out << "\t$(MAKE) -C $(TWDIR) depend\n";
//   _cc_out << "\t$(MAKE) -C $(VHDLDIR) depend\n";
// publish make depend for the design libraries
  _publish_cc_depend_library();

  _cc_out << "cleandep:\n"
	  << "\t-rm -f .depend\n\n";
  
  _cc_out << "clean:\n";
  _cc_out << "\trm -rf -f *~ \\#*\\# ;\n";
  _cc_out << "\trm -f *.o " << object << " " << object
	  << ".pure " << object << ".quant\n";
//   _cc_out << "\t$(MAKE) -C $(TWDIR) clean\n";
//   _cc_out << "\t$(MAKE) -C $(VHDLDIR) clean\n";
//   _cc_out << "\t$(MAKE) -C $(COMMONDIR) clean\n";
  //publish make clean for the design-libraries 
  _publish_cc_clean_library();
  
  _cc_out << "-include .depend\n";
  
  delete [] object;
}


IIR_Char*
IIRScram_DesignFile::_get_top_level_design_unit_name() {
  ostrstream objectname;
  if(_current_configuration_name != NULL) {
    objectname << "SCFG" 
	       << _current_configuration_name << "_"
	       << _current_entity_name << "_" 
	       << _current_architecture_name << "_elab" << ends;
  }
  else if((_current_entity_name != NULL) && (_current_architecture_name != NULL)) {
    objectname << "SEA";
    objectname << _current_entity_name << "_" << _current_architecture_name;
    objectname << "_elab" << ends;
  }
  else {
    objectname << "_savant_entity_elab" << ends;
  }
  // This will most likely leak...
  return objectname.str();
}


void
IIRScram_DesignFile::_publish_cc_mainNew() {
  char *design_unit_name = _get_top_level_design_unit_name();

  //Lot of work needed in this function
  _cc_out.set_file(TRUE, "main.cc");

  _cc_out << "#include <iostream.h>\n"
          << "#include <fstream.h>\n"
	  << "#include \"warped.hh\"\n"
          << "#include \"config.hh\"\n"
	  << "extern \"C\" int atoi(const char*);\n\n";

  _cc_out << "#ifdef SEQUENTIAL\n"
	  << "#include \"SequentialLP.hh\"\n"
	  << "#define OBJTYPE BaseSequential\n"
	  << "#else\n"
	  << "#include \"LogicalProcess.hh\"\n"
	  << "#define OBJTYPE BasicTimeWarp\n"
	  << "#endif\n\n";

  _cc_out << "#include \"" << design_unit_name << ".hh\"\n"
	  << "int globalobjectid = 0;\n\n";

  // More work needed in getting the number of processes
  _cc_out << "/" << "/" << "This can work only for small examples\n"
	  << "OBJTYPE* proc_array[500];\n";

#ifdef PROCESS_GRAPH
    if (signal_graph == TRUE) {
      _cc_out  << "fstream fp(\"processGraph.dat\", ios::in|ios::out);\n";
    }
#endif

  // This stuff has moved into the kernel for shared libraries and stuff.
//   _cc_out << "typedef VHDLType* (*ResolutionFnPtr)(VHDLKernelBase*, int, VHDLType**);\n"
// 	  << "typedef VHDLType* (*TypeConversionFnPtr)(VHDLKernelBase*, VHDLType*);\n";
// 	  << "ResolutionFnPtr *savantResolutionFn;\n"
// 	  << "TypeConversionFnPtr *savantTypeConversionFn;\n";

  _cc_out << "#ifdef SEQUENTIAL\n"
	  << "const VTime SequentialLP::SIMUNTIL = VTime::getMax();\n"
	  << "#else \n"
	  << "const VTime LogicalProcess::SIMUNTIL = VTime::getMax();\n"
	  << "#endif\n";

  // Publish the method getNumberOfLPs() that is needed while running parallel
  _cc_out << "#ifndef SEQUENTIAL\n";
  _cc_out << "#include <stdlib.h>\n";
  
  _cc_out << "int getNumberOfLPs(int argc, char *argv[])  {\n"
	  << "  for(int i = 1; (i < argc); i++)  {\n"
	  << "    if (strcmp(argv[i], \"-lp\") == 0)  {\n"
	  << "      return atoi(argv[i + 1]);\n"
	  << "    }\n"
	  << "  }\n"
	  << "  return 1;\n"
	  << "}\n\n";
  
  _cc_out << "#endif\n";
  
  _cc_out << "main(int argc, char *argv[]) {\n"
	  << "OBJTYPE* btwptr;\n"
	  << "globalobjectid = 0;\n";
  _cc_out << "#ifndef SEQUENTIAL\n"
	  << "  int id = 0;\n"
	  << "  physicalCommInit(&argc, &argv);\n"
	  << "  id = physicalCommGetId();\n"
	  << "#endif\n\n";
  
  if((_current_entity_name != NULL) && (_current_architecture_name != NULL)) {
    _cc_out << design_unit_name << "  design;\n";  
    _cc_out << "design.instantiate();\n"
	    << "design.connect(0,0);\n";
  }
#ifdef PROCESS_GRAPH
  if (signal_graph == TRUE) {
    _cc_out << "//Store the number of objects\n";
    _cc_out << "fp << \"Number of Objects: \" << globalobjectid << endl;" << endl;
    _cc_out << "//Store the object name's and id's\n";
    _cc_out << "  for(int j = 0; j < globalobjectid; j++) {" << endl
	    << "     fp << \"ObjectName: \" << proc_array[j]->name << endl;" << endl
	    << "     fp << \"ObjectId  : \" << proc_array[j]->id << endl;" << endl
	    << "  }\n";
  }
#endif
  _cc_out << "    if ( argc == 2 && atoi(argv[1]) == 0) {\n"
	  << "      cout << \"Usage: \" << argv[0] << \""
	  << "[termination time]\\n\";\n"
	  << "      cout << \"Invalid simulation termination time\\n\";\n\n" 
	  << "      exit(-1);\n" << "}\n"
	  << "#ifdef SEQUENTIAL\n"
	  << "  SequentialLP lp(globalobjectid, globalobjectid, 1);\n";
  _cc_out << "for(int i = 0; i < globalobjectid; i++) {\n"
	  << "  btwptr = proc_array[i];\n"
	  << "  lp.registerObject(btwptr);\n"
	  << "}\n"
	  << "  lp.allRegistered();\n"
	  << "  if( argc == 2 ){\n";
  _cc_out << "    lp.simulate( atoi(argv[1]) );\n"
	  << "  }\n"
	  << "  else {\n"
	  << "    lp.simulate();\n"
	  << "  }\n"
	  << "/" << "/" << "delete lp1;\n"
	  << "for(int j=0; j< globalobjectid; j++) {\n"
	  << " delete proc_array[j];\n"
	  << " }\n"
	  << "#else\n\n"
	  << "#ifdef MESSAGE_AGGREGATION\n"
	  << "  getMessageManagerParameters(argc, argv);\n"
	  << "#endif\n\n"
	  << "  int numberOfLPs = getNumberOfLPs(argc, argv);\n"
	  << "  if ((numberOfLPs <= 0) || (numberOfLPs > globalobjectid))  {\n"
	  << "     cerr << \"Number of LPs should be > 0 and < \""
	  << " << globalobjectid << \"\n\";\n"
	  << "     exit(-1);\n"
	  << "  }\n\n";

  _cc_out << "  // Find out the process from where this LP has to hold\n"
	  << "  int processStart = 0, numProcesses = globalobjectid;\n"
	  << "  if (numberOfLPs > 1)  {\n"
	  << "     processStart = (globalobjectid / numberOfLPs) * id;\n"
	  << "  }\n"
	  << "  if (numberOfLPs > 1)  {\n"
	  << "     numProcesses = (globalobjectid / numberOfLPs);\n"
	  << "     if (id == numberOfLPs - 1)  {\n"
	  << "        // Add any remaining processes that may remain\n"
	  << "        numProcesses += globalobjectid - (numProcesses * "
	  << "numberOfLPs);\n"
	  << "     }\n"
	  << "  }\n";

  _cc_out << "  LogicalProcess lp(globalobjectid, numProcesses, numberOfLPs);\n";
  _cc_out << "  for(int j = 0; (j < numProcesses); j++)  {\n"
	  << "    btwptr = proc_array[j + processStart];\n"
	  << "    lp.registerObject(btwptr);\n"
	  << "  }\n\n";

  _cc_out << "  lp.allRegistered();\n"
	  << "  lp.simulate();\n\n";

  _cc_out << "  for(int i = 0; (i < globalobjectid); i++)  {\n"
	  << "    if ((i < processStart) || "
	  << " (i >= (processStart + numProcesses)))  {\n"
	  << "      proc_array[i]->finalGarbageCollect();\n"
	  << "    }\n"
	  << "    delete proc_array[i];\n"
	  << "  }\n\n";
  
  _cc_out << "#endif\n\n";

  _cc_out << "}\n";
  
  delete [] design_unit_name;
}

void 
IIRScram_DesignFile::_set_file_name( char *new_file_name ){
  set_name( IIR_Identifier::get( new_file_name, strlen( new_file_name ) ) );
}


#ifdef PROCESS_COMBINATION
IIR_ArchitectureDeclaration *
IIRScram_DesignFile::_static_elaborate_design() {
  IIR_LibraryUnit *lib_unit = library_units.first();
  IIR_EntityDeclaration *ent;
  // I sure hope component hierarchies aren't any longer than this!
  char hier_location[1024]; 

#ifdef DEBUG_ELAB
  cout << "Elaborating " << entity_name << " " << arch_name << " "
       << config_name << "\n";
#endif
  
  if (config_name != NULL) {
    cout << "Sorry, top-level configurations not supported yet\n";
    exit(1);
  }

  while (lib_unit != NULL) {
    if (lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
      if (!IIR_TextLiteral::_cmp(lib_unit->get_declarator(), arch_name)) {
	IIR_ArchitectureDeclaration *arch, *newarch;
	IIR_DeclarationList *cfglist = NULL;
	arch = (IIR_ArchitectureDeclaration*)lib_unit;

	ent = arch->get_entity();
	if (!IIR_TextLiteral::_cmp(ent->get_declarator(), entity_name)) {
	  // we've found the correct entity/arch pair now
	  hier_location[0] = 'v';
	  hier_location[1] = '_';
	  hier_location[2] = '\0';
	  newarch = new IIR_ArchitectureDeclaration;
	  arch->_clone(newarch);
	  newarch->set_entity(ent);
	  arch->_static_elaborate( newarch, cfglist, hier_location );
	  library_units._replace( arch, newarch );
	  return newarch;
	}
      }
    }
    lib_unit = library_units.successor(lib_unit);
  }
  cout << "Error: couldn't find specified design entity.\n";
  return NULL;
}
#endif

symbol_table *
IIRScram_DesignFile::_get_symbol_table(){
  ASSERT( _my_parser != NULL );
  ASSERT( _my_parser->get_symbol_table() != NULL );
  return _my_parser->get_symbol_table();
}



void
IIRScram_DesignFile::_publish_cc_design_library_makefile(){
  ostrstream target;
  char *targetstr;
  _cc_out.set_file(TRUE, "Makefile");


  target << design_library_name << "._savant_lib.a" << ends;
  targetstr = target.str();
  //publish the sources in the makefile in the design library
  _cc_out << "#-*-makefile-*-\n";
  _cc_out << " AR = ar cr \n\n";
  _cc_out << "include " << _get_library_manager()->get_savant_root_directory()
	  << "/lib/Makefile.common\n"
	  << "CPPFLAGS+=$(SIMCPPFLAGS)\n"
	  << "CXXFLAGS+=$(SIMCXXFLAGS)\n";
  _cc_out << "VHDLSRCS = $(wildcard *.cc)\n\n";
  _cc_out << "VHDLOBJS = $(patsubst %.cc,%.o, $(VHDLSRCS))\n\n";

  //publish the path to the design libraries
  _publish_cc_library_path();
  // publish the phone thing for the design libraries.
  _publish_cc_phony_library();
  // publish the target for the design library when make calls it, it should
  // execute that part. 
  _publish_cc_target_design_library();
  // publishes the target for the additional design libraries.
  _publish_cc_additional_library();

  // publish the depend rule of "make depend"
  _cc_out << "depend:\n\tmakedepend -- $(CPPFLAGS) $(CXXFLAGS) -- $(DEPENDINC) $(VHDLSRCS)\n";;

  _publish_cc_depend_library();

  //publish the clean rule of "make clean"
  _cc_out << "clean:\n";
  _cc_out << "\trm -rf -f *~ \\#*\\# ;\n";
  _cc_out << "\trm -f *.o " << targetstr << "\n";
  // publish the clean rule part for the additional design libraries included
  _publish_cc_clean_library();
  delete [] targetstr;
}

void
IIRScram_DesignFile::_publish_cc_library_path(){
  int iteration = 1;
  char *libName = use_list.first();
  while(libName != NULL && (strcasecmp(libName, "work") != 0)){
    _cc_out << "DESIGN_LIB_DIR" << iteration << " = ";
    _cc_out << "$(DESIGN_LIB)/" << libName << "._savant_lib\n";
    iteration++;
    libName = use_list.successor(libName);
  }
  _cc_out << "\n\n";

  iteration = 1;
  libName = use_list.first();
  _cc_out << "CPPFLAGS += ";
  while ((libName != NULL) && ((strcasecmp(libName, "work") != 0))) {
    _cc_out << "-I$(DESIGN_LIB_DIR" << iteration << ") ";
    iteration++;
    libName = use_list.successor(libName);
  }
  _cc_out << "\n\n";
}

void
IIRScram_DesignFile::_publish_cc_phony_library(){
  int iteration = 1;
  char *libName = use_list.first();
  while(libName != NULL && (strcasecmp(libName, "work") != 0)){
    _cc_out << ".PHONY: ";
    _cc_out << "$(DESIGN_LIB_DIR" << iteration << ")/";
    _cc_out << libName << "._savant_lib.a\n";
    iteration++;
    libName = use_list.successor(libName);
  }
  _cc_out << "\n\n";
}

void
IIRScram_DesignFile::_publish_cc_target_design_library(){
  _cc_out << "all: " << design_library_name << "._savant_lib.a\n\n";
  
  _cc_out << design_library_name << "._savant_lib.a"
	  << ": $(VHDLOBJS) ";
  // include design libraries here...
  //_publish_cc_library_series();
  
  _cc_out << "\n\t-rm -f " << design_library_name << "._savant_lib.a\n";
  _cc_out << "\t$(AR) " << design_library_name << "._savant_lib.a $^\n\n";
  
  _cc_out << "%.o : %.cc\n";
  _cc_out << "\t$(CXX) -c $(CPPFLAGS) $(CXXFLAGS) $< -o $@\n\n";
}


void
IIRScram_DesignFile::_publish_cc_additional_library(){
  int iteration = 1;
  char *libName = use_list.first();
  
  while(libName != NULL && (strcasecmp(libName, "work") != 0)){
    _cc_out << "$(DESIGN_LIB_DIR" << iteration << ")/";
    _cc_out << libName << "._savant_lib.a:\n";
    _cc_out << "\t$(MAKE) -C $(DESIGN_LIB_DIR" << iteration << ")\n\n";
    iteration++;
    libName = use_list.successor(libName);
  }
}

void
IIRScram_DesignFile::_publish_cc_depend_library(){
  
  int iteration = 1;
  char *libName = use_list.first();
  
  while(libName != NULL && (strcasecmp(libName, "work") != 0)){
    _cc_out << "\t$(MAKE) -C $(DESIGN_LIB_DIR" << iteration << ")"
	    << " depend\n";
    iteration++;
    libName = use_list.successor(libName);
  }
  _cc_out << "\n";
}

void
IIRScram_DesignFile::_publish_cc_clean_library(){
  int iteration = 1;
  char *libName = use_list.first();
  
  while(libName != NULL && (strcasecmp(libName, "work") != 0)){
    _cc_out << "\t$(MAKE) -C $(DESIGN_LIB_DIR" << iteration << ")"
	    << " clean\n";
    iteration++;
    libName = use_list.successor(libName);
  }
  _cc_out << "\n";
}

void
IIRScram_DesignFile::_publish_cc_library_series(){
  int iteration = 1;
  char *libName = use_list.first();

  while ( libName != NULL && (strcasecmp(libName, "work") != 0)){
    _cc_out << "$(DESIGN_LIB_DIR" << iteration << ")/" << libName
	    << "._savant_lib.a " ;
    iteration++;
    libName = use_list.successor(libName);
  }
}
