#ifndef IIRSCRAM_ACTIVE_ATTRIBUTE_HH
#define IIRSCRAM_ACTIVE_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ActiveAttribute.hh,v 1.4 1999/10/28 03:24:05 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ActiveAttribute.hh"

class IIRScram_ActiveAttribute : public IIRBase_ActiveAttribute {
public:
  void _publish_vhdl(ostream &);

  IIR_TextLiteral *_build_attribute_name();
  IIR_TypeDefinition *_get_subtype();
  IIR_Declaration *_get_implicit_declaration( char *, IIR_TypeDefinition * );
  void _publish_cc();
  void _publish_cc_necessary_decl_in_state();
  void _publish_cc_name_in_caps();
  void _publish_cc_attrib_type();
  void _publish_cc_necessary_decl_init();
  void _publish_cc_init_val();
  void _publish_cc_elaborate();
  void _publish_cc_sigtype();
  void _publish_cc_state_object_init();
  void _publish_cc_init();  
  void _publish_cc_necessary_copying();
  void _publish_cc_read_or_write(const char *, const char *);
  
  virtual IIR_Boolean _is_active_attribute() { return TRUE; }
  IIR_Boolean _is_function_attribute(){ return TRUE; }
  IIR_Boolean _is_signal_attribute(){ return TRUE; }
  virtual IIR* _clone();

protected:
  IIRScram_ActiveAttribute() {}
  virtual ~IIRScram_ActiveAttribute() = 0;
    
private:
  // If our prefix's prefix has a composite type, then it needs it's active
  // attribute enabled as well...
  IIR_Boolean _need_to_process_prefix_prefix(){
    return _need_to_process_prefix_prefix_signal_attribute();
  }
};
#endif
