// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fvcontour_h__
#define __fvcontour_h__

#include "vector.h"
#include "contour.h"

class FVContour : public Contour {
 private:
  enum {top, right, bottom, left, none};

  float resolution;

  void unity(FitsImage*);
  void bin(FitsImage*);
  void smooth(FitsImage*);
  void convolve(FitsImage*, float*, float*, int);
  float* tophat(int);
  float* gaussian(int);
  int build(int xdim, int ydim, float *image, Matrix&);
  int trace(int xdim, int ydim, float cntr,
	    int xCell, int yCell, int side,
	    float** rows, char* useGrid, Matrix&);

public:
  FVContour(FrameBase*, FitsImage*, const char*, int, float, int, ContourScale*);

  void append(FitsImage*);
};

#endif
