#! /bin/sh

#linux commands
#ipcs -m
#ipcs -ml
#ipcrm shm <shmid>
#echo '67108864' > /proc/sys/kernel/shmmax

KillIt () {
    i=1
    while [ "$i" -le 15 ]
    do
        sleep 1
        if [ `xpaaccess ds9` = yes ]
        then
	    sleep 1
	    xpaset -p ds9 quit
	    break
        fi

        i=`expr $i + 1`
    done
}

DoCmd () {
    echo "$1"
    shmid=`shmload -q $2`
    ../ds9 -scale $5 -scale mode $6 -shm $3 shmid $shmid $4 &
    KillIt
    ipcrm -m $shmid
}

DoSCmd () {
    echo "$1"
    shmid1=`shmload -q $2`
    shmid2=`shmload -q $3`
    ../ds9  -scale $6 -scale mode $7 -shm $4 shmid $shmid1 $shmid2 $5 &
    KillIt
    ipcrm -m $shmid1
    ipcrm -m $shmid2
}

DoXPA () {
    echo "$1"
    shmid=`shmload -q $2`
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    xpaset -p ds9 shm $3 shmid $shmid $4
    sleep 1
    xpaset -p ds9 frame clear
    ipcrm -m $shmid
}

DoSXPA () {
    echo "$1"
    shmid1=`shmload -q $2`
    shmid2=`shmload -q $3`
    xpaset -p ds9 scale $6
    xpaset -p ds9 scale mode $7
    xpaset -p ds9 shm $4 shmid $shmid1 $shmid2 $5
    sleep 1
    xpaset -p ds9 frame clear
    ipcrm -m $shmid1
    ipcrm -m $shmid2
}

echo "Current shm limits"
ipcs -lm

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Command Line Shm Tests"

# basics
DoCmd "..fits" img16.fits fits foo linear zscale
DoSCmd "..sfits" sfits.hdr sfits.arr sfits foo linear zscale
DoCmd "..table" table.fits "" foo log minmax
DoCmd "..table filter" table.fits "" 'foo[bin=rawx,rawy]' log minmax

# mosaic
DoCmd "..mosaic image iraf" mosaicimage.fits "mosaicimage iraf" foo linear zscale
DoCmd "..mosaic image iraf datacube" naxis4.fits "mosaicimage iraf" foo linear zscale
DoCmd "..mosaic image wcs" mosaicimage.fits "mosaicimage wcs" foo linear zscale
DoCmd "..mosaic image wcsp" ds9_8amp_2x2.fits "mosaicimage wcsp" foo linear minmax
DoCmd "..mosaic image wfpc2" hst.fits "mosaicimage wfpc2" foo linear zscale
DoCmd "..mosaic iraf" mosaicimage.fits "mosaic iraf" foo linear zscale
DoCmd "..mosaic iraf datacube" naxis4.fits "mosaic iraf" foo linear zscale
DoCmd "..mosaic wcs" mosaicimage.fits "mosaic wcs" foo linear zscale
DoCmd "..mosaic wcsp" ds9_8amp_2x2.fits "mosaic wcsp" foo linear minmax
DoSCmd "..mosaic wcs sfits" sfits.hdr sfits.arr "smosaic wcs" foo linear zscale

# backward compatibility
DoCmd "..mosaic image iraf(bc)" mosaicimage.fits mosaicimageiraf foo linear zscale
DoCmd "..mosaic image wcs(bc)" mosaicimage.fits mosaicimagewcs foo linear zscale
DoCmd "..mosaic image wfpc2(bc)" hst.fits mosaicimagewfpc2 foo linear zscale
DoCmd "..mosaic iraf(bc)" mosaicimage.fits mosaiciraf foo linear zscale
DoCmd "..mosaic wcs(bc)" mosaicimage.fits mosaicwcs foo linear zscale

# array
DoCmd "..array" array.arr array 'foo[dim=512,bitpix=-32,arch=bigendian]' linear minmax
DoCmd "..array cube" cube.arr array 'foo[dim=512,zdim=3,bitpix=-32,arch=bigendian]' linear minmax

# rgb
DoCmd "..rgbcube" rgbcube.fits rgbcube foo linear minmax
DoSCmd "..rgbcube sfits" rgb.hdr rgb.arr srgbcube foo linear minmax
DoCmd "..rgbimage" rgbimage.fits rgbimage foo linear minmax

echo "PASSED"
fi

if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "XPA Shm Tests"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]
then
    ../ds9&
fi

i=1
while [ "$i" -le 15 ]
do
    sleep 1
    if [ `xpaaccess ds9` = yes ]
    then
	break
    fi

    i=`expr $i + 1`
done

# basics
DoXPA "..fits" img16.fits fits foo linear zscale 
DoSXPA "..split fits" sfits.hdr sfits.arr sfits foo linear zscale
DoXPA "..table" table.fits "" foo log minmax
DoXPA "..table filter" table.fits "" 'foo[bin=rawx,rawy]' log minmax

# mosaics
DoXPA "..mosaic image iraf" mosaicimage.fits "mosaicimage iraf" foo linear zscale
DoXPA "..mosaic image iraf datacube" naxis4.fits "mosaicimage iraf" foo linear zscale
DoXPA "..mosaic image wcs" mosaicimage.fits "mosaicimage wcs" foo linear zscale
DoXPA "..mosaic image wcsp" ds9_8amp_2x2.fits "mosaicimage wcs" foo linear minmax
DoXPA "..mosaic image wfpc2" hst.fits "mosaicimage wfpc2" foo linear zscale
DoXPA "..mosaic iraf" mosaicimage.fits "mosaic iraf" foo linear zscale
DoXPA "..mosaic iraf datacube" naxis4.fits "mosaic iraf" foo linear zscale
DoXPA "..mosaic wcs" mosaicimage.fits "mosaic wcs" foo linear zscale
DoXPA "..mosaic wcsp" ds9_8amp_2x2.fits "mosaicimage wcs" foo linear minmax
DoSXPA "..sfits mosaic wcs" sfits.hdr sfits.arr "smosaic wcs" foo linear zscale

# backward compatibility
DoXPA "..mosaic image iraf(bc)" mosaicimage.fits mosaicimageiraf foo linear zscale
DoXPA "..mosaic image wcs(bc)" mosaicimage.fits mosaicimagewcs foo linear zscale
DoXPA "..mosaic image wfpc2(bc)" hst.fits mosaicimagewfpc2 foo linear zscale
DoXPA "..mosaic iraf(bc)" mosaicimage.fits mosaiciraf foo linear zscale
DoXPA "..mosaic wcs(bc)" mosaicimage.fits mosaicwcs foo linear zscale

# array
DoXPA "..array" array.arr array 'foo[dim=512,bitpix=-32,arch=bigendian]' linear minmax
DoXPA "..array cube" cube.arr array 'foo[dim=512,bitpix=-32,zdim=3,arch=bigendian]' linear minmax

# rgb
xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA "..rgbcube" rgbcube.fits rgbcube foo linear minmax
DoSXPA "..sfits rgbcube" rgb.hdr rgb.arr srgbcube foo linear minmax
DoXPA "..rgbimage" rgbimage.fits rgbimage foo linear minmax
xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

echo "DONE"



